/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen.openhandle;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.negopen.ISrcNegOpenHandler;
import kd.scm.src.common.negopen.SrcNegOpenContext;

public class SrcNegBillStatusHandler
implements ISrcNegOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcNegOpenContext context) {
        this.updateNegOpenStatus(context);
        this.updateNegEntryStatus(context);
    }

    protected void updateNegOpenStatus(SrcNegOpenContext context) {
        context.getNegBillObj().set("isquotebidopen", (Object)true);
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])new DynamicObject[]{context.getNegBillObj()});
    }

    protected void updateNegEntryStatus(SrcNegOpenContext context) {
        for (DynamicObject row : context.getNegEntryRows()) {
            if (!context.isOffline() && !row.getString("entrystatus").equals(ProjectStatusEnums.QUOTED.getValue())) continue;
            if (context.isOffline()) {
                row.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
                row.set("quotedate", (Object)TimeServiceHelper.now());
                continue;
            }
            if (!row.getBoolean("isdiscarded")) {
                row.set("entrystatus", (Object)ProjectStatusEnums.QUOTED.getValue());
                row.set("quotedate", (Object)TimeServiceHelper.now());
                continue;
            }
            row.set("entrystatus", (Object)ProjectStatusEnums.DISCARDED.getValue());
        }
        for (Map.Entry<String, DynamicObject> entry : context.getCompKey_compObjMap().entrySet()) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)entry.getValue());
        }
    }
}

