/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen.openhandle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.negopen.ISrcNegOpenHandler;
import kd.scm.src.common.negopen.SrcNegOpenContext;
import org.apache.commons.lang.StringUtils;

public class SrcNegOpenTenderSupplierHandler
implements ISrcNegOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcNegOpenContext context) {
        if (!StringUtils.equals((String)SrcNegotiatetypeEnums.OFFLINE_PURLIST.getValue(), (String)context.getNegotiateType())) {
            return;
        }
        boolean isByPackage = "2".equals(context.getNegBillObj().getString("project.managetype"));
        DynamicObject[] rows = this.getTenderSuppliers(context);
        if (rows.length == 0) {
            return;
        }
        this.updateTenderSupplier(context, rows, isByPackage);
        this.deleteTenderSupplier(context, rows, isByPackage);
    }

    public void updateTenderSupplier(SrcNegOpenContext context, DynamicObject[] rows, boolean isByPackage) {
        Set<String> pkgSupSet = this.getPkgSupSet(context, true, isByPackage);
        if (pkgSupSet.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(rows.length);
        for (DynamicObject row : rows) {
            String pkgSupkey = this.getPkgSupkey(row, isByPackage);
            if (!pkgSupSet.contains(pkgSupkey)) continue;
            row.set("istender", (Object)"1");
            rowList.add(row);
        }
        PdsCommonUtils.saveDynamicObjects(rowList);
    }

    public void deleteTenderSupplier(SrcNegOpenContext context, DynamicObject[] rows, boolean isByPackage) {
        Set<String> allPkgSupSet = this.getPkgSupSet(context, false, isByPackage);
        if (allPkgSupSet.size() == 0) {
            return;
        }
        HashSet<Long> pkIdSet = new HashSet<Long>();
        for (DynamicObject row : rows) {
            String pkgSupkey = this.getPkgSupkey(row, isByPackage);
            if (allPkgSupSet.contains(pkgSupkey)) continue;
            pkIdSet.add(row.getLong("id"));
        }
        if (pkIdSet.size() > 0) {
            QFilter qfilter = new QFilter("id", "in", pkIdSet);
            DeleteServiceHelper.delete((String)"src_bidopensupplier", (QFilter[])qfilter.toArray());
        }
    }

    public DynamicObject[] getTenderSuppliers(SrcNegOpenContext context) {
        QFilter qfilters = new QFilter("billid", "=", (Object)context.getProjectId());
        qfilters.and("istender", "=", (Object)"0");
        qfilters.and("source", "=", (Object)"9");
        return BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"package,supplier,istender", (QFilter[])qfilters.toArray());
    }

    public Set<String> getPkgSupSet(SrcNegOpenContext context, boolean isByTurns, Boolean isByPackage) {
        QFilter qfilters = new QFilter("project", "=", (Object)context.getProjectId());
        qfilters.and("supplier", ">", (Object)0);
        if (isByTurns) {
            qfilters.and("turns", "=", (Object)context.getTurns());
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id,supplier.id", (QFilter[])qfilters.toArray());
        if (isByPackage.booleanValue()) {
            return rows.stream().map(e -> e.getString("package.id") + '|' + e.getString("supplier.id")).collect(Collectors.toSet());
        }
        return rows.stream().map(e -> e.getString("supplier.id")).collect(Collectors.toSet());
    }

    public String getPkgSupkey(DynamicObject row, boolean isByPackage) {
        if (isByPackage) {
            return row.getString("package.id") + '|' + row.getString("supplier.id");
        }
        return row.getString("supplier.id");
    }
}

