/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen.openhandle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.src.common.negopen.ISrcNegOpenHandler;
import kd.scm.src.common.negopen.SrcNegOpenContext;
import kd.scm.src.common.util.SrcNegotiateUtil;

public class SrcNegWriteBackHandler
implements ISrcNegOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcNegOpenContext context) {
        this.writeBackFromQuoteBill(context);
    }

    protected void writeBackFromQuoteBill(SrcNegOpenContext context) {
        for (Map.Entry<String, DynamicObject> entry : context.getCompKey_compObjMap().entrySet()) {
            DynamicObject compObj = entry.getValue();
            DynamicObjectCollection entryRows = compObj.getDynamicObjectCollection("entryentity");
            if (null == entryRows || entryRows.size() == 0) continue;
            this.writeBackNegotiateData(context, entryRows, context.getNegId_quoteEntryMap());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compObj});
        }
    }

    private void writeBackNegotiateData(SrcNegOpenContext context, DynamicObjectCollection negEntryRows, Map<String, DynamicObject> negId_quoteEntryMap) {
        if (negId_quoteEntryMap == null) {
            return;
        }
        List<String> writebackFieldList = null;
        HashMap<String, List<String>> compKeyWriteBackListMap = new HashMap<String, List<String>>(negEntryRows.size());
        for (DynamicObject negEntryRow : negEntryRows) {
            String Key = negEntryRow.getString("id");
            DynamicObject compKeyObj = negEntryRow.getDynamicObject("compkey");
            DynamicObject quoteEntryRow = negId_quoteEntryMap.get(Key);
            if (null == quoteEntryRow) continue;
            String compKey = null == compKeyObj ? "" : compKeyObj.getString("number");
            writebackFieldList = (List<String>)compKeyWriteBackListMap.get(compKey);
            if (null == writebackFieldList) {
                writebackFieldList = this.getWriteBackFieldList(context, compKey, "entryentity");
                compKeyWriteBackListMap.put(compKey, writebackFieldList);
            }
            for (int i = 0; i < writebackFieldList.size(); ++i) {
                try {
                    DataEntityPropertyCollection proCols = quoteEntryRow.getDataEntityType().getProperties();
                    if (proCols.isEmpty()) continue;
                    if (proCols.get((Object)writebackFieldList.get(i)) instanceof MulBasedataProp) {
                        SrcNegotiateUtil.setFJVal(negEntryRow, quoteEntryRow, writebackFieldList.get(i));
                        continue;
                    }
                    negEntryRow.set(writebackFieldList.get(i), quoteEntryRow.get(writebackFieldList.get(i)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            negEntryRow.set("entrystatus", quoteEntryRow.get("entrystatus"));
        }
    }

    protected List<String> getWriteBackFieldList(SrcNegOpenContext context, String compKey, String compEntryKey) {
        ArrayList writebackFieldList = context.getCompKey_compConfigMap().get(compKey);
        if (null == writebackFieldList && null != context.getQuotebillObjs() && context.getQuotebillObjs().length > 0) {
            writebackFieldList = PdsCompConfigUtil.getPros((DynamicObject)context.getQuotebillObjs()[0], (String)compKey, (String)"entryentity", (String)"iswriteback", (boolean)true);
            if (null == writebackFieldList) {
                writebackFieldList = new ArrayList();
            } else {
                this.addSpecialWriteBackField(writebackFieldList);
            }
            context.getCompKey_compConfigMap().put(compKey, writebackFieldList);
        }
        if (null == writebackFieldList) {
            return new ArrayList<String>();
        }
        return writebackFieldList;
    }

    protected void addSpecialWriteBackField(List<String> writebackFieldList) {
        if (!writebackFieldList.contains("quotedate")) {
            writebackFieldList.add("quotedate");
        }
        if (writebackFieldList.contains("taxitem")) {
            writebackFieldList.add("taxrate");
        }
        if (writebackFieldList.contains("reply")) {
            writebackFieldList.add("replyvalue");
        }
        ArrayList<String> calPros = new ArrayList<String>(8);
        calPros.add("qty");
        calPros.add("price");
        calPros.add("taxprice");
        calPros.add("amount");
        calPros.add("taxamount");
        calPros.add("tax");
        calPros.add("dctamount");
        if (writebackFieldList.contains("taxprice") || writebackFieldList.contains("price") || writebackFieldList.contains("amount") || writebackFieldList.contains("taxamount") || writebackFieldList.contains("qty")) {
            for (String calPro : calPros) {
                if (writebackFieldList.contains(calPro)) continue;
                writebackFieldList.add(calPro);
            }
        }
    }
}

