/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen.prepare;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.src.common.negopen.ISrcNegOpenPrepare;
import kd.scm.src.common.negopen.SrcNegOpenContext;
import org.apache.commons.lang.StringUtils;

public class SrcQuoteEntryPrepare
implements ISrcNegOpenPrepare {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcNegOpenContext context) {
        this.getQuoteEntryMapByNegId(context);
    }

    protected void getQuoteEntryMapByNegId(SrcNegOpenContext context) {
        if (context.getNegEntryIds().isEmpty()) {
            return;
        }
        Set negEntryIds = context.getNegEntryIds().stream().map(e -> String.valueOf(e)).collect(Collectors.toSet());
        QFilter quoteFilter = new QFilter("entryentity.srcentryid", "in", negEntryIds);
        if (StringUtils.equals((String)SrcNegotiatetypeEnums.ONLINE.getValue(), (String)context.getNegotiateType()) || StringUtils.equals((String)SrcNegotiatetypeEnums.ONLINE_VIE.getValue(), (String)context.getNegotiateType())) {
            quoteFilter = quoteFilter.and("entryentity.entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
        }
        HashMap<String, DynamicObject> negId_quoteEntryMap = new HashMap<String, DynamicObject>(8);
        for (String compKey : context.getCompKey_compObjMap().keySet()) {
            QFilter compFilter;
            String selectFields;
            DynamicObject[] rows = BusinessDataServiceHelper.load((String)compKey, (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)"id", (String)compKey, (String)"entryentity", (boolean)false)), (QFilter[])(compFilter = new QFilter("entitykey", "=", (Object)compKey).and(quoteFilter)).toArray());
            if (null == rows || rows.length == 0) continue;
            for (DynamicObject row : rows) {
                this.getNegId_quoteEntryMap(row, negId_quoteEntryMap);
            }
        }
        context.setNegId_quoteEntryMap(negId_quoteEntryMap);
    }

    private void getNegId_quoteEntryMap(DynamicObject row, Map<String, DynamicObject> negId_quoteEntryMap) {
        DynamicObjectCollection entryRows = row.getDynamicObjectCollection("entryentity");
        if (null == entryRows || entryRows.size() == 0) {
            return;
        }
        for (DynamicObject entryRow : entryRows) {
            String srcEntryId = entryRow.getString("srcentryid");
            negId_quoteEntryMap.putIfAbsent(srcEntryId, entryRow);
        }
    }
}

