/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.patternfilter;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.patternfilter.IPatternFilter;
import kd.scm.src.common.patternfilter.PatternFilterContext;
import kd.scm.src.common.util.SrcAppCache;

public class PatternFilterTaxType
implements IPatternFilter {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PatternFilterTaxType.class);

    public Map<String, Object> getQFilter(PatternFilterContext context) {
        if (!this.isVieOrE_Auction(context)) {
            return null;
        }
        DynamicObject ruleObj = context.getRuleObj();
        if (Objects.isNull(ruleObj)) {
            return null;
        }
        String taxType = this.getTaxType(context);
        if (null == taxType) {
            return null;
        }
        Set<String> excludeTypeSet = this.getExcludeTypeSet(taxType);
        QFilter qfilter = new QFilter("valuefield", "not in", excludeTypeSet);
        return this.getQFilterMap(qfilter, null);
    }

    public String getTaxType(PatternFilterContext context) {
        String taxType = null;
        DynamicObject baseObj = SrcAppCache.getOtherCompObjByCache(context.getView(), null, "src_project_base");
        if (null != baseObj) {
            taxType = baseObj.getString("taxtype");
        } else {
            try {
                taxType = context.getView().getParentView().getModel().getDataEntity().getString("taxtype");
            }
            catch (Exception e) {
                log.error("###get pro exception:" + e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)taxType)) {
            return null;
        }
        return taxType;
    }

    public Set<String> getExcludeTypeSet(String taxType) {
        Set excludeTypeSet = null;
        excludeTypeSet = "2".equals(taxType) ? PdsCommonUtils.buildSet((String[])new String[]{"taxprice", "taxamount", "pkgtaxamount", "loctaxprice", "loctaxamount"}) : PdsCommonUtils.buildSet((String[])new String[]{"price", "amount", "pkgamount", "locprice", "locamount"});
        return excludeTypeSet;
    }

    private boolean isVieOrE_Auction(PatternFilterContext context) {
        DynamicObject sourceTypeObj = context.getProjectObj().getDynamicObject("sourcetype");
        if (sourceTypeObj == null) {
            return false;
        }
        String sourceType = sourceTypeObj.getString("number");
        return SourceTypeEnums.VIE.getValue().equals(sourceType) || SourceTypeEnums.ELECTRONIC_AUCTION.getValue().equals(sourceType);
    }
}

