/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.pushproject;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.pushproject.SrcPushProjectUtils;

public class SrcDemandPushSetDefaultValue
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.setDefaultValue(context);
    }

    public void setDefaultValue(ExtPluginContext context) {
        context.setVerifyOk(false);
        QFilter qfilter = SrcPushProjectUtils.getDemandQFilter(context);
        String selectFileds = DynamicObjectUtil.getSelectfields((String)"src_demandf7two", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_demandf7two", (String)selectFileds, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> purlist_sceneMap = this.getPurlist_SceneMap(rows);
        for (DynamicObject row : rows) {
            DynamicObject sceneObj = purlist_sceneMap.get(row.getLong("id"));
            long sourceFlowId = row.getLong("source.srctype2.id");
            if (null == row.get("entrysrctype2")) {
                if (null == sceneObj || null == sceneObj.get("srcflowconfig")) {
                    row.set("entrysrctype2", (Object)sourceFlowId);
                } else {
                    row.set("entrysrctype2", (Object)sceneObj.getLong("srcflowconfig.id"));
                }
            }
            if (null == sceneObj) continue;
            row.set("scene", (Object)sceneObj.getLong("id"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public Map<Long, DynamicObject> getPurlist_SceneMap(DynamicObject[] rows) {
        DynamicObject[] billObjs;
        HashMap<Long, DynamicObject> sceneMap = new HashMap<Long, DynamicObject>();
        Set billIds = Arrays.asList(rows).stream().map(e -> e.getLong("source.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", billIds);
        for (DynamicObject billObj : billObjs = PdsCommonUtils.loadBillObjsByQFilter((String)"src_demand", (QFilter)qfilter)) {
            DynamicObjectCollection sceneRows = billObj.getDynamicObjectCollection("entry");
            for (DynamicObject sceneRow : sceneRows) {
                Set purlistIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)sceneRow, (String)"decisionitem");
                Iterator iterator = purlistIds.iterator();
                while (iterator.hasNext()) {
                    long purlistId = (Long)iterator.next();
                    if (purlistId <= 0L) continue;
                    sceneMap.put(purlistId, sceneRow);
                }
            }
        }
        return sceneMap;
    }
}

