/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.question;

import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.QuestionTypeEnums;
import kd.scm.pds.common.question.ISrcQuestionButtonVisible;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.question.PdsQuestionUtils;

public class SrcQuestionButtonVisible
implements ISrcQuestionButtonVisible {
    private static final long serialVersionUID = 1L;

    public void process(PdsQuestionContext context) {
        this.setButtonVisible(context);
    }

    protected void setButtonVisible(PdsQuestionContext context) {
        long responderId;
        IFormView currView = context.getView();
        if (!PdsQuestionUtils.isQuestionNeedAutid((IFormView)currView) || !PdsQuestionUtils.isCreatedByCurrentRole((IFormView)currView)) {
            currView.setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_submit", "bar_audit"});
        }
        if ((responderId = currView.getModel().getDataEntity().getLong("responder.id")) != RequestContext.get().getCurrUserId()) {
            currView.setVisible(Boolean.valueOf(false), new String[]{"bar_unreply"});
        }
        if (responderId > 0L) {
            currView.setVisible(Boolean.valueOf(false), new String[]{"bar_audit"});
        }
        String publishType = currView.getModel().getDataEntity().getString("publishtype");
        if (Objects.equals(QuestionTypeEnums.PUR_CLARIFY.getValue(), publishType) || Objects.equals(QuestionTypeEnums.PUR_PRICECLARIFY.getValue(), publishType) || Objects.equals(QuestionTypeEnums.SUP_CLARIFY.getValue(), publishType)) {
            currView.setVisible(Boolean.valueOf(false), new String[]{"fs_replay"});
            if (currView.getModel().getEntryRowCount("entryentity") == 0) {
                currView.setVisible(Boolean.valueOf(false), new String[]{"pl_objectinfo"});
            }
        } else {
            currView.setVisible(Boolean.valueOf(false), new String[]{"pl_objectinfo"});
        }
        boolean isClarify = currView.getModel().getDataEntity().getBoolean("isclarify");
        if ("1".equals(context.getOrigin()) && isClarify && BillStatusEnum.SUBMIT.getVal().equals(currView.getModel().getDataEntity().getString("billstatus"))) {
            currView.setVisible(Boolean.valueOf(true), new String[]{"bar_submit", "bar_audit"});
            currView.setEnable(Boolean.valueOf(false), new String[]{"fs_question", "pl_objectinfo"});
        }
        if ("2".equals(context.getOrigin()) && isClarify) {
            if (BillStatusEnum.SAVE.getVal().equals(currView.getModel().getDataEntity().getString("billstatus"))) {
                currView.setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit", "bar_del"});
            } else if (BillStatusEnum.AUDIT.getVal().equals(currView.getModel().getDataEntity().getString("billstatus"))) {
                currView.setVisible(Boolean.valueOf(false), new String[]{"bar_audit", "bar_unaudit"});
            }
        }
    }
}

