/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.autoscore;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.autoscore.ISrcAutoScore;

public class SrcAutoScoreBySupplier
implements ISrcAutoScore {
    @Override
    public void process(SrcScoreContext context) {
        if (!context.isAutoScored()) {
            this.calcScoreBySupplier(context);
        }
    }

    protected void calcScoreBySupplier(SrcScoreContext context) {
        if (context.getIndexObj() == null) {
            return;
        }
        DynamicObjectCollection supplierRows = context.getIndexObj().getDynamicObjectCollection("supentryentity");
        if (null == supplierRows || supplierRows.size() == 0) {
            return;
        }
        List supplierList = supplierRows.stream().filter(e -> context.getSupplierId() == e.getLong("supplier.id")).collect(Collectors.toList());
        if (supplierList != null && supplierList.size() > 0) {
            context.setScore(((DynamicObject)supplierList.get(0)).getBigDecimal("score"));
            context.setAutoScored(true);
        } else {
            context.setScore(BigDecimal.ZERO);
            context.setAutoScored(true);
        }
    }
}

