/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.prepare;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.prepare.ISrcScoreLoadData;
import kd.scm.src.common.util.SrcAptitudeUtils;

public class SrcScoreLoadData
implements ISrcScoreLoadData {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.clearAllData(context);
        this.createScoreEntry(context);
        DynamicObject row = context.getView().getModel().getEntryRowEntity("score_entry", 0);
        if (null != row && SrcAptitudeUtils.isSupplierReplyAptitude(row.getDynamicObject("project"))) {
            SrcAptitudeUtils.loadAptitudeReplyAttach(context.getView(), "score_entry", "entryid");
        }
        EntryGrid grid = (EntryGrid)context.getView().getControl("score_entry");
        grid.selectRows(0);
    }

    protected void clearAllData(SrcScoreContext context) {
        IDataModel model = context.getView().getModel();
        model.deleteEntryData("score_entry");
    }

    protected void createScoreEntry(SrcScoreContext context) {
        DynamicObjectCollection scoreObjs = context.getScoreObjs();
        if (scoreObjs == null || scoreObjs.size() == 0) {
            return;
        }
        String entityName = context.isEvaluate() ? "src_expert" : "bd_supplier";
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity("score_entry").getDynamicObjectType());
        TableValueSetter ts = new TableValueSetter(new String[0]);
        Set<String> excludedFields = this.getExcludedFields();
        int rowIndex = 0;
        for (DynamicObject scoreObj : scoreObjs) {
            this.setRowValue(ts, rowIndex, properties, excludedFields, scoreObj);
            this.resetOherValue(ts, rowIndex, entityName);
            ++rowIndex;
        }
        model.batchCreateNewEntryRow("score_entry", ts);
    }

    protected void setRowValue(TableValueSetter ts, int rowIndex, List<String> properties, Set<String> excludedFields, DynamicObject scoreObj) {
        for (String property : properties) {
            if (excludedFields.contains(property)) continue;
            try {
                if (property.contains("_id")) {
                    ts.set(property, scoreObj.get(property.replace("_id", "")), rowIndex);
                    continue;
                }
                if (scoreObj.get(property) instanceof DynamicObject) {
                    ts.set(property, scoreObj.get(property + "." + "id"), rowIndex);
                    continue;
                }
                ts.set(property, scoreObj.get(property), rowIndex);
            }
            catch (Exception exception) {}
        }
    }

    protected void resetOherValue(TableValueSetter ts, int rowIndex, String entityName) {
        Object supplierCode;
        Object value = ts.get("value", rowIndex);
        String newValue = SrcScoreHelper.formatNumberValue(value);
        boolean scorerScored = (Boolean)ts.get("scorerscored", rowIndex);
        if (!scorerScored) {
            if (BigDecimal.ZERO.compareTo(new BigDecimal(newValue)) == 0) {
                String note = (String)ts.get("note", rowIndex);
                if (!StringUtils.isEmpty((Object)note)) {
                    ts.set("scorerscored", (Object)true, rowIndex);
                } else {
                    newValue = null;
                }
            } else {
                ts.set("scorerscored", (Object)true, rowIndex);
            }
        }
        ts.set("value", (Object)newValue, rowIndex);
        if (String.valueOf(ts.get("scorerveto", rowIndex)).equals("0")) {
            ts.set("scorerveto", (Object)"9", rowIndex);
        }
        if (StringUtils.isEmpty((Object)(supplierCode = ts.get("suppliercode", rowIndex)))) {
            Object supplier = ts.get("supplier", rowIndex);
            if (supplier instanceof DynamicObject) {
                ts.set("suppliername", (Object)((DynamicObject)supplier).getString("name"), rowIndex);
            } else if (supplier instanceof Long) {
                DynamicObject supObj = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier, (String)entityName);
                ts.set("suppliername", (Object)supObj.getString("name"), rowIndex);
            }
        } else {
            ts.set("suppliername", supplierCode, rowIndex);
        }
    }

    protected Set<String> getExcludedFields() {
        HashSet<String> excludedFields = new HashSet<String>(8);
        excludedFields.add("id");
        excludedFields.add("seq");
        return excludedFields;
    }
}

