/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;

public class SrcScoreTaskGetSupplier
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("srctype"));
        boolean isManualScoreTask = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"ismanualscoretask", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj())));
        if (context.isExpertEvaluate()) {
            this.getExperts(context);
        } else if (!(!context.isAptitudeAudit() && !context.isAptitudeAudit2() || isManualScoreTask || null != context.getSelectedRowDatas() && context.getSelectedRowDatas().size() != 0)) {
            this.getAptitudeSuppliers(context);
        } else {
            this.getTenderSuppliers(context);
        }
    }

    private void getAptitudeSuppliers(SrcScoreTaskContext context) {
        String suppliertype;
        switch (suppliertype = context.getBillObj().getString("suppliertype")) {
            case "1": {
                this.getEnrollSuppliers(context);
                break;
            }
            case "2": {
                this.getInviteSuppliers(context);
                break;
            }
            case "3": {
                this.getQuoteSuppliers(context);
                break;
            }
            default: {
                this.getQuoteSuppliers(context);
            }
        }
    }

    protected void getTenderSuppliers(SrcScoreTaskContext context) {
        String selectFields;
        DynamicObject[] tenderSuppliers;
        QFilter baseFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            baseFilter.and("package.id", "=", (Object)context.getPackageId());
        }
        if (!SrcBidOpenUtils.isOpenTecBeforePublish(context.getBillObj())) {
            baseFilter.and("istender", "=", (Object)"1");
        }
        QFilter tenderFilter = new QFilter("isdiscard", "=", (Object)"0");
        tenderFilter.and(baseFilter);
        tenderFilter.and("isaptitude", "!=", (Object)"2");
        if (context.isAptitudeAudit()) {
            tenderFilter.and("isexemptapt", "=", (Object)"0");
        }
        if (context.isOpenBySupplier()) {
            if (context.isAptitudeAudit()) {
                baseFilter.and("isaptopen", "=", (Object)"1");
            } else if (context.isAptitudeAudit2()) {
                baseFilter.and("istecopen", "=", (Object)"1");
            } else {
                baseFilter.and("istecopen", "=", (Object)"1");
            }
        }
        this.getSupplierUnPushFilter(context, baseFilter);
        if (null != context.getSelectedRowDatas() && context.getSelectedRowDatas().size() > 0) {
            Set idSet = context.getSelectedRowDatas().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            baseFilter.and("id", "in", idSet);
        }
        if ((tenderSuppliers = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)(selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false)), (QFilter[])tenderFilter.toArray())) == null || tenderSuppliers.length == 0) {
            QFilter discardFilter = new QFilter("isdiscard", "=", (Object)"1").and(baseFilter);
            if (QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])discardFilter.toArray())) {
                context.getConfigObj().set("entrystatus", (Object)ProcessStatusEnums.TERMINATED.getValue());
            }
            context.setPackageSucced(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u6ca1\u6709\u56de\u6807\u4f9b\u5e94\u5546\uff0c\u6216\u5df2\u4e0b\u8fbe\uff0c\u8bf7\u7528\u91cd\u65b0\u4e0b\u8fbe\u8bd5\u8bd5\u3002", (String)"SrcScoreTaskGetSupplier_4", (String)"scm-src-common", (Object[])new Object[0]), context.getPackageName()));
        } else {
            context.setTenderSuppliers(tenderSuppliers);
        }
    }

    protected void getEnrollSuppliers(SrcScoreTaskContext context) {
        QFilter baseFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            baseFilter.and(new QFilter("package", "=", (Object)context.getPackageId()).or("package", "=", (Object)0L));
        }
        baseFilter.and("isaptitude", "!=", (Object)"2");
        baseFilter.and("isdiscard", "=", (Object)"0");
        baseFilter.and("isexemptapt", "=", (Object)"0");
        this.getSupplierUnPushFilter(context, baseFilter);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_enrollsupplier", (boolean)false);
        DynamicObject[] enrollSuppliers = BusinessDataServiceHelper.load((String)"src_enrollsupplier", (String)selectFields, (QFilter[])baseFilter.toArray());
        if (enrollSuppliers == null || enrollSuppliers.length == 0) {
            context.setPackageSucced(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u6ca1\u6709\u62a5\u540d\u4f9b\u5e94\u5546\uff0c\u6216\u5df2\u4e0b\u8fbe\uff0c\u8bf7\u7528\u91cd\u65b0\u4e0b\u8fbe\u8bd5\u8bd5\u3002", (String)"SrcScoreTaskGetSupplier_5", (String)"scm-src-common", (Object[])new Object[0]), context.getPackageName()));
        } else {
            context.setTenderSuppliers(enrollSuppliers);
        }
    }

    protected void getInviteSuppliers(SrcScoreTaskContext context) {
        QFilter baseFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            baseFilter.and(new QFilter("package", "=", (Object)context.getPackageId()).or("package", "=", (Object)0L));
        }
        baseFilter.and("isaptitude", "!=", (Object)"2");
        baseFilter.and("isdiscard", "=", (Object)"0");
        baseFilter.and("isexemptapt", "=", (Object)"0");
        this.getSupplierUnPushFilter(context, baseFilter);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_supplierinvite", (boolean)false);
        DynamicObject[] inviteSuppliers = BusinessDataServiceHelper.load((String)"src_supplierinvite", (String)selectFields, (QFilter[])baseFilter.toArray());
        if (inviteSuppliers == null || inviteSuppliers.length == 0) {
            context.setPackageSucced(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u6ca1\u6709\u9080\u8bf7\u4f9b\u5e94\u5546\uff0c\u6216\u5df2\u4e0b\u8fbe\uff0c\u8bf7\u7528\u91cd\u65b0\u4e0b\u8fbe\u8bd5\u8bd5\u3002", (String)"SrcScoreTaskGetSupplier_6", (String)"scm-src-common", (Object[])new Object[0]), context.getPackageName()));
        } else {
            context.setTenderSuppliers(inviteSuppliers);
        }
    }

    protected void getQuoteSuppliers(SrcScoreTaskContext context) {
        String selectFields;
        DynamicObject[] quoteSuppliers;
        QFilter baseFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            baseFilter.and("package.id", "=", (Object)context.getPackageId());
        }
        SrcBidOpenFacade.addSupplierOpenFilter(baseFilter, true);
        if (context.isOpenBySupplier()) {
            if (context.isAptitudeAudit()) {
                baseFilter.and("isaptopen", "=", (Object)"1");
            } else if (context.isAptitudeAudit2()) {
                baseFilter.and("istecopen", "=", (Object)"1");
            }
        }
        this.getSupplierUnPushFilter(context, baseFilter);
        if (null != context.getSelectedRowDatas() && context.getSelectedRowDatas().size() > 0) {
            Set idSet = context.getSelectedRowDatas().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            baseFilter.and("id", "in", idSet);
        }
        QFilter quoteFilter = new QFilter("isdiscard", "=", (Object)"0").and(baseFilter);
        if (context.isAptitudeAudit()) {
            quoteFilter.and("isexemptapt", "=", (Object)"0");
        }
        if ((quoteSuppliers = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)(selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false)), (QFilter[])quoteFilter.toArray())) == null || quoteSuppliers.length == 0) {
            context.setPackageSucced(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u6ca1\u6709\u5df2\u6295\u6807\u6216\u5df2\u62a5\u4ef7\u4f9b\u5e94\u5546\uff0c\u6216\u5df2\u4e0b\u8fbe\uff0c\u8bf7\u7528\u91cd\u65b0\u4e0b\u8fbe\u8bd5\u8bd5\u3002", (String)"SrcScoreTaskGetSupplier_7", (String)"scm-src-common", (Object[])new Object[0]), context.getPackageName()));
        } else {
            context.setTenderSuppliers(quoteSuppliers);
        }
    }

    protected void getExperts(SrcScoreTaskContext context) {
        QFilter baseFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        baseFilter.and("isevaluatepush", "=", (Object)"0");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_evaluateexpertf7", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_evaluateexpertf7", (String)selectFields, (QFilter[])baseFilter.toArray());
        if (rows == null || rows.length == 0) {
            context.setPackageSucced(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5f85\u8003\u8bc4\u4e13\u5bb6\uff0c\u6216\u5df2\u4e0b\u8fbe\uff0c\u8bf7\u7528\u91cd\u65b0\u4e0b\u8fbe\u8bd5\u8bd5\u3002", (String)"SrcScoreTaskGetSupplier_8", (String)"scm-src-common", (Object[])new Object[0]), context.getPackageName()));
        } else {
            context.setTenderSuppliers(rows);
        }
    }

    public void getSupplierUnPushFilter(SrcScoreTaskContext context, QFilter baseFilter) {
        if (context.isAptitudeAudit() || context.isAptitudeAudit2() || "4".equals(context.getBillObj().getString("opentype")) || !"2".equals(context.getBillObj().getString("opentype"))) {
            // empty if block
        }
    }
}

