/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;
import kd.scm.src.common.score.result.SrcScoreHandleContext;

public class SrcScoreHandleScoreTask
implements ISrcScoreCommitScore {
    @Override
    public void process(SrcScoreContext context) {
        this.handleScoreTask(context);
    }

    protected void handleScoreTask(SrcScoreContext context) {
        String entityName = context.isEvaluate() ? "src_evaluatetask" : "src_scoretask";
        for (long scoreTaskId : context.getScoreTaskSet()) {
            DynamicObject scoreTaskObj = BusinessDataServiceHelper.loadSingle((Object)scoreTaskId, (String)entityName);
            SrcScoreHandleContext handleContext = new SrcScoreHandleContext();
            context.setHandleContext(handleContext);
            handleContext.setScoreTaskObj(scoreTaskObj);
            handleContext.setAllScored(true);
            handleContext.setPartScored(false);
            handleContext.setSumScore(BigDecimal.ZERO);
            handleContext.setIndexChangeSet(new HashSet<Long>());
            handleContext.setEvaluate(context.isEvaluate());
            long schemeId = scoreTaskObj.getLong("scheme.id");
            long projectId = scoreTaskObj.getLong("project.id");
            int minValueNum = Integer.parseInt(ExtParameterUtils.getExtParameterValueById((String)"src_scheme", (long)schemeId, (String)"minvalue", (Object)0, (long)projectId).toString());
            handleContext.setMinValueNum(minValueNum);
            int maxValueNum = Integer.parseInt(ExtParameterUtils.getExtParameterValueById((String)"src_scheme", (long)schemeId, (String)"maxvalue", (Object)0, (long)projectId).toString());
            handleContext.setMaxValueNum(maxValueNum);
            int expertCount = Integer.parseInt(ExtParameterUtils.getExtParameterValueById((String)"src_scheme", (long)schemeId, (String)"expertcount", (Object)0, (long)projectId).toString());
            handleContext.setExpertCount(expertCount);
            boolean isAutoCalcThreshold = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"src_scheme", (long)schemeId, (String)"isautocalcthreshold", (Object)false, (long)projectId));
            handleContext.setAutoCalcThreshold(isAutoCalcThreshold);
            handleContext.setSumWeightScore(BigDecimal.ZERO);
            DynamicObjectCollection indexObjs = scoreTaskObj.getDynamicObjectCollection("entry");
            for (DynamicObject indexObj : indexObjs) {
                this.initHandleContext(handleContext, indexObj);
                if (null == handleContext.getScoreType()) continue;
                if (handleContext.getScoreType().equals("2")) {
                    SrcScoreFacade.handleSystemIndexStatus(context);
                    continue;
                }
                handleContext.setIndexScored(Boolean.TRUE);
                handleContext.setIndexManScore(BigDecimal.ZERO);
                handleContext.setIndexVeto("9");
                handleContext.setValidExpertCount(0);
                SrcScoreFacade.handleScorerStatus(context);
                if (!handleContext.isIndexScored()) continue;
                SrcScoreFacade.handleManualIndexStatus(context);
            }
            this.reSaveScoretaskIndexF7(handleContext);
            SrcScoreFacade.handleScoreStatus(context);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scoreTaskObj});
        }
    }

    private void reSaveScoretaskIndexF7(SrcScoreHandleContext handleContext) {
        String entityName;
        String string = entityName = handleContext.isEvaluate() ? "src_evaluatetask_indexf7" : "src_scoretask_indexf7";
        if (handleContext.getIndexChangeSet().size() > 0) {
            QFilter qfilter = new QFilter("id", "in", handleContext.getIndexChangeSet());
            qfilter.and("billid.bizstatus", "!=", (Object)"E");
            DynamicObject[] indexRows = BusinessDataServiceHelper.load((String)entityName, (String)"threshold", (QFilter[])qfilter.toArray());
            PdsCommonUtils.saveDynamicObjects((DynamicObject[])indexRows);
        }
    }

    protected void initHandleContext(SrcScoreHandleContext handleContext, DynamicObject indexObj) {
        String scoreType = indexObj.getString("index.scoretype");
        boolean isDeduct = indexObj.getBoolean("index.isdeduct");
        boolean isFormula = indexObj.getBoolean("index.isformula");
        BigDecimal indexWeight = indexObj.getBigDecimal("indexweight");
        String scoreMethod = PdsCommonUtils.object2String((Object)indexObj.get("index.scoremethod"), (String)"1");
        if ("1".equals(scoreMethod)) {
            indexWeight = indexWeight.divide(BigDecimal.TEN.multiply(BigDecimal.TEN)).multiply(indexObj.getBigDecimal("index.score"));
        }
        if (indexWeight.compareTo(BigDecimal.ZERO) == 0) {
            indexWeight = BigDecimal.TEN.multiply(BigDecimal.TEN);
        }
        handleContext.setIndexObj(indexObj);
        handleContext.setScoreType(scoreType);
        handleContext.setDeduct(isDeduct);
        handleContext.setFormula(isFormula);
        handleContext.setIndexWeight(indexWeight);
    }
}

