/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;
import kd.scm.src.common.score.result.SrcScoreHandleContext;

public class SrcScoreHandleSysIndex
implements ISrcScoreCommitScore {
    @Override
    public void process(SrcScoreContext context) {
        this.handleSystemIndexStatus(context.getHandleContext());
    }

    protected void handleSystemIndexStatus(SrcScoreHandleContext context) {
        DynamicObject indexObj = context.getIndexObj();
        BigDecimal indexWeight = context.getIndexWeight();
        if (indexWeight.compareTo(BigDecimal.ZERO) <= 0) {
            indexWeight = BigDecimal.TEN.multiply(BigDecimal.TEN);
        }
        boolean partScored = context.isPartScored();
        boolean allScored = context.isAllScored();
        BigDecimal sumScore = context.getSumScore();
        if (indexObj.getBoolean("indexscored")) {
            partScored = true;
            if (context.isDeduct()) {
                indexObj.set("sysscore", (Object)indexObj.getBigDecimal("sysscore").negate());
            }
            indexObj.set("finalscore", (Object)indexObj.getBigDecimal("sysscore").multiply(indexWeight).divide(BigDecimal.TEN.multiply(BigDecimal.TEN)));
            sumScore = context.isDeduct() ? sumScore.min(indexObj.getBigDecimal("finalscore")) : sumScore.add(indexObj.getBigDecimal("finalscore"));
        } else {
            allScored = false;
        }
        context.setSumScore(sumScore);
        context.setPartScored(partScored);
        context.setAllScored(allScored);
    }
}

