/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;
import kd.scm.src.common.score.result.SrcScoreHandleContext;

public class SrcScorehandleScorer
implements ISrcScoreCommitScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.handleScorerStatus(context.getHandleContext());
    }

    protected void handleScorerStatus(SrcScoreHandleContext context) {
        boolean partScored = context.isPartScored();
        boolean allScored = context.isAllScored();
        boolean indexScored = context.isIndexScored();
        BigDecimal indexManScore = context.getIndexManScore();
        String indexVeto = context.getIndexVeto();
        DynamicObjectCollection subRows = context.getIndexObj().getDynamicObjectCollection("subentry");
        int scorerCount = 0;
        List subRowsList = subRows.stream().sorted(Comparator.comparing(e -> e.getBigDecimal("scorerscore"))).collect(Collectors.toList());
        int expertCount = context.getExpertCount();
        int maxValueNum = context.getMaxValueNum();
        int minValueNum = context.getMinValueNum();
        if (expertCount > 0 && subRowsList.size() < expertCount) {
            maxValueNum = 0;
            minValueNum = 0;
        }
        for (int i = 0; i < subRowsList.size(); ++i) {
            DynamicObject subRow = (DynamicObject)subRowsList.get(i);
            if (subRow.getBoolean("scorerscored")) {
                if (i >= minValueNum && i < subRowsList.size() - maxValueNum) {
                    indexManScore = indexManScore.add(subRow.getBigDecimal("scorerscore"));
                    ++scorerCount;
                    subRow.set("invalid", (Object)"0");
                } else if (i < minValueNum) {
                    subRow.set("invalid", (Object)"2");
                } else {
                    subRow.set("invalid", (Object)"3");
                }
                String subVeto = subRow.getString("scorerveto");
                if (subVeto != null && subVeto.compareTo(indexVeto) < 0) {
                    indexVeto = subVeto;
                }
                partScored = true;
                continue;
            }
            indexScored = false;
            allScored = false;
        }
        if (scorerCount > 0) {
            context.setIndexManScore(indexManScore.divide(BigDecimal.valueOf(scorerCount), 6));
            context.setValidExpertCount(scorerCount);
        }
        context.setIndexVeto(indexVeto);
        context.setPartScored(partScored);
        context.setIndexScored(indexScored);
        context.setAllScored(allScored);
    }
}

