/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SourceTypeUtils;
import kd.scm.src.common.bizquery.ISrcReferPriceHandler;

public class SrcDemandUtils {
    public static void afterPushOperation(AfterDoOperationEventArgs args, IFormView view) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        InteractionContext interactionContext = args.getOperationResult().getInteractionContext();
        if (interactionContext == null) {
            return;
        }
        Map resutlMap = interactionContext.getCustShowParameter();
        if (resutlMap == null || resutlMap.size() == 0) {
            return;
        }
        String title = (String)resutlMap.get("title");
        String message = (String)resutlMap.get("message");
        if (!Boolean.parseBoolean((String)resutlMap.get("succed"))) {
            view.showMessage(title, message, MessageTypes.Default);
            return;
        }
        HashSet projectIdSet = new HashSet();
        Object sceneObj = resutlMap.get("sceneIds");
        if (Objects.nonNull(sceneObj)) {
            Map<String, String> sceneMap = new HashMap(8);
            try {
                sceneMap = (Map)JSONUtils.cast((String)String.valueOf(sceneObj), Map.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!CollectionUtils.isEmpty(sceneMap)) {
                sceneMap.forEach((key, value) -> SrcDemandUtils.updateSceneStatus(key, value, "B", projectIdSet));
            }
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("message", title + "\uff1a" + message);
        Set sourceTypeSet = SourceTypeUtils.getAllSourceTypeKey();
        if (sourceTypeSet.contains(opKey)) {
            if (projectIdSet.size() == 1) {
                OpenFormUtils.openBillPage((IFormView)view, (String)"src_project", projectIdSet.iterator().next(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
            } else {
                OpenFormUtils.openListPage((IFormView)view, (String)"src_project", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)SrcDemandUtils.setProjectListFilter(SourceTypeEnums.getValue((String)opKey.toUpperCase())), null);
            }
        }
    }

    private static QFilter setProjectListFilter(String sourceType) {
        return new QFilter("sourcetype.number", "=", (Object)sourceType);
    }

    public static void updateSceneStatus(Object[] sceneIds, String status) {
        DynamicObject[] sceneObjs;
        for (DynamicObject sceneObj : sceneObjs = BusinessDataServiceHelper.load((Object[])sceneIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"src_demandscene"))) {
            sceneObj.set("scenestatus", (Object)status);
            sceneObj.set("projectno", null);
            sceneObj.set("project", (Object)0);
            SrcDemandUtils.updateApplyItemStatus(sceneObj, 0L);
            SrcDemandUtils.updateDemandItemStatus(sceneObj, 0L);
        }
        SaveServiceHelper.save((DynamicObject[])sceneObjs);
    }

    public static void updateSceneStatus(String sceneId, String billNo, String status) {
        SrcDemandUtils.updateSceneStatus(sceneId, billNo, status, new HashSet<Long>());
    }

    public static void updateSceneStatus(String sceneId, String billNo, String status, Set<Long> projectIdSet) {
        DynamicObject sceneObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sceneId), (String)"src_demandscene");
        sceneObj.set("scenestatus", (Object)status);
        sceneObj.set("projectno", (Object)billNo);
        long projectId = PdsCommonUtils.getProjectIdByProjectNo((String)billNo);
        sceneObj.set("project", (Object)projectId);
        projectIdSet.add(projectId);
        SrcDemandUtils.updateApplyItemStatus(sceneObj, projectId);
        SrcDemandUtils.updateDemandItemStatus(sceneObj, projectId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sceneObj});
    }

    public static void updateApplyItemStatus(DynamicObject sceneObj, long projectId) {
        DynamicObjectCollection rows = sceneObj.getDynamicObjectCollection("decisionitem");
        if (rows.size() == 0) {
            return;
        }
        HashSet<Long> srcentryIds = new HashSet<Long>();
        for (DynamicObject row : rows) {
            String srcEntryIdStr = row.getString("fbasedataid.srcentryid");
            try {
                Long srcEntryId = Long.valueOf(srcEntryIdStr);
                srcentryIds.add(srcEntryId);
            }
            catch (Exception e) {
                BizLog.log((String)("updateApplyItemStatus tranferexception:" + e.getMessage()));
            }
        }
        QFilter qfilter = new QFilter("id", "in", srcentryIds);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"src_detail", (String)"project", (QFilter[])qfilter.toArray());
        if (objs.length == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            obj.set("project", (Object)projectId);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])objs);
    }

    public static void updateDemandItemStatus(DynamicObject sceneObj, long projectId) {
        DynamicObjectCollection rows = sceneObj.getDynamicObjectCollection("decisionitem");
        if (rows.size() == 0) {
            return;
        }
        Set ids = rows.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", ids);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"src_demandf7two", (String)"project", (QFilter[])qfilter.toArray());
        if (objs.length == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            obj.set("project", (Object)projectId);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])objs);
    }

    public static BigDecimal sumSceneAmount(DynamicObjectCollection items, String properties) {
        return items.stream().map(col -> col.getDynamicObject("fbasedataid")).map(dataObj -> dataObj.getBigDecimal(properties)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal sumSceneAmountByDb(DynamicObject sceneObj, String properties, Map<Long, DynamicObject> materialMap) {
        DynamicObjectCollection items = sceneObj.getDynamicObjectCollection("decisionitem");
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            DynamicObject obj = materialMap.get(item.getLong("fbasedataid.id"));
            if (!Objects.nonNull(obj)) continue;
            sumAmount = sumAmount.add(obj.getBigDecimal(properties));
        }
        return sumAmount;
    }

    public static Object[] getCategoryIds(DynamicObjectCollection items) {
        return items.stream().map(col -> Optional.ofNullable(col.getDynamicObject("fbasedataid")).map(dataObj -> dataObj.getDynamicObject("category2")).map(DataEntityBase::getPkValue).orElse(null)).filter(Objects::nonNull).distinct().toArray();
    }

    public static Set<Object> getDeleteCategoryIdSet(DynamicObjectCollection rows, int[] indexes) {
        HashSet<Object> ids = new HashSet<Object>(16);
        List categoryIds = rows.stream().map(row -> Optional.ofNullable(row.getDynamicObject("category2")).map(DataEntityBase::getPkValue).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        for (int index : indexes) {
            DynamicObject category = ((DynamicObject)rows.get(index)).getDynamicObject("category2");
            if (Objects.isNull(category)) continue;
            int i = 0;
            for (Object categoryId : categoryIds) {
                if (!Objects.equals(categoryId, category.getPkValue())) continue;
                ids.add(categoryId);
                if (i > 0) {
                    ids.remove(categoryId);
                }
                ++i;
            }
        }
        return ids;
    }

    public static QFilter getCategoryFilter(DynamicObjectCollection rows) {
        Object[] ids = rows.stream().map(row -> Optional.ofNullable(row.getDynamicObject("category2")).map(DataEntityBase::getPkValue).orElse(null)).filter(Objects::nonNull).distinct().toArray();
        return new QFilter("id", "in", (Object)ids);
    }

    public static void updateReferPrice(DynamicObject obj) {
        ExtPluginContext context = new ExtPluginContext();
        context.setRows((DynamicObject[])obj.getDynamicObjectCollection("entryentity").toArray((Object[])new DynamicObject[0]));
        context.getParamMap().put("currency", obj.getLong("currency.id"));
        context.getParamMap().put("fieldnamecurrency", "currency.id");
        context.getParamMap().put("fieldnamematerial", "material1.id");
        context.getParamMap().put("fieldnameunit", "unit2.id");
        ExtPluginFactory.executeExtplugin((String)(ISrcReferPriceHandler.class.getSimpleName() + "_demand"), (ExtPluginContext)context, (boolean)false);
    }
}

