/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.src.common.notice.SrcNotifySupplierHandler;

public class SrcNoticeSupUtil {
    public static void showNoticeSup(DynamicObject obj, IFormView view) {
        SrcNoticeSupUtil.showNoticeSup(obj, view, null);
    }

    public static void showNoticeSup(DynamicObject obj, IFormView view, PdsLettersTypeEnum lettersType) {
        Object pkVal = obj.getPkValue();
        String entityKey = obj.getDynamicObjectType().getName();
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        long noticeId = 0L;
        QFilter noticeFilter = new QFilter("srcbillid", "=", (Object)String.valueOf(pkVal));
        noticeFilter.and("srcbilltype", "=", (Object)entityKey);
        if (null != lettersType) {
            noticeFilter.and("supplierentry.supletterstype", "=", (Object)lettersType.getVal());
        }
        DynamicObject noticeObj = QueryServiceHelper.queryOne((String)"pds_noticesupplier", (String)"id,billstatus", (QFilter[])new QFilter[]{noticeFilter});
        String billStatus = null;
        if (null != noticeObj) {
            billStatus = noticeObj.getString("billstatus");
            noticeId = noticeObj.getLong("id");
        } else {
            params.put("srcbillid", pkVal);
            params.put("srcbilltype", entityKey);
        }
        if (lettersType != null) {
            params.put("letterstype", lettersType.getVal());
        } else {
            params.put("letterstype", "");
        }
        if (0L == noticeId) {
            params.put("noticesupplier_isnew", "1");
        }
        BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)"pds_noticesupplier", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)noticeId, params, null);
        if (Objects.equals(BillStatusEnum.SAVE.getVal(), billStatus)) {
            showParam.setBillStatus(BillOperationStatus.EDIT);
        } else if (Objects.equals(BillStatusEnum.SUBMIT.getVal(), billStatus)) {
            showParam.setBillStatus(BillOperationStatus.SUBMIT);
        } else if (Objects.equals(BillStatusEnum.AUDIT.getVal(), billStatus)) {
            showParam.setBillStatus(BillOperationStatus.AUDIT);
        }
        view.showForm((FormShowParameter)showParam);
    }

    public static void notifySupplier(IFormView view, DynamicObject billObj, String operationKey, PdsLettersTypeEnum lettersType, String tipMessage) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setOperationKey(operationKey);
        context.setVerifyMessage(tipMessage);
        context.setBillObj(billObj);
        HashMap<String, PdsLettersTypeEnum> paramMap = new HashMap<String, PdsLettersTypeEnum>(1);
        paramMap.put("letterstype", lettersType);
        context.setParamMap(paramMap);
        String number = view.getEntityId() + '_' + operationKey + '_' + SrcNotifySupplierHandler.class.getSimpleName();
        ExtPluginFactory.executeExtplugin((String)number, (ExtPluginContext)context, (boolean)false);
    }
}

