/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.PdsFlowConfigEnum;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcCurrencyUtil;
import kd.scm.pds.common.util.SrcTypeUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.enums.SrcBizStatusEnum;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.extplugin.project.SrProjectManagetypeHandler;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcProjectUtil {
    public static void initProjectById(long projectId) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        String billNo = billObj.getString("billno");
        if (billNo.trim().length() == 0) {
            PdsCommonUtils.setBillNo((String)"src_project", (DynamicObject)billObj);
        }
        SrcProjectUtil.createEntryData(billObj);
        SrcProjectUtil.createExtObj(billObj);
        SrcProjectUtil.initAllExtObjs(billObj);
        SrcProjectUtil.setDefaultVal(billObj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
    }

    public static void setDefaultVal(DynamicObject billObj) {
        billObj.set("version", (Object)1);
        billObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
    }

    public static void createEntryData(DynamicObject billObj) {
        DynamicObject srcTypeObj = billObj.getDynamicObject("srctype");
        if (null == srcTypeObj) {
            return;
        }
        srcTypeObj = SrcTypeUtil.getSrcTypeObjById((Object)srcTypeObj.getPkValue());
        billObj.set("sourceclass", srcTypeObj.get("sourceclass"));
        billObj.set("managetype", srcTypeObj.get("managetype"));
        DynamicObjectCollection entryNodeCols = srcTypeObj.getDynamicObjectCollection("entrynode");
        int entryNodeSize = entryNodeCols.size();
        DynamicObjectCollection entryFlowCols = billObj.getDynamicObjectCollection("entrymainflow");
        entryFlowCols.clear();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            DynamicObject newEntry = entryFlowCols.addNew();
            SrcProjectUtil.setEntryVal(newEntry, entryNodeCol);
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("subentrynode");
            SrcProjectUtil.createSubEntryData(newEntry, subEntryCols);
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)billObj, (String)"entrymainflow");
        List<Object> templateIDList = SrcProjectUtil.getTemplateIDBySrcType(srcTypeObj);
        DynamicObject tplObj = BusinessDataServiceHelper.newDynamicObject((String)"pds_tplconfig");
        Object[] objs = BusinessDataServiceHelper.load((Object[])templateIDList.toArray(new Object[0]), (IDataEntityType)tplObj.getDataEntityType());
        DynamicObjectCollection tplEntryCols = billObj.getDynamicObjectCollection("tplentry");
        tplEntryCols.clear();
        for (Object obj : objs) {
            DynamicObject compTpl = (DynamicObject)obj;
            DynamicObjectCollection compEntryCols = compTpl.getDynamicObjectCollection("compentry");
            for (DynamicObject col : compEntryCols) {
                DynamicObject component;
                DynamicObject tplEntry = tplEntryCols.addNew();
                tplEntry.set("tmp_template", compTpl.getPkValue());
                String bizObj = col.getString("bizobject");
                if (null != bizObj) {
                    tplEntry.set("tmp_bizobject", (Object)bizObj);
                }
                if (null == (component = col.getDynamicObject("component"))) continue;
                tplEntry.set("tmp_component", component.getPkValue());
            }
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)billObj, (String)"tplentry");
    }

    private static void setEntryVal(DynamicObject newEntry, DynamicObject col) {
        DynamicObject template;
        DynamicObject bizNodeObj = col.getDynamicObject("biznode");
        if (null != bizNodeObj) {
            newEntry.set("biznode", bizNodeObj.getPkValue());
        }
        if (null != (template = col.getDynamicObject("template"))) {
            newEntry.set("comptemplate", col.getDynamicObject("template").getPkValue());
        }
        newEntry.set("isflowchart", col.get("isflowchart"));
        newEntry.set("bizobject", col.get("bizobject"));
        newEntry.set("extobject", col.get("extobject"));
        newEntry.set("nodename", col.get("nodename"));
    }

    private static void createSubEntryData(DynamicObject newEntry, DynamicObjectCollection cols) {
        DynamicObjectCollection subCols = newEntry.getDynamicObjectCollection("entrysubflow");
        for (DynamicObject col : cols) {
            DynamicObject template;
            DynamicObject newSubEntry = subCols.addNew();
            DynamicObject bizNodeObj = col.getDynamicObject("subbiznode");
            if (null != bizNodeObj) {
                newSubEntry.set("subbiznode", bizNodeObj.getPkValue());
            }
            if (null != (template = col.getDynamicObject("subtemplate"))) {
                newSubEntry.set("subcomptemplate", template.getPkValue());
            }
            newSubEntry.set("subisaudit", col.get("subisaudit"));
            newSubEntry.set("subisflowchart", col.get("subisflowchart"));
            newSubEntry.set("subbizobject", col.get("subbizobject"));
            newSubEntry.set("subextobject", col.get("subextobject"));
            newSubEntry.set("subnodename", col.get("subnodename"));
        }
    }

    public static List<Object> getTemplateIDBySrcType(DynamicObject srcTypeObj) {
        DynamicObjectCollection entryNodeCols = srcTypeObj.getDynamicObjectCollection("entrynode");
        int entryNodeSize = entryNodeCols.size();
        ArrayList<Object> templateIDList = new ArrayList<Object>();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            DynamicObject template = entryNodeCol.getDynamicObject("template");
            if (null != template) {
                templateIDList.add(template.getPkValue());
            }
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("subentrynode");
            for (DynamicObject col : subEntryCols) {
                DynamicObject subTemplate = col.getDynamicObject("subtemplate");
                if (null == subTemplate) continue;
                templateIDList.add(subTemplate.getPkValue());
            }
        }
        return templateIDList;
    }

    public static long createNewBillId(String objectName, String sourceType, long srctypeId, boolean isRuleNumber) {
        QFilter qFilter = ExtFilterUtils.getStringFilter((String)"bidname", (String)"temp");
        qFilter.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and("billstatus", "=", (Object)SrcProjectEnum.STAGING.getCode());
        qFilter.and("bizstatus", "=", (Object)ProcessStatusEnums.PROCESSING.getValue());
        qFilter.and(ExtFilterUtils.getStringFilter((String)"srcbillid", (String)""));
        qFilter.and("srctype", "=", (Object)0L);
        if ("src_preproject".equals(objectName)) {
            qFilter.and("ispreproject", "=", (Object)true);
        }
        SrcProjectUtil.setSourceTypeFilter(qFilter, sourceType);
        String selectFields = DynamicObjectUtil.getSelectfields((String)objectName, (boolean)true);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((String)objectName, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (billObj != null) {
            billObj.set("billdate", (Object)TimeServiceHelper.now());
            billObj.set("createtime", (Object)TimeServiceHelper.now());
            billObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            billObj.set("version", (Object)1);
            SrcProjectUtil.setDefaultOpenStatus(billObj, sourceType);
            SrcProjectUtil.setDefaultValueSourceType(sourceType, billObj);
            SrcProjectUtil.setDefaultSourceFlow(billObj, srctypeId);
            SrcProjectUtil.createExtObj(billObj);
            SrcProjectUtil.initAllExtObjs(billObj);
            if (isRuleNumber) {
                PdsCommonUtils.setBillNo((String)objectName, (DynamicObject)billObj);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
            return PdsCommonUtils.object2Long((Object)billObj.getPkValue());
        }
        billObj = BusinessDataServiceHelper.newDynamicObject((String)objectName);
        Date now = TimeServiceHelper.now();
        billObj.set("bidname", (Object)"temp");
        billObj.set("billdate", (Object)now);
        long userId = RequestContext.get().getCurrUserId();
        billObj.set("creator", (Object)userId);
        billObj.set("modifier_id", (Object)userId);
        billObj.set("creator_id", (Object)userId);
        billObj.set("createtime", (Object)now);
        billObj.set("billstatus", (Object)"A");
        billObj.set("bizstatus", (Object)"B");
        billObj.set("version", (Object)1);
        if ("src_preproject".equals(objectName)) {
            billObj.set("ispreproject", (Object)"1");
        }
        SrcProjectUtil.setDefaultValueSourceType(sourceType, billObj);
        SrcProjectUtil.setDefaultSourceFlow(billObj, srctypeId);
        SrcProjectUtil.setDefaultOpenStatus(billObj, sourceType);
        if (isRuleNumber) {
            PdsCommonUtils.setBillNo((String)objectName, (DynamicObject)billObj);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        if (srctypeId == 0L) {
            billObj.set("bidname", (Object)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        }
        SrcProjectUtil.createExtObj(billObj);
        SrcProjectUtil.initAllExtObjs(billObj);
        long billId = PdsCommonUtils.object2Long((Object)billObj.getPkValue());
        if (billId > 0L) {
            return billId;
        }
        return 0L;
    }

    public static long createNewBillId(String objectName, String sourceType, long srctypeId) {
        return SrcProjectUtil.createNewBillId(objectName, sourceType, srctypeId, true);
    }

    public static void createExtObj(DynamicObject billObj) {
        Object isEnableExtNode = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isenableextnode");
        if (null != isEnableExtNode && ((Boolean)isEnableExtNode).booleanValue()) {
            DynamicObject extBillObj = null;
            boolean exists = QueryServiceHelper.exists((String)"src_bidbillcomptpl_ext", (Object)billObj.getPkValue());
            if (exists) {
                Map proMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)billObj);
                List proList = (List)proMap.get("allProList");
                extBillObj = BusinessDataServiceHelper.loadSingle((Object)billObj.getPkValue(), (String)"src_bidbillcomptpl_ext");
                proList.remove("template");
                proList.remove("modifier");
                proList.remove("modifytime");
                proList.remove("auditor");
                proList.remove("auditdate");
                for (String property : proList) {
                    try {
                        Object objValue = billObj.get(property);
                        extBillObj.set(property, objValue);
                    }
                    catch (Exception e) {
                        BizLog.log((String)("###createExtObj setVal exception:" + e.getMessage()));
                    }
                }
            } else {
                extBillObj = BusinessDataServiceHelper.newDynamicObject((String)"src_bidbillcomptpl_ext");
            }
            extBillObj.set("id", billObj.getPkValue());
            extBillObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            extBillObj.set("bizstatus", (Object)"B");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extBillObj});
        }
    }

    public static void setDefaultOpenStatus(IDataModel model, String sourceType) {
        if (Objects.isNull(sourceType)) {
            return;
        }
        if (sourceType.equals(SourceTypeEnums.INPUT_PRICE.getValue())) {
            model.setValue("openstatus", (Object)BidOpenStatusEnums.DECISION.getValue());
        } else if (sourceType.equals(SourceTypeEnums.DIRECT_PUR.getValue()) || sourceType.equals(SourceTypeEnums.NET_PUR.getValue()) || sourceType.equals(SourceTypeEnums.INTERNAL_SALE.getValue())) {
            model.setValue("openstatus", (Object)BidOpenStatusEnums.OPEN.getValue());
        } else {
            model.setValue("openstatus", (Object)BidOpenStatusEnums.NOOPEN.getValue());
        }
    }

    public static void setDefaultOpenStatus(DynamicObject billObj, String sourceType) {
        if (Objects.isNull(sourceType)) {
            return;
        }
        if (sourceType.equals(SourceTypeEnums.INPUT_PRICE.getValue())) {
            billObj.set("openstatus", (Object)BidOpenStatusEnums.DECISION.getValue());
        } else if (sourceType.equals(SourceTypeEnums.DIRECT_PUR.getValue()) || sourceType.equals(SourceTypeEnums.NET_PUR.getValue()) || sourceType.equals(SourceTypeEnums.INTERNAL_SALE.getValue())) {
            billObj.set("openstatus", (Object)BidOpenStatusEnums.OPEN.getValue());
        } else {
            billObj.set("openstatus", (Object)BidOpenStatusEnums.NOOPEN.getValue());
        }
    }

    private static void setSourceTypeFilter(QFilter qFilter, String sourceType) {
        if (Objects.nonNull(sourceType)) {
            qFilter.and("sourcetype.number", "=", (Object)sourceType);
        }
    }

    private static void setDefaultValueSourceType(String sourceType, DynamicObject billObj) {
        DynamicObject extObj;
        if (Objects.nonNull(sourceType) && Objects.nonNull(extObj = PdsCommonUtils.getSrmExtData((String)sourceType))) {
            billObj.set("sourcetype", extObj.get("id"));
        }
    }

    private static void setDefaultSourceFlow(DynamicObject billObj, long srctypeId) {
        Object sourcetype = billObj.get("sourcetype");
        long sourcetypeId = sourcetype instanceof DynamicObject ? SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)sourcetype)) : billObj.getLong("sourcetype");
        QFilter qFilter = null;
        if (srctypeId > 0L) {
            qFilter = new QFilter("id", "=", (Object)srctypeId);
        } else {
            qFilter = new QFilter("sourcetype", "=", (Object)sourcetypeId);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
        }
        DynamicObjectCollection flowObjs = QueryServiceHelper.query((String)"pds_flowconfig", (String)"id,sourceclass,managetype,tieredtype,isneedinvite", (QFilter[])qFilter.toArray(), (String)"isdefault desc,number");
        if (flowObjs != null && flowObjs.size() > 0) {
            billObj.set("srctype", ((DynamicObject)flowObjs.get(0)).get("id"));
            billObj.set("sourceclass", ((DynamicObject)flowObjs.get(0)).get("sourceclass"));
            billObj.set("managetype", ((DynamicObject)flowObjs.get(0)).get("managetype"));
            billObj.set("tieredtype", ((DynamicObject)flowObjs.get(0)).get("tieredtype"));
            if (((DynamicObject)flowObjs.get(0)).getBoolean("isneedinvite")) {
                billObj.set("isneedinvite", (Object)"1");
            } else {
                billObj.set("isneedinvite", (Object)"0");
            }
        }
    }

    public static List<DynamicObject> getHandledBizNodes(DynamicObject project) {
        ArrayList<DynamicObject> bizNodeList = new ArrayList<DynamicObject>();
        DynamicObjectCollection entryNodeCols = project.getDynamicObjectCollection("entrymainflow");
        int entryNodeSize = entryNodeCols.size();
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject subBizNode;
            String subBizStatus;
            DynamicObject subEntryNodeCol;
            int j;
            int subEntryNodeSize;
            DynamicObjectCollection subEntrys;
            DynamicObject bizNode;
            String bizStatus;
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            DynamicObject proNode = entryNodeCol.getDynamicObject("biznode");
            if ("778748079732982784".equals(proNode.getString("id"))) {
                bizStatus = entryNodeCol.getString("flowbizstatus");
                if ("C".equals(bizStatus) || "B".equals(bizStatus)) {
                    bizNode = entryNodeCol.getDynamicObject("biznode");
                    bizNodeList.add(bizNode);
                }
                subEntrys = entryNodeCol.getDynamicObjectCollection("entrysubflow");
                subEntryNodeSize = subEntrys.size();
                for (j = 0; j < subEntryNodeSize; ++j) {
                    subEntryNodeCol = (DynamicObject)subEntrys.get(j);
                    subBizStatus = subEntryNodeCol.getString("subflowbizstatus");
                    if (!"C".equals(subBizStatus) && !"B".equals(bizStatus)) continue;
                    subBizNode = subEntryNodeCol.getDynamicObject("subbiznode");
                    bizNodeList.add(subBizNode);
                }
                continue;
            }
            bizStatus = entryNodeCol.getString("flowbizstatus");
            if ("C".equals(bizStatus)) {
                bizNode = entryNodeCol.getDynamicObject("biznode");
                bizNodeList.add(bizNode);
            }
            subEntrys = entryNodeCol.getDynamicObjectCollection("entrysubflow");
            subEntryNodeSize = subEntrys.size();
            for (j = 0; j < subEntryNodeSize; ++j) {
                subEntryNodeCol = (DynamicObject)subEntrys.get(j);
                subBizStatus = subEntryNodeCol.getString("subflowbizstatus");
                if (!"C".equals(subBizStatus)) continue;
                subBizNode = subEntryNodeCol.getDynamicObject("subbiznode");
                bizNodeList.add(subBizNode);
            }
        }
        return bizNodeList;
    }

    public static void initAllExtObjs(DynamicObject obj) {
        List<String> extObjList = SrcProjectUtil.getAllExtObjs();
        List<String> extNodeList = SrcProjectUtil.getAllExtNode();
        extObjList.addAll(extNodeList);
        HashMap<String, String> haveCreatedMap = new HashMap<String, String>(8);
        for (String extObj : extObjList) {
            if (null != haveCreatedMap.get(extObj)) continue;
            haveCreatedMap.putIfAbsent(extObj, extObj);
            Map<String, String> scpecialHandleExtObjMap = SrcBidCompTplUtil.getSpecialHandleExtObjs();
            if (null != scpecialHandleExtObjMap.get(extObj)) {
                SrcProjectUtil.initSpecialExtObj(obj, extObj);
                continue;
            }
            DynamicObject extObjDy = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)extObj);
            DynamicObjectCollection entryCols = extObjDy.getDynamicObjectCollection("entryentity");
            if (entryCols.size() == 0) {
                DynamicObject entry = entryCols.addNew();
                entry.set("id", obj.getPkValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extObjDy});
            } else if ((Long)((DynamicObject)entryCols.get(0)).getPkValue() == 0L && !"src_project_a".equals(extObj) && !"src_project_t".equals(extObj)) {
                ((DynamicObject)entryCols.get(0)).set("id", obj.getPkValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extObjDy});
            }
            if ((Long)((DynamicObject)entryCols.get(0)).getPkValue() != 0L || !"src_project_a".equals(extObj)) continue;
            SrcProjectUtil.executeBatchSql(extObjDy);
        }
    }

    private static void executeBatchSql(DynamicObject obj) {
        DBRoute dbRoute = new DBRoute("pur");
        ArrayList<Object[]> parms = new ArrayList<Object[]>(1);
        Object[] param = new Object[]{obj.getPkValue(), obj.getPkValue()};
        parms.add(param);
        DB.executeBatch((DBRoute)dbRoute, (String)"update T_SRC_PROJECT_A set fentryid = ? where fid = ?", parms);
    }

    public static void initSpecialExtObj(DynamicObject obj, String extObj) {
        DynamicObject source = obj.getDynamicObject("source");
        if (null == source) {
            return;
        }
        QFilter filter = new QFilter("source", "=", source.getPkValue());
        boolean isExist = QueryServiceHelper.exists((String)extObj, (QFilter[])new QFilter[]{filter});
        if (isExist) {
            return;
        }
        DynamicObject bizObj = BusinessDataServiceHelper.newDynamicObject((String)extObj);
        bizObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        bizObj.set("bizstatus", (Object)ProcessStatusEnums.NOTSTARTED.getValue());
        bizObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        bizObj.set("createtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizObj});
    }

    public static List<String> getAllExtObjs() {
        ArrayList<String> extObjList = new ArrayList<String>(32);
        extObjList.add("src_project_a");
        extObjList.add("src_project_b");
        extObjList.add("src_project_c");
        extObjList.add("src_project_d");
        extObjList.add("src_project_e");
        extObjList.add("src_project_f");
        extObjList.add("src_project_g");
        extObjList.add("src_project_h");
        extObjList.add("src_project_i");
        extObjList.add("src_project_j");
        extObjList.add("src_project_k");
        extObjList.add("src_project_m");
        extObjList.add("src_project_n");
        extObjList.add("src_project_o");
        extObjList.add("src_project_p");
        extObjList.add("src_project_q");
        extObjList.add("src_project_r");
        extObjList.add("src_project_s");
        extObjList.add("src_project_t");
        extObjList.add("src_project_v");
        extObjList.add("src_project_x");
        extObjList.add("src_project_y");
        extObjList.add("src_project_z");
        return extObjList;
    }

    public static List<String> getAllExtNode() {
        ArrayList<String> extObjList = new ArrayList<String>(32);
        Object isEnableExtNode = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isenableextnode");
        if (null != isEnableExtNode && ((Boolean)isEnableExtNode).booleanValue()) {
            SrcProjectUtil.addExtObjList(extObjList);
        }
        return extObjList;
    }

    public static void addExtObjList(List<String> extObjList) {
        extObjList.add("src_project_ext_a");
        extObjList.add("src_project_ext_b");
        extObjList.add("src_project_ext_c");
        extObjList.add("src_project_ext_d");
        extObjList.add("src_project_ext_e");
        extObjList.add("src_project_ext_f");
        extObjList.add("src_project_ext_g");
        extObjList.add("src_project_ext_h");
        extObjList.add("src_project_ext_i");
        extObjList.add("src_project_ext_j");
        extObjList.add("src_project_ext_k");
        extObjList.add("src_project_ext_m");
        extObjList.add("src_project_ext_n");
        extObjList.add("src_project_ext_o");
        extObjList.add("src_project_ext_p");
        extObjList.add("src_project_ext_q");
        extObjList.add("src_project_ext_r");
        extObjList.add("src_project_ext_s");
        extObjList.add("src_project_ext_t");
        extObjList.add("src_project_ext_v");
        extObjList.add("src_project_ext_x");
        extObjList.add("src_project_ext_y");
        extObjList.add("src_project_ext_z");
    }

    public static boolean isQuickPur(DynamicObject obj) {
        DynamicObject sourceObj = obj.getDynamicObject("sourceclass");
        if (null == sourceObj) {
            return false;
        }
        return Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number"));
    }

    public static void getManageTypeComboByTenderType(DynamicObject obj, IFormView view) {
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(obj);
        context.setView(view);
        ExtPluginFactory.executeExtplugin((String)SrProjectManagetypeHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    public static void setSupplierVisible(DynamicObject newSourceTypeObject, IFormView iFormView) {
        String newSourceType;
        BasedataEdit supplierEdit = (BasedataEdit)iFormView.getControl("supplier");
        String string = newSourceType = newSourceTypeObject == null ? "" : newSourceTypeObject.getString("number");
        if (newSourceType.equals(SourceTypeEnums.CONFIRM_PRICE.getValue()) || newSourceType.equals(SourceTypeEnums.DELEGATE_BID.getValue())) {
            iFormView.getModel().setValue("suppliertype", (Object)"bd_supplier");
            iFormView.setVisible(Boolean.valueOf(true), new String[]{"supplier"});
            iFormView.setVisible(Boolean.valueOf(true), new String[]{"supplieruser"});
            if (newSourceType.equals(SourceTypeEnums.CONFIRM_PRICE.getValue())) {
                supplierEdit.setMustInput(true);
            }
            if (newSourceType.equals(SourceTypeEnums.DELEGATE_BID.getValue())) {
                supplierEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62db\u6807\u4ee3\u7406\u673a\u6784", (String)"SrcProjectUtil_3", (String)"scm-src-common", (Object[])new Object[0])));
            }
        } else {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"supplier"});
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"supplieruser"});
            supplierEdit.setMustInput(false);
        }
    }

    public static void setBaseInfoVisible(DynamicObject newSourceTypeObject, IFormView view) {
        if (!"src_project".equals(view.getEntityId())) {
            return;
        }
        BasedataEdit currencyEdit = (BasedataEdit)view.getControl("currency");
        ComboEdit taxtypeEdit = (ComboEdit)view.getControl("taxtype");
        ArrayList<String> sourceTypes = new ArrayList<String>(8);
        sourceTypes.add(SourceTypeEnums.INPUT_PRICE.getValue());
        sourceTypes.add(SourceTypeEnums.NET_PUR.getValue());
        sourceTypes.add(SourceTypeEnums.INTERNAL_SALE.getValue());
        sourceTypes.add(SourceTypeEnums.DIRECT_PUR.getValue());
        if (newSourceTypeObject != null && sourceTypes.contains(newSourceTypeObject.getString("number"))) {
            QFilter qfilter;
            DynamicObject defValueObj;
            view.setVisible(Boolean.valueOf(true), new String[]{"currency"});
            currencyEdit.setMustInput(true);
            Object currencyObj = view.getModel().getValue("currency");
            if (Objects.isNull(currencyObj)) {
                DynamicObject org = view.getModel().getDataEntity().getDynamicObject("org");
                view.getModel().setValue("currency", SrcCurrencyUtil.getBaseCurrIdByOrg((Object)SrmCommonUtil.getPkValue((DynamicObject)org)));
            }
            view.setVisible(Boolean.valueOf(true), new String[]{"taxtype"});
            taxtypeEdit.setMustInput(true);
            Object taxTypeObj = view.getModel().getValue("taxtype");
            if (StringUtils.isBlank((Object)taxTypeObj) && null != (defValueObj = QueryServiceHelper.queryOne((String)"pds_defaultconfig", (String)"entryentity.defaultvalue", (QFilter[])(qfilter = new QFilter("number", "=", (Object)"SYS001").and("entryentity.fieldid", "=", (Object)"taxtype")).toArray()))) {
                view.getModel().setValue("taxtype", defValueObj.get("entryentity.defaultvalue"));
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"currency"});
            currencyEdit.setMustInput(false);
            view.setVisible(Boolean.valueOf(false), new String[]{"taxtype"});
            taxtypeEdit.setMustInput(false);
        }
    }

    public static void setBizTypeDefaultValue(IDataModel model) {
        Object bizTypeParam;
        Object bizType = model.getDataEntity().get("biztype");
        if (Objects.isNull(bizType) && Objects.nonNull(bizTypeParam = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"biztype"))) {
            Map paramMap = (Map)bizTypeParam;
            model.setValue("biztype", (Object)paramMap.getOrDefault("id", "422857170485263360"));
        }
    }

    public static void setBizTypeDefaultValue(DynamicObject billObj, DynamicObject biztypeObj) {
        Object bizType = billObj.get("biztype");
        if (Objects.isNull(bizType)) {
            if (null != biztypeObj) {
                billObj.set("biztype", biztypeObj.getPkValue());
            } else {
                Object bizTypeParam = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"biztype");
                if (Objects.nonNull(bizTypeParam)) {
                    Map paramMap = (Map)bizTypeParam;
                    billObj.set("biztype", (Object)paramMap.getOrDefault("id", "422857170485263360"));
                }
            }
        }
    }

    public static boolean isEnded(DynamicObject obj) {
        QFilter projectFilter = new QFilter("id", "=", obj.getPkValue());
        projectFilter.and("bizstatus", "=", (Object)SrcBizStatusEnum.ENDED);
        return QueryServiceHelper.exists((String)"src_project", (QFilter[])projectFilter.toArray());
    }

    public static void resetSoureFlow(IFormView view, PropertyChangedArgs args) {
        long sourceFlowId;
        long newBizTypeId;
        DynamicObject newBizTypeObj = args.getChangeSet()[0].getDataEntity().getDynamicObject("biztype");
        long l = newBizTypeId = newBizTypeObj == null ? 0L : newBizTypeObj.getLong("id");
        if (newBizTypeId == 0L) {
            return;
        }
        String srctypeField = "srctype";
        if ("src_apply".equals(view.getEntityId()) || "src_demand".equals(view.getEntityId()) || "src_demand_comp".equals(view.getEntityId())) {
            srctypeField = "srctype2";
        }
        if ((sourceFlowId = view.getModel().getDataEntity().getLong(srctypeField + '.' + "id")) == 0L) {
            return;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)sourceFlowId);
        qfilter.and(ExtFilterUtils.getMultiBaseDataFilter((String)"biztype", (long)newBizTypeId));
        if (QueryServiceHelper.exists((String)"pds_flowconfig", (QFilter[])qfilter.toArray())) {
            return;
        }
        view.getModel().setValue(srctypeField, null);
    }

    public static boolean hasBizOpen(Object projectId) {
        DynamicObject compData = TemplateUtil.getComponentData((String)String.valueOf(projectId), (String)"src_bidopen_open");
        if (null != compData) {
            DynamicObjectCollection cols = compData.getDynamicObjectCollection("entryentity");
            long count = cols.stream().filter(col -> true == col.getBoolean("isbizopen")).count();
            return count > 0L;
        }
        return true;
    }
}

