/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.PdsFlowConfigEnum;

public class SrcQuickPurUtil {
    public static boolean isQuickPurchase(IFormView iFormView, List<String> nodeNames) {
        IFormView parentView = iFormView.getParentView();
        if (null == parentView) {
            return false;
        }
        String entityId = parentView.getEntityId();
        if (nodeNames.contains(entityId)) {
            DynamicObject sourceObj = parentView.getModel().getDataEntity().getDynamicObject("sourceclass");
            if (null == sourceObj) {
                return false;
            }
            return Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number"));
        }
        return false;
    }

    public static boolean isPublicQuickPurchase(IFormView iFormView) {
        IFormView parentView = iFormView.getParentView();
        if (null == parentView) {
            return false;
        }
        String entityId = parentView.getEntityId();
        if ("src_decision".equals(entityId) || "src_predecision".equals(entityId)) {
            String tenderType;
            DynamicObject sourceObj = parentView.getModel().getDataEntity().getDynamicObject("sourceclass");
            if (null == sourceObj) {
                return false;
            }
            if (Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number")) && Objects.equals(tenderType = parentView.getModel().getDataEntity().getString("srctype.tendertype"), "2")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isQuickPurchase(DynamicObject sourceObj) {
        if (null == sourceObj) {
            return false;
        }
        return Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceObj.getString("number"));
    }

    public static List<String> getTenderBillF7SupplierAndPackage(Object projectId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)Long.parseLong(projectId.toString())).and(new QFilter("isabandon", "=", (Object)Boolean.FALSE));
        DynamicObject[] supObjs = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"package,suppliertype,supplier,isabandon", (QFilter[])new QFilter[]{qFilter});
        return Arrays.stream(supObjs).map(row -> row.getString("package.id") + "|" + row.getString("supplier.id") + "|" + row.getString("supplier.name")).distinct().collect(Collectors.toList());
    }

    public static List<String> getTenderBillF7Supplier(Object projectId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)Long.parseLong(projectId.toString())).and(new QFilter("isabandon", "=", (Object)Boolean.FALSE));
        DynamicObject[] supObjs = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"package,suppliertype,supplier,isabandon", (QFilter[])new QFilter[]{qFilter});
        List<String> supObjList = Arrays.stream(supObjs).map(row -> row.getString("supplier.id")).distinct().collect(Collectors.toList());
        return supObjList;
    }
}

