/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsSourcePlanUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.src.common.vie.ISrcVieFinish;
import kd.scm.src.common.vie.SrcVieFacade;

public class SrcVieFinishNegotiateBill
implements ISrcVieFinish {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        this.updateNegotiateBill(context);
        this.updateNegotiateStatus(context);
    }

    protected void updateNegotiateBill(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("negotiatetype", "=", (Object)"4");
        qfilter.and("isquotebidopen", "=", (Object)"0");
        DynamicObject[] negotiateObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)"isquotebidopen,createtime", (QFilter[])qfilter.toArray());
        if (negotiateObjs == null || negotiateObjs.length == 0) {
            return;
        }
        for (DynamicObject negotiateObj : negotiateObjs) {
            negotiateObj.set("isquotebidopen", (Object)"1");
        }
        SrcVieFacade.setFinishData(context, "negotiatedate", negotiateObjs);
        this.updateSourcePlan(context, negotiateObjs[0]);
    }

    protected void updateNegotiateStatus(PdsVieContext context) {
        Set<Long> supplierIds = this.getSupplierIds(context);
        if (supplierIds == null || supplierIds.size() == 0) {
            return;
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("supplier.id", "in", supplierIds).and("entrystatus", "=", (Object)ProcessStatusEnums.NOTSTARTED.getValue());
        DynamicObject[] negotiateObjs = BusinessDataServiceHelper.load((String)"src_quote_detailsf7", (String)"entrystatus,negotiatedate", (QFilter[])qfilter.toArray());
        if (negotiateObjs == null || negotiateObjs.length == 0) {
            return;
        }
        for (DynamicObject negotiateObj : negotiateObjs) {
            negotiateObj.set("entrystatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
            negotiateObj.set("negotiatedate", (Object)TimeServiceHelper.now());
        }
        SrcVieFacade.setFinishData(context, "negotiatetype", negotiateObjs);
    }

    protected Set<Long> getSupplierIds(PdsVieContext context) {
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("vieturns", "=", (Object)context.getVieturns());
        DynamicObjectCollection quoteDetails = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"supplier.id", (QFilter[])quoteFilter.toArray());
        if (quoteDetails == null || quoteDetails.size() == 0) {
            return null;
        }
        Map<String, List<DynamicObject>> supplierMap = quoteDetails.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id")));
        return supplierMap.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
    }

    public void updateSourcePlan(PdsVieContext context, DynamicObject negotiateObj) {
        long projectId = context.getProjectId();
        Date beginDate2 = negotiateObj.getDate("createtime");
        Date endDate2 = TimeServiceHelper.now();
        PdsSourcePlanUtils.updatePlan((long)projectId, (long)PdsBizNodeEnums.NEGOTIATEBILL.getId(), (Date)beginDate2, (Date)endDate2, (boolean)true, (long)SrmCommonUtil.getPkValue((DynamicObject)negotiateObj), (String)negotiateObj.getDataEntityType().getName(), null);
    }
}

