/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsSourcePlanUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.src.common.vie.ISrcVieFinish;
import kd.scm.src.common.vie.SrcVieFacade;

public class SrcVieFinishQuoteBill
implements ISrcVieFinish {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObject[] quoteObjs = BusinessDataServiceHelper.load((String)"tnd_quotebill", (String)"billstatus,bizstatus,isfinish,opentype,billdate,createtime", (QFilter[])qfilter.toArray());
        if (quoteObjs == null || quoteObjs.length == 0) {
            return;
        }
        for (DynamicObject quoteObj : quoteObjs) {
            quoteObj.set("opentype", (Object)"9");
            quoteObj.set("isfinish", (Object)"1");
            quoteObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
            quoteObj.set("bizstatus", (Object)BillStatusEnum.AUDIT.getVal());
            quoteObj.set("billdate", (Object)TimeServiceHelper.now());
        }
        SrcVieFacade.setFinishData(context, "quoteid", quoteObjs);
        this.updateSourcePlan(context, quoteObjs[0]);
    }

    public void updateSourcePlan(PdsVieContext context, DynamicObject quoteObj) {
        long projectId = context.getProjectId();
        Date beginDate2 = quoteObj.getDate("createtime");
        Date endDate2 = TimeServiceHelper.now();
        PdsSourcePlanUtils.updatePlan((long)projectId, (long)PdsBizNodeEnums.QUOTEBILL.getId(), (Date)beginDate2, (Date)endDate2, (boolean)true, (long)SrmCommonUtil.getPkValue((DynamicObject)quoteObj), (String)quoteObj.getDataEntityType().getName(), null);
    }
}

