/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cdm.report.helper.OrgHelper;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;

public class BillTradeQueryHelper {
    private static final Log logger = LogFactory.getLog(BillTradeQueryHelper.class);
    private static final String SELECT_FIELD_BANK_CURRENCY_NAME = "currency.name";
    public static final String CDM_RECEIVABLEBILL = "cdm_receivablebill";
    public static final String CDM_PAYABLEBILL = "cdm_payablebill";
    public static final String CDM_DRAFTTRADEBILL = "cdm_drafttradebill";
    public static final String CDM_BILLPOOLBIZ = "cdm_billpoolbiz";
    public static String radixStr = "/1";
    public static int reportAmtprecision = 2;
    private static final String COLUMN_SEPARATOR = ",";
    private static final Map<String, CurrencyUnit> CURRENCY_UNIT_MAP = Collections.unmodifiableMap(new HashMap<String, CurrencyUnit>(8){
        {
            this.put(CurrencyUnit.BILLION.getValue(), CurrencyUnit.BILLION);
            this.put(CurrencyUnit.MILLION.getValue(), CurrencyUnit.MILLION);
            this.put(CurrencyUnit.TENTHOUSAND.getValue(), CurrencyUnit.TENTHOUSAND);
            this.put(CurrencyUnit.THOUSAND.getValue(), CurrencyUnit.THOUSAND);
            this.put(CurrencyUnit.ORIGINAL.getValue(), CurrencyUnit.ORIGINAL);
        }
    });
    private static final String EXRATE_TABLE_CURRENCY_ID = "currencyid";
    private static final String EXRATE_TABLE_EXCHG_RATE = "exchgRate";
    private static final String DEVIDESIGN = "/";
    private static final String SELECT_FIELD_BANK_REPORT_CURRENCY = "reportcurrency";

    public static DataSet query(ReportQueryParam reportQueryParam, Boolean isPool) {
        Map<String, Object> transQueryParam = BillTradeQueryHelper.transQueryParam(reportQueryParam);
        if (isPool.booleanValue()) {
            transQueryParam.put("filter_datatype", "C");
        }
        List<Long> orgIds = OrgHelper.getQueryOrgIds(reportQueryParam);
        return BillTradeQueryHelper.query(transQueryParam, orgIds);
    }

    private static Map<String, Object> transQueryParam(ReportQueryParam param) {
        List filterItems = param.getFilter().getFilterItems();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(filterItems.size());
        for (FilterItemInfo filterItem : filterItems) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    public static DataSet query(Map<String, Object> transQueryParam, List<Long> orgIds) {
        logger.info("query is start");
        Object filter_datatype = transQueryParam.get("filter_datatype");
        Object filter_billtype = transQueryParam.get("filter_billtype");
        DynamicObjectCollection filter_billtypebase = (DynamicObjectCollection)transQueryParam.get("filter_billtypebase");
        DynamicObjectCollection filter_currency = (DynamicObjectCollection)transQueryParam.get("filter_currency");
        Object filter_queryway = transQueryParam.get("filter_rangequeryway");
        Date filter_startdate = (Date)transQueryParam.get("filter_startdate");
        Date filter_enddate = (Date)transQueryParam.get("filter_enddate");
        DynamicObject filter_startperiod = (DynamicObject)transQueryParam.get("filter_startperiod");
        DynamicObject filter_endperiod = (DynamicObject)transQueryParam.get("filter_endperiod");
        Object filter_exratetable = transQueryParam.get("filter_exratetable");
        DynamicObject filter_reportcurrency = (DynamicObject)transQueryParam.get("filter_statcurrency");
        String filter_currencyunit = (String)transQueryParam.get("filter_currencyunit");
        Date currDate = BillTradeQueryHelper.parseCurrDate();
        if (filter_queryway.toString().equalsIgnoreCase("B")) {
            filter_startdate = filter_startperiod.getDate("begindate");
            filter_enddate = filter_endperiod.getDate("enddate");
            if (filter_startdate.after(currDate)) {
                filter_startdate = currDate;
            }
            if (filter_enddate.after(currDate)) {
                filter_enddate = currDate;
            }
        }
        filter_enddate = BillTradeQueryHelper.parseDate(filter_enddate, true);
        radixStr = DEVIDESIGN + filter_currencyunit;
        reportAmtprecision = filter_reportcurrency.getInt("amtprecision");
        HashSet<Long> filterCurrIdSet = new HashSet();
        QFilter qFilter_curr = null;
        QFilter qFilter_billType = null;
        QFilter qFilter_billType_bill = null;
        QFilter qFilter_billType_bill_pool = null;
        if (null != filter_currency && filter_currency.size() > 0) {
            filterCurrIdSet = filter_currency.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            qFilter_curr = new QFilter("currency", "in", filterCurrIdSet);
        }
        if (null != filter_billtypebase && filter_billtypebase.size() > 0) {
            Set filterBillTypeIdSet = filter_billtypebase.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            qFilter_billType = new QFilter("draftbilltype", "in", filterBillTypeIdSet);
            qFilter_billType_bill = new QFilter("drafttype", "in", filterBillTypeIdSet);
            qFilter_billType_bill_pool = new QFilter("entryentity.e_draftbill.draftbilltype", "in", filterBillTypeIdSet);
        } else {
            String[] arr = filter_billtype.toString().split(COLUMN_SEPARATOR, -1);
            HashSet<String> billTypeSet = new HashSet<String>();
            for (int i = 0; i < arr.length; ++i) {
                String billTypeStr = arr[i];
                if (null == billTypeStr || "".equalsIgnoreCase(billTypeStr)) continue;
                billTypeSet.add(billTypeStr);
            }
            QFilter qFilterOfBillType = new QFilter("settlementtype", "in", billTypeSet);
            DynamicObjectCollection billType = QueryServiceHelper.query((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{qFilterOfBillType});
            Set billTypeIdSet = billType.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            qFilter_billType = new QFilter("draftbilltype", "in", billTypeIdSet);
            qFilter_billType_bill = new QFilter("drafttype", "in", billTypeIdSet);
            qFilter_billType_bill_pool = new QFilter("entryentity.e_draftbill.draftbilltype", "in", billTypeIdSet);
        }
        QFilter qFilter_orgid = new QFilter("company", "in", orgIds);
        QFilter qFilter_date = new QFilter("bizdate", "<=", (Object)filter_enddate).and(new QFilter("bizdate", ">=", (Object)filter_startdate));
        Date currentDate = new Date();
        currentDate = BillTradeQueryHelper.parseDate(currentDate, true);
        Date currentEaryDate = new Date();
        currentEaryDate = BillTradeQueryHelper.parseDate(currentEaryDate, false);
        Date newfilter_enddate = BillTradeQueryHelper.parseDate(filter_enddate, false);
        QFilter qFilter_date_forFinal = new QFilter("bizdate", ">=", (Object)newfilter_enddate).and(new QFilter("bizdate", "<=", (Object)currentDate));
        QFilter qFilter_date_forFinal_new = new QFilter("bizdate", ">=", (Object)filter_enddate).and(new QFilter("bizdate", "<=", (Object)currentDate));
        QFilter qFilterModifyTimeFinal = new QFilter("modifytime", "<=", (Object)filter_enddate).and("modifytime", "<=", (Object)currentDate);
        if (filter_enddate.after(currentEaryDate)) {
            qFilter_date_forFinal_new = new QFilter("bizdate", ">=", (Object)filter_enddate).and(new QFilter("bizdate", "<=", (Object)currentEaryDate));
            qFilterModifyTimeFinal = new QFilter("modifytime", "<=", (Object)filter_enddate).and("modifytime", "<=", (Object)currentEaryDate);
        }
        QFilter qFilter_billStatus = new QFilter("draftbilltranstatus", "=", (Object)"success");
        HashSet<String> draftType_pool = new HashSet<String>();
        draftType_pool.add("join");
        draftType_pool.add("out");
        QFilter qFilter_pool = new QFilter("businesstype", "in", draftType_pool);
        DataSet returnDataSet = null;
        switch (filter_datatype.toString()) {
            case "A": {
                HashSet<String> draftType_rec = new HashSet<String>();
                draftType_rec.add("refund");
                draftType_rec.add("endorse");
                draftType_rec.add("discount");
                draftType_rec.add("collect");
                draftType_rec.add("pledge");
                draftType_rec.add("trusteeship");
                draftType_rec.add("rlspledge");
                draftType_rec.add("retrieve");
                QFilter qFilter_draft_rec = new QFilter("tradetype", "in", draftType_rec);
                HashSet<String> notInSetOfFinal = new HashSet<String>();
                notInSetOfFinal.add("registered");
                notInSetOfFinal.add("pledged");
                notInSetOfFinal.add("collocated");
                QFilter qFilter_InSplited_rec_final = new QFilter("draftbillstatus", "!=", (Object)"splited");
                QFilter qFilter_notIn_rec_final = new QFilter("draftbillstatus", "not in", notInSetOfFinal);
                QFilter qFilter_In_rec_final = new QFilter("draftbillstatus", "in", notInSetOfFinal);
                QFilter qFilterrptype = new QFilter("rptype", "=", (Object)"receivebill");
                List<QFilter> qFilter_recList = Arrays.asList(qFilter_orgid, qFilter_date, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptype, qFilter_InSplited_rec_final);
                List<QFilter> qFilter_recList_final_List = Arrays.asList(qFilter_orgid, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptype, qFilter_In_rec_final, qFilter_InSplited_rec_final);
                List<QFilter> qFilter_rec_finalList = Arrays.asList(qFilter_orgid, qFilter_date_forFinal, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptype, qFilter_notIn_rec_final, qFilter_InSplited_rec_final);
                List<QFilter> qFilter_rec_NoStatusfinalList = Arrays.asList(qFilter_orgid, qFilter_date_forFinal_new, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptype, qFilter_InSplited_rec_final);
                List<QFilter> qFilter_rec_billList = Arrays.asList(qFilter_orgid, qFilter_date, qFilter_billStatus, qFilter_draft_rec, qFilter_curr, qFilter_billType_bill);
                List<QFilter> qFilter_recTrade_billList = Arrays.asList(qFilter_orgid, qFilter_date_forFinal_new, qFilter_billStatus, qFilter_draft_rec, qFilter_curr, qFilter_billType_bill);
                List<QFilter> qFilter_rec_bill_poolList = Arrays.asList(qFilter_orgid, qFilter_date, qFilter_pool, qFilter_curr, qFilter_billType_bill_pool);
                QFilter[] qFilter_rec = BillTradeQueryHelper.getQfilter(qFilter_recList);
                QFilter[] qFilter_rec_final = BillTradeQueryHelper.getQfilter(qFilter_rec_finalList);
                QFilter[] qFilter_rec_bill = BillTradeQueryHelper.getQfilter(qFilter_rec_billList);
                QFilter[] qFilter_recTrade_bill = BillTradeQueryHelper.getQfilter(qFilter_recTrade_billList);
                QFilter[] qFilter_rec_bill_pool = BillTradeQueryHelper.getQfilter(qFilter_rec_bill_poolList);
                QFilter[] qFilter_recList_final = BillTradeQueryHelper.getQfilter(qFilter_recList_final_List);
                QFilter[] qFilter_rec_NoStatusfinal = BillTradeQueryHelper.getQfilter(qFilter_rec_NoStatusfinalList);
                HashMap<String, QFilter[]> mapQfilter = new HashMap<String, QFilter[]>();
                mapQfilter.put("qFilter_rec", qFilter_rec);
                mapQfilter.put("qFilter_rec_bill", qFilter_rec_bill);
                mapQfilter.put("qFilter_rec_final", qFilter_rec_final);
                mapQfilter.put("qFilter_rec_bill_pool", qFilter_rec_bill_pool);
                mapQfilter.put("qFilter_recList_final", qFilter_recList_final);
                mapQfilter.put("qFilter_recTrade_bill", qFilter_recTrade_bill);
                mapQfilter.put("qFilter_rec_NoStatusfinal", qFilter_rec_NoStatusfinal);
                returnDataSet = BillTradeQueryHelper.getRecDataSet(transQueryParam, filterCurrIdSet, mapQfilter);
                break;
            }
            case "B": {
                QFilter qFilter_draft_pay = new QFilter("tradetype", "=", (Object)"payoff");
                QFilter qFilter_pay_status = new QFilter("draftbillstatus", "!=", (Object)"registered");
                QFilter qFilter_pay_register_status = new QFilter("draftbillstatus", "=", (Object)"registered");
                QFilter qFilterInvalid = new QFilter("billstatus", "=", (Object)"H");
                QFilter qFilterrptypePay = new QFilter("rptype", "=", (Object)"paybill");
                QFilter qFilterModifyTime = new QFilter("modifytime", "<=", (Object)filter_enddate).and("modifytime", ">=", (Object)filter_startdate);
                List<QFilter> qFilter_pay_billList = Arrays.asList(qFilter_orgid, qFilter_date, qFilter_billStatus, qFilter_draft_pay, qFilter_curr, qFilter_billType_bill);
                List<QFilter> qFilter_pay_billFinalList = Arrays.asList(qFilter_orgid, qFilter_date_forFinal_new, qFilter_billStatus, qFilter_draft_pay, qFilter_curr, qFilter_billType_bill);
                List<QFilter> qFilter_payList = Arrays.asList(qFilter_orgid, qFilter_date, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptypePay);
                List<QFilter> qFilter_payFinalList = Arrays.asList(qFilter_orgid, qFilter_date_forFinal_new, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptypePay);
                List<QFilter> qFilter_payAllList = Arrays.asList(qFilter_orgid, qFilter_pay_register_status, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterrptypePay);
                List<QFilter> qFilter_pay_modifyList = Arrays.asList(qFilter_orgid, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterInvalid, qFilterModifyTime, qFilterrptypePay);
                List<QFilter> qFilter_pay_modifyFinalList = Arrays.asList(qFilter_orgid, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilterInvalid, qFilterModifyTimeFinal, qFilterrptypePay);
                List<QFilter> qFilter_pay_finalList = Arrays.asList(qFilter_orgid, qFilter_date_forFinal, qFilter_billStatus, qFilter_curr, qFilter_billType, qFilter_pay_status, qFilterrptypePay);
                QFilter[] qFilter_pay_bill = BillTradeQueryHelper.getQfilter(qFilter_pay_billList);
                QFilter[] qFilter_pay = BillTradeQueryHelper.getQfilter(qFilter_payList);
                QFilter[] qFilter_pay_final = BillTradeQueryHelper.getQfilter(qFilter_pay_finalList);
                QFilter[] qFilter_pay_modify = BillTradeQueryHelper.getQfilter(qFilter_pay_modifyList);
                QFilter[] qFilter_pay_modifyFinal = BillTradeQueryHelper.getQfilter(qFilter_pay_modifyFinalList);
                QFilter[] qFilter_pay_billFinal = BillTradeQueryHelper.getQfilter(qFilter_pay_billFinalList);
                QFilter[] qFilter_payFinal = BillTradeQueryHelper.getQfilter(qFilter_payFinalList);
                QFilter[] qFilter_payAll = BillTradeQueryHelper.getQfilter(qFilter_payAllList);
                HashMap<String, QFilter[]> map = new HashMap<String, QFilter[]>();
                map.put("qFilter_pay_bill", qFilter_pay_bill);
                map.put("qFilter_pay", qFilter_pay);
                map.put("qFilter_pay_final", qFilter_pay_final);
                map.put("qFilter_pay_modify", qFilter_pay_modify);
                map.put("qFilter_pay_modifyFinal", qFilter_pay_modifyFinal);
                map.put("qFilter_pay_billFinal", qFilter_pay_billFinal);
                map.put("qFilter_payFinal", qFilter_payFinal);
                map.put("qFilter_payAll", qFilter_payAll);
                returnDataSet = BillTradeQueryHelper.getPayDataSet(transQueryParam, filterCurrIdSet, map);
                break;
            }
            case "C": {
                DynamicObjectCollection filter_billPool = (DynamicObjectCollection)transQueryParam.get("filter_billtradepool");
                QFilter qFilter_bill_poolId = null;
                QFilter qFilter_bill_poolIdNotNull = new QFilter("billpool", "!=", (Object)0L);
                if (null != filter_billPool && filter_billPool.size() != 0) {
                    Set<Object> filterBillPoolIdSet = new HashSet();
                    filterBillPoolIdSet = filter_billPool.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                    qFilter_bill_poolId = new QFilter("billpool", "in", filterBillPoolIdSet);
                }
                List<QFilter> qFilter_bill_poolList = Arrays.asList(qFilter_bill_poolId, qFilter_bill_poolIdNotNull, qFilter_orgid, qFilter_date, qFilter_pool, qFilter_curr, qFilter_billType_bill_pool);
                List<QFilter> qFilter_bill_pool_finalList = Arrays.asList(qFilter_bill_poolId, qFilter_bill_poolIdNotNull, qFilter_orgid, qFilter_date_forFinal, qFilter_pool, qFilter_curr, qFilter_billType_bill_pool);
                List<QFilter> qFilter_inPoolList = Arrays.asList(qFilter_orgid, qFilter_curr, qFilter_billType, qFilter_bill_poolId, qFilter_bill_poolIdNotNull);
                QFilter[] qFilter_bill_pool = BillTradeQueryHelper.getQfilter(qFilter_bill_poolList);
                QFilter[] qFilter_bill_pool_final = BillTradeQueryHelper.getQfilter(qFilter_bill_pool_finalList);
                QFilter[] qFilter_bill_in_pool_final = BillTradeQueryHelper.getQfilter(qFilter_inPoolList);
                returnDataSet = BillTradeQueryHelper.getBillPoolDataSet(transQueryParam, filterCurrIdSet, qFilter_bill_pool, qFilter_bill_pool_final, qFilter_bill_in_pool_final);
            }
        }
        return returnDataSet;
    }

    private static DataSet getBillPoolDataSet(Map<String, Object> transQueryParam, Set<Long> filterCurrIdSet, QFilter[] qFilter_bill_pool, QFilter[] qFilter_bill_pool_final, QFilter[] qFilter_inPoolList) {
        DynamicObject filter_reportcurrency = (DynamicObject)transQueryParam.get("filter_statcurrency");
        DataSet billpoolDataSet = QueryServiceHelper.queryDataSet((String)"BillPoolDataSet", (String)CDM_BILLPOOLBIZ, (String)"billpool,billpool.name as billpoolname,company,company.name,entryentity.e_draftbill,entryentity.e_draftbill.draftbilltype as draftbilltype,entryentity.e_draftbill.draftbilltype.name as billtype,currency,currency.name,businesstype,entryentity.e_draftbill.amount as amountpool", (QFilter[])qFilter_bill_pool, null);
        DataSet finish_bill_pool_sum = billpoolDataSet.copy().select(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool"}).groupBy(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("amountpool").finish();
        finish_bill_pool_sum = finish_bill_pool_sum.copy().leftJoin(billpoolDataSet.copy().filter("businesstype = 'join'").groupBy(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("amountpool").finish()).on("company", "company").on("draftbilltype", "draftbilltype").on("currency", "currency").select(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool"}, new String[]{"amountpool oriamountenterpool"}).finish();
        finish_bill_pool_sum = finish_bill_pool_sum.leftJoin(billpoolDataSet.copy().filter("businesstype = 'out'").groupBy(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("amountpool").finish()).on("company", "company").on("draftbilltype", "draftbilltype").on("currency", "currency").select(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool", "oriamountenterpool"}, new String[]{"amountpool oriamountoutpool"}).finish();
        DataSet billpoolDataSet_curr = QueryServiceHelper.queryDataSet((String)"BillPoolDataSetCurr", (String)CDM_BILLPOOLBIZ, (String)"billpool,billpool.name as billpoolname,company,company.name,entryentity.e_draftbill,entryentity.e_draftbill.draftbilltype as draftbilltype,entryentity.e_draftbill.draftbilltype.name as billtype,currency,currency.name,businesstype,amount as amountpool", (QFilter[])qFilter_bill_pool_final, null);
        finish_bill_pool_sum = finish_bill_pool_sum.fullJoin(billpoolDataSet_curr.copy().filter("businesstype = 'join'").groupBy(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("amountpool").finish()).on("company", "company").on("draftbilltype", "draftbilltype").on("currency", "currency").select(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool", "oriamountenterpool", "oriamountoutpool"}, new String[]{"billpool billpoolentercurr", "billpoolname billpoolnameentercurr", "company companyentercurr", "company.name companynameentercurr", "draftbilltype  draftbilltypeentercurr", "billtype billtypeentercurr", "currency currencyentercurr", "currency.name currencynameentercurr", "amountpool orienterpoolamountcurr"}).finish();
        finish_bill_pool_sum = finish_bill_pool_sum.select(new String[]{BillTradeQueryHelper.getValidField("billpool", "billpoolentercurr"), BillTradeQueryHelper.getValidField("billpoolname", "billpoolnameentercurr"), BillTradeQueryHelper.getValidField("company", "companyentercurr"), BillTradeQueryHelper.getValidField("company.name", "companynameentercurr"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypeentercurr"), BillTradeQueryHelper.getValidField("billtype", "billtypeentercurr"), BillTradeQueryHelper.getValidField("currency", "currencyentercurr"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynameentercurr"), BillTradeQueryHelper.getZeroField("amountpool"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("orienterpoolamountcurr")});
        finish_bill_pool_sum = finish_bill_pool_sum.fullJoin(billpoolDataSet_curr.copy().filter("businesstype = 'out'").groupBy(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "billtype", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("amountpool").finish()).on("billpool", "billpool").on("billpoolname", "billpoolname").on("company", "company").on("draftbilltype", "draftbilltype").on("currency", "currency").select(new String[]{"billpool", "billpoolname", "company", "company.name as companyname", "draftbilltype", "billtype", "currency as orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool", "oriamountenterpool", "oriamountoutpool", "orienterpoolamountcurr"}, new String[]{"billpool billpooloutcurr", "billpoolname billpoolnameoutcurr", "company companyoutcurr", "company.name companynameoutcurr", "draftbilltype  draftbilltypeoutcurr", "billtype billtypeoutcurr", "currency currencyoutcurr", "currency.name currencynameoutcurr", "amountpool oriamountoutpoolcurr"}).finish();
        BillTradeQueryHelper.closeDataSet(billpoolDataSet_curr);
        finish_bill_pool_sum = finish_bill_pool_sum.select(new String[]{BillTradeQueryHelper.getValidField("billpool", "billpooloutcurr"), BillTradeQueryHelper.getValidField("billpoolname", "billpoolnameoutcurr"), BillTradeQueryHelper.getValidField("company", "companyoutcurr"), BillTradeQueryHelper.getValidField("companyname", "companynameoutcurr"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypeoutcurr"), BillTradeQueryHelper.getValidField("billtype", "billtypeoutcurr"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencyoutcurr"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynameoutcurr"), BillTradeQueryHelper.getZeroField("amountpool"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("orienterpoolamountcurr"), BillTradeQueryHelper.getZeroField("oriamountoutpoolcurr")});
        DataSet inPillDataSet = QueryServiceHelper.queryDataSet((String)"InPoolBillDataSet", (String)CDM_RECEIVABLEBILL, (String)"billpool,billpool.name as billpoolname,company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount as inpoolamount", (QFilter[])qFilter_inPoolList, null);
        DataSet finish_bill_inpool_sum = inPillDataSet.copy().select(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "inpoolamount"}).groupBy(new String[]{"billpool", "billpoolname", "company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("inpoolamount").finish();
        finish_bill_pool_sum = finish_bill_pool_sum.fullJoin(finish_bill_inpool_sum).on("billpool", "billpool").on("billpoolname", "billpoolname").on("company", "company").on("draftbilltype", "draftbilltype").on("orginalcurrency", "currency").select(new String[]{"billpool", "billpoolname", "company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool", "oriamountenterpool", "oriamountoutpool", "orienterpoolamountcurr", "oriamountoutpoolcurr"}, new String[]{"billpool billpoolinpool", "billpoolname billpoolnameinpool", "company companyinpool", "company.name companynameinpool", "draftbilltype  draftbilltypeinpool", "draftbilltype.name billtypeinpool", "currency currencyinpool", "currency.name currencynameinpool", "inpoolamount"}).finish();
        finish_bill_pool_sum = finish_bill_pool_sum.select(new String[]{BillTradeQueryHelper.getValidField("billpool", "billpoolinpool"), BillTradeQueryHelper.getValidField("billpoolname", "billpoolnameinpool"), BillTradeQueryHelper.getValidField("company", "companyinpool"), BillTradeQueryHelper.getValidField("companyname", "companynameinpool"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypeinpool"), BillTradeQueryHelper.getValidField("billtype", "billtypeinpool"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencyinpool"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynameinpool"), BillTradeQueryHelper.getZeroField("amountpool"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("orienterpoolamountcurr"), BillTradeQueryHelper.getZeroField("oriamountoutpoolcurr"), BillTradeQueryHelper.getZeroField("inpoolamount")});
        BillTradeQueryHelper.closeDataSet(inPillDataSet, finish_bill_inpool_sum);
        finish_bill_pool_sum = finish_bill_pool_sum.select(new String[]{"billpool", "billpoolname", "company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amountpool", "oriamountenterpool", "oriamountoutpool", "orienterpoolamountcurr", "oriamountoutpoolcurr", "inpoolamount"}).orderBy(new String[]{"billpoolname ASC", "companyname ASC", "billtype ASC", "currency.name ASC"});
        DataSet ratedataSet = BillTradeQueryHelper.getRate(transQueryParam, filterCurrIdSet, finish_bill_pool_sum);
        finish_bill_pool_sum = finish_bill_pool_sum.join(ratedataSet, JoinType.LEFT).on("orginalcurrency", EXRATE_TABLE_CURRENCY_ID).select(new String[]{"billpool", "billpoolname", "company", "companyname", "draftbilltype", "billtype", "billtype as billtypeorder", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currency.name as currencyname", "amountpool", BillTradeQueryHelper.getUnitField("oriamountenterpool"), BillTradeQueryHelper.getUnitField("oriamountoutpool"), BillTradeQueryHelper.getUnitField("orienterpoolamountcurr"), BillTradeQueryHelper.getUnitField("oriamountoutpoolcurr"), BillTradeQueryHelper.getUnitField("inpoolamount")}, new String[]{EXRATE_TABLE_EXCHG_RATE}).finish();
        finish_bill_pool_sum = finish_bill_pool_sum.addField("inpoolamount + oriamountoutpoolcurr - orienterpoolamountcurr", "oriamountenddate");
        finish_bill_pool_sum = finish_bill_pool_sum.addField("oriamountenddate + oriamountoutpool - oriamountenterpool", "originalamount");
        DataSet returnDataSet = finish_bill_pool_sum.addField("originalamount * exchgRate", "reportamount").addField("oriamountenterpool * exchgRate", "repamountenterpool").addField("oriamountoutpool * exchgRate", "repamountoutpool").addField("oriamountenddate * exchgRate", "repamountenddate");
        returnDataSet = returnDataSet.addField("1", "usuallevel").addField("1", "typesumlevel").addField("1", "companysumlevel").addField("1", "poolsumlevel").addField("1", "totalsumlevel");
        DataSet billTypeLevelDataSet = returnDataSet.copy().groupBy(new String[]{"billpool", "billpoolname", "company", "companyname", "billtype", "billtypeorder"}).sum("reportamount").sum("repamountenterpool").sum("repamountoutpool").sum("repamountenddate").finish().addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "companysumlevel").addField("1", "totalsumlevel").addField("1", "poolsumlevel");
        billTypeLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(billTypeLevelDataSet.copy(), returnDataSet.copy(), false, true, false, false);
        returnDataSet = returnDataSet.union(billTypeLevelDataSet);
        DataSet companyLevelDataSet = returnDataSet.copy().filter("typesumlevel = 2").groupBy(new String[]{"billpool", "billpoolname", "company", "companyname"}).sum("reportamount").sum("repamountenterpool").sum("repamountoutpool").sum("repamountenddate").finish().addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "totalsumlevel").addField("1", "poolsumlevel");
        companyLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(companyLevelDataSet.copy(), returnDataSet.copy(), false, false, true, false);
        returnDataSet = returnDataSet.union(companyLevelDataSet);
        DataSet poolLevelDataSet = returnDataSet.copy().filter("companysumlevel = 3").groupBy(new String[]{"billpool", "billpoolname"}).sum("reportamount").sum("repamountenterpool").sum("repamountoutpool").sum("repamountenddate").finish().addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "totalsumlevel").addField("4", "poolsumlevel");
        poolLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(poolLevelDataSet.copy(), returnDataSet.copy(), false, false, false, true);
        returnDataSet = returnDataSet.union(poolLevelDataSet);
        DataSet allSumLevelDataSet = returnDataSet.copy().filter("poolsumlevel = 4").groupBy(new String[]{"usuallevel"}).sum("reportamount").sum("repamountenterpool").sum("repamountoutpool").sum("repamountenddate").finish().addField("4", "totalsumlevel").addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel").addField("5", "totalsumlevel");
        billTypeLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(allSumLevelDataSet.copy(), returnDataSet.copy(), true, false, false, false);
        returnDataSet = returnDataSet.union(billTypeLevelDataSet);
        returnDataSet = returnDataSet.addField("companyname", "companynameorder").addField("billpoolname", "billpoolnameorder").addField(filter_reportcurrency.getPkValue().toString(), SELECT_FIELD_BANK_REPORT_CURRENCY).addField("'" + filter_reportcurrency.getString("name") + "'", "reportcurrencyname");
        returnDataSet = returnDataSet.select(new String[]{"billpool", "billpoolname", "company", "companyname", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currencyname", SELECT_FIELD_BANK_REPORT_CURRENCY, "reportcurrencyname", "companynameorder", "billpoolnameorder", "billtypeorder", "originalamount", "oriamountenterpool", "oriamountoutpool", "oriamountenddate", "reportamount", "repamountenterpool", "repamountoutpool", "repamountenddate", "usuallevel", "companysumlevel", "typesumlevel", "totalsumlevel", "poolsumlevel"}).orderBy(new String[]{"totalsumlevel", "billpoolnameorder ASC", "poolsumlevel", "companynameorder ASC", "companysumlevel", "billtypeorder ASC", "typesumlevel", "currency.name ASC"});
        return returnDataSet;
    }

    private static DataSet getPayDataSet(Map<String, Object> transQueryParam, Set<Long> filterCurrIdSet, Map<String, QFilter[]> map) {
        DynamicObject filter_reportcurrency = (DynamicObject)transQueryParam.get("filter_statcurrency");
        QFilter[] qFilter_pay_bill = map.get("qFilter_pay_bill");
        QFilter[] qFilter_pay = map.get("qFilter_pay");
        QFilter[] qFilter_pay_final = map.get("qFilter_pay_final");
        QFilter[] qFilter_pay_modifyFinal = map.get("qFilter_pay_modifyFinal");
        QFilter[] qFilter_pay_billTradeFinal = map.get("qFilter_pay_billFinal");
        QFilter[] qFilter_payFinal = map.get("qFilter_payFinal");
        QFilter[] qFilter_payAll = map.get("qFilter_payAll");
        QFilter[] qFilter_pay_modify = map.get("qFilter_pay_modify");
        DataSet payDataSet = QueryServiceHelper.queryDataSet((String)"PayData", (String)CDM_PAYABLEBILL, (String)"company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount,draftbilltranstatus,draftbillstatus,bizdate,modifytime,billstatus", (QFilter[])qFilter_pay, null);
        DataSet payDataSetSum_All = payDataSet.copy().select("company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount as oriamountbilling,draftbilltranstatus,draftbillstatus,bizdate").groupBy(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("oriamountbilling").finish();
        DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)"PayBillData", (String)CDM_DRAFTTRADEBILL, (String)"company as companybill,company.name as companynamebill,drafttype as drafttypebill,drafttype.name as drafttypenamebill,currency as currencybill,currency.name as currencynamebill,tradetype,amount", (QFilter[])qFilter_pay_bill, null);
        payBillDataSet = payBillDataSet.select("companybill,companynamebill,drafttypebill,drafttypenamebill,currencybill,currencynamebill,tradetype,amount as amountbill").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish();
        DataSet payDataSetModify = QueryServiceHelper.queryDataSet((String)"PayDataModify", (String)CDM_PAYABLEBILL, (String)"company as companymodify ,company.name as companynamemodify,draftbilltype as draftbilltypemodify,draftbilltype.name as draftbilltypenamemodify,currency as currencymodify,currency.name as currencynamemodify,amount,draftbilltranstatus,draftbillstatus,bizdate,modifytime,billstatus", (QFilter[])qFilter_pay_modify, null);
        DataSet payInvaildDataSetSum = payDataSetModify.select("companymodify,companynamemodify,draftbilltypemodify,draftbilltypenamemodify,currencymodify,currencynamemodify,amount as invalidAmount,draftbilltranstatus,draftbillstatus,modifytime").groupBy(new String[]{"companymodify", "companynamemodify", "draftbilltypemodify", "draftbilltypenamemodify", "currencymodify", "currencynamemodify"}).sum("invalidAmount").finish();
        payDataSetSum_All = payDataSetSum_All.fullJoin(payInvaildDataSetSum).on("company", "companymodify").on("draftbilltype", "draftbilltypemodify").on("currency", "currencymodify").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling"}, new String[]{"companymodify", "companynamemodify", "draftbilltypemodify", "draftbilltypenamemodify", "currencymodify", "currencynamemodify", "invalidAmount"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companymodify"), BillTradeQueryHelper.getValidField("company.name", "companynamemodify"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypemodify"), BillTradeQueryHelper.getValidField("draftbilltype.name", "draftbilltypenamemodify"), BillTradeQueryHelper.getValidField("currency", "currencymodify"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamemodify"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("invalidAmount")});
        payDataSetSum_All = payDataSetSum_All.fullJoin(payBillDataSet).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "invalidAmount"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("invalidAmount"), BillTradeQueryHelper.getZeroField("amountbill")});
        payDataSetSum_All = payDataSetSum_All.addField("invalidAmount + amountbill", "oriamountpayoff");
        DataSet dataSetRegisteredSum = payDataSet.copy().filter("'registered' = draftbillstatus").select("company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount as  registeredamount,draftbilltranstatus,draftbillstatus").groupBy(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("registeredamount").finish();
        DataSet payDataSetCurr = QueryServiceHelper.queryDataSet((String)"PayDataCurr", (String)CDM_PAYABLEBILL, (String)"company as companycurr,company.name as companynamecurr,draftbilltype as draftbilltypecurr,draftbilltype.name as draftbilltypenamecurr,currency as currencycurr,currency.name as currencynamecurr,amount,draftbilltranstatus,draftbillstatus", (QFilter[])qFilter_pay_final, null);
        DataSet dataSetNotRegisteredSum = payDataSetCurr.copy().select("companycurr,companynamecurr,draftbilltypecurr,draftbilltypenamecurr,currencycurr,currencynamecurr,amount as notregisteredamount,draftbilltranstatus,draftbillstatus").groupBy(new String[]{"companycurr", "companynamecurr", "draftbilltypecurr", "draftbilltypenamecurr", "currencycurr", "currencynamecurr"}).sum("notregisteredamount").finish();
        payDataSetSum_All = payDataSetSum_All.leftJoin(dataSetRegisteredSum).on("company", "company").on("draftbilltype", "draftbilltype").on("currency", "currency").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "oriamountpayoff"}, new String[]{"registeredamount"}).finish();
        payDataSetSum_All = payDataSetSum_All.fullJoin(dataSetNotRegisteredSum).on("company", "companycurr").on("draftbilltype", "draftbilltypecurr").on("currency", "currencycurr").select(new String[]{"company", "company.name as companyname", "draftbilltype", "draftbilltype.name as billtype", "currency as orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "oriamountpayoff", "registeredamount"}, new String[]{"companycurr", "companynamecurr", "draftbilltypecurr", "draftbilltypenamecurr", "currencycurr", "currencynamecurr", "notregisteredamount"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companycurr"), BillTradeQueryHelper.getValidField("companyname", "companynamecurr"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypecurr"), BillTradeQueryHelper.getValidField("billtype", "draftbilltypenamecurr"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencycurr"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamecurr"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("oriamountpayoff"), BillTradeQueryHelper.getZeroField("registeredamount"), BillTradeQueryHelper.getZeroField("notregisteredamount")});
        BillTradeQueryHelper.closeDataSet(payDataSetCurr);
        DataSet payDataSetAll = QueryServiceHelper.queryDataSet((String)"PayDataAll", (String)CDM_PAYABLEBILL, (String)"company as companyall,company.name as companynameall,draftbilltype as draftbilltypeall,draftbilltype.name as draftbilltypenameall,currency as currencyall,currency.name as currencynameall,amount,draftbilltranstatus,draftbillstatus", (QFilter[])qFilter_payAll, null);
        DataSet dataSetAllSum = payDataSetAll.copy().select("companyall,companynameall,draftbilltypeall,draftbilltypenameall,currencyall,currencynameall,amount as amountall,draftbilltranstatus,draftbillstatus").groupBy(new String[]{"companyall", "companynameall", "draftbilltypeall", "draftbilltypenameall", "currencyall", "currencynameall"}).sum("amountall").finish();
        payDataSetSum_All = payDataSetSum_All.fullJoin(dataSetAllSum).on("company", "companyall").on("draftbilltype", "draftbilltypeall").on("orginalcurrency", "currencyall").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "oriamountpayoff", "registeredamount", "notregisteredamount"}, new String[]{"companyall", "companynameall", "draftbilltypeall", "draftbilltypenameall", "currencyall", "currencynameall", "amountall"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companyall"), BillTradeQueryHelper.getValidField("companyname", "companynameall"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypeall"), BillTradeQueryHelper.getValidField("billtype", "draftbilltypenameall"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencyall"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynameall"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("oriamountpayoff"), BillTradeQueryHelper.getZeroField("registeredamount"), BillTradeQueryHelper.getZeroField("notregisteredamount"), BillTradeQueryHelper.getZeroField("amountall")});
        DataSet tradeFinalDataSet = QueryServiceHelper.queryDataSet((String)"TradeBillData", (String)CDM_DRAFTTRADEBILL, (String)"company as companyfinal,company.name as companynamefinal,drafttype as drafttypefinal,drafttype.name as drafttypenamefinal,currency as currencyfinal,currency.name as currencynamefinal,tradetype,amount", (QFilter[])qFilter_pay_billTradeFinal, null);
        DataSet tradedataSetFinalSum = tradeFinalDataSet.copy().select("companyfinal,companynamefinal,drafttypefinal,drafttypenamefinal,currencyfinal,currencynamefinal,amount as amounttradefinal").groupBy(new String[]{"companyfinal", "companynamefinal", "drafttypefinal", "drafttypenamefinal", "currencyfinal", "currencynamefinal"}).sum("amounttradefinal").finish();
        payDataSetSum_All = payDataSetSum_All.fullJoin(tradedataSetFinalSum).on("company", "companyfinal").on("draftbilltype", "drafttypefinal").on("orginalcurrency", "currencyfinal").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "oriamountpayoff", "registeredamount", "notregisteredamount", "amountall"}, new String[]{"companyfinal", "companynamefinal", "drafttypefinal", "drafttypenamefinal", "currencyfinal", "currencynamefinal", "amounttradefinal"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companyfinal"), BillTradeQueryHelper.getValidField("companyname", "companynamefinal"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypefinal"), BillTradeQueryHelper.getValidField("billtype", "drafttypenamefinal"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencyfinal"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamefinal"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("oriamountpayoff"), BillTradeQueryHelper.getZeroField("registeredamount"), BillTradeQueryHelper.getZeroField("notregisteredamount"), BillTradeQueryHelper.getZeroField("amountall"), BillTradeQueryHelper.getZeroField("amounttradefinal")});
        DataSet PayInvaildFinalData = QueryServiceHelper.queryDataSet((String)"PayInvaildFinalData", (String)CDM_PAYABLEBILL, (String)"company as companyinfinal,company.name as companynameinfinal,draftbilltype as draftbilltypeinfinal,draftbilltype.name as draftbilltypenameinfinal,currency as currencyinfinal,currency.name as currencynameinfinal,amount,draftbilltranstatus,draftbillstatus", (QFilter[])qFilter_pay_modifyFinal, null);
        DataSet PayInvaildFinalDataSum = PayInvaildFinalData.copy().select("companyinfinal,companynameinfinal,draftbilltypeinfinal,draftbilltypenameinfinal,currencyinfinal,currencynameinfinal,amount as amountinfinal").groupBy(new String[]{"companyinfinal", "companynameinfinal", "draftbilltypeinfinal", "draftbilltypenameinfinal", "currencyinfinal", "currencynameinfinal"}).sum("amountinfinal").finish();
        payDataSetSum_All = payDataSetSum_All.fullJoin(PayInvaildFinalDataSum).on("company", "companyinfinal").on("draftbilltype", "draftbilltypeinfinal").on("orginalcurrency", "currencyinfinal").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "oriamountpayoff", "registeredamount", "notregisteredamount", "amountall", "amounttradefinal"}, new String[]{"companyinfinal", "companynameinfinal", "draftbilltypeinfinal", "draftbilltypenameinfinal", "currencyinfinal", "currencynameinfinal", "amountinfinal"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companyinfinal"), BillTradeQueryHelper.getValidField("companyname", "companynameinfinal"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypeinfinal"), BillTradeQueryHelper.getValidField("billtype", "draftbilltypenameinfinal"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencyinfinal"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynameinfinal"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("oriamountpayoff"), BillTradeQueryHelper.getZeroField("registeredamount"), BillTradeQueryHelper.getZeroField("notregisteredamount"), BillTradeQueryHelper.getZeroField("amountall"), BillTradeQueryHelper.getZeroField("amounttradefinal"), BillTradeQueryHelper.getZeroField("amountinfinal")});
        DataSet payNoStatusFinalData = QueryServiceHelper.queryDataSet((String)"PayNoStatusFinalData", (String)CDM_PAYABLEBILL, (String)"company as companynsfinal,company.name as companynamensfinal,draftbilltype as draftbilltypensfinal,draftbilltype.name as draftbilltypenamensfinal,currency as currencynsfinal,currency.name as currencynamensfinal,amount,draftbilltranstatus,draftbillstatus", (QFilter[])qFilter_payFinal, null);
        DataSet PayNsFinalDataSum = payNoStatusFinalData.copy().select("companynsfinal,companynamensfinal,draftbilltypensfinal,draftbilltypenamensfinal,currencynsfinal,currencynamensfinal,amount as amountnsfinal").groupBy(new String[]{"companynsfinal", "companynamensfinal", "draftbilltypensfinal", "draftbilltypenamensfinal", "currencynsfinal", "currencynamensfinal"}).sum("amountnsfinal").finish();
        payDataSetSum_All = payDataSetSum_All.fullJoin(PayNsFinalDataSum).on("company", "companynsfinal").on("draftbilltype", "draftbilltypensfinal").on("orginalcurrency", "currencynsfinal").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "oriamountbilling", "oriamountpayoff", "registeredamount", "notregisteredamount", "amountall", "amounttradefinal", "amountinfinal"}, new String[]{"companynsfinal", "companynamensfinal", "draftbilltypensfinal", "draftbilltypenamensfinal", "currencynsfinal", "currencynamensfinal", "amountnsfinal"}).finish();
        payDataSetSum_All = payDataSetSum_All.select(new String[]{BillTradeQueryHelper.getValidField("company", "companynsfinal"), BillTradeQueryHelper.getValidField("companyname", "companynamensfinal"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypensfinal"), BillTradeQueryHelper.getValidField("billtype", "draftbilltypenamensfinal"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencynsfinal"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamensfinal"), BillTradeQueryHelper.getZeroField("oriamountbilling"), BillTradeQueryHelper.getZeroField("oriamountpayoff"), BillTradeQueryHelper.getZeroField("registeredamount"), BillTradeQueryHelper.getZeroField("notregisteredamount"), BillTradeQueryHelper.getZeroField("amountall"), BillTradeQueryHelper.getZeroField("amounttradefinal"), BillTradeQueryHelper.getZeroField("amountinfinal"), BillTradeQueryHelper.getZeroField("amountnsfinal")});
        BillTradeQueryHelper.closeDataSet(payDataSetAll, tradeFinalDataSet, PayInvaildFinalData, payNoStatusFinalData);
        payDataSetSum_All = payDataSetSum_All.addField("amountall +amounttradefinal + amountinfinal - amountnsfinal ", "oriamountenddate");
        payDataSetSum_All = payDataSetSum_All.addField("oriamountenddate + oriamountpayoff - oriamountbilling", "originalamount");
        payDataSetSum_All = payDataSetSum_All.select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currency.name as currencyname", "oriamountbilling", "oriamountpayoff", "oriamountenddate", "originalamount"}).orderBy(new String[]{"companyname ASC", "billtype ASC", "currency.name ASC"});
        DataSet ratedataSet = BillTradeQueryHelper.getRate(transQueryParam, filterCurrIdSet, payDataSetSum_All);
        payDataSetSum_All = payDataSetSum_All.join(ratedataSet, JoinType.LEFT).on("orginalcurrency", EXRATE_TABLE_CURRENCY_ID).select(new String[]{"company", "companyname", "billtype", "billtype as billtypeorder", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currencyname", BillTradeQueryHelper.getUnitField("oriamountbilling"), BillTradeQueryHelper.getUnitField("oriamountpayoff"), BillTradeQueryHelper.getUnitField("oriamountenddate"), BillTradeQueryHelper.getUnitField("originalamount")}, new String[]{EXRATE_TABLE_EXCHG_RATE}).finish();
        BillTradeQueryHelper.closeDataSet(ratedataSet);
        DataSet returnDataSet = payDataSetSum_All.addField("originalamount *exchgRate", "reportamount").addField("oriamountbilling * exchgRate", "repamountbilling").addField("oriamountpayoff * exchgRate", "repamountpayoff").addField("oriamountenddate * exchgRate", "repamountenddate");
        returnDataSet = returnDataSet.addField("1", "usuallevel").addField("1", "typesumlevel").addField("1", "companysumlevel").addField("1", "totalsumlevel");
        DataSet billTypeLevelDataSet = returnDataSet.copy().groupBy(new String[]{"company", "companyname", "billtype", "billtypeorder"}).sum("reportamount").sum("repamountbilling").sum("repamountpayoff").sum("repamountenddate").finish().addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "companysumlevel").addField("1", "totalsumlevel");
        billTypeLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(billTypeLevelDataSet.copy(), returnDataSet.copy(), false, true, false, false);
        returnDataSet = returnDataSet.union(billTypeLevelDataSet);
        DataSet companyLevelDataSet = returnDataSet.copy().filter("typesumlevel = 2").groupBy(new String[]{"company", "companyname"}).sum("reportamount").sum("repamountbilling").sum("repamountpayoff").sum("repamountenddate").finish().addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "totalsumlevel");
        companyLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(companyLevelDataSet.copy(), returnDataSet.copy(), false, false, true, false);
        returnDataSet = returnDataSet.union(companyLevelDataSet);
        DataSet allSumLevelDataSet = returnDataSet.copy().filter("companysumlevel = 3").groupBy(new String[]{"usuallevel"}).sum("reportamount").sum("repamountbilling").sum("repamountpayoff").sum("repamountenddate").finish().addField("4", "totalsumlevel").addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel");
        billTypeLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(allSumLevelDataSet.copy(), returnDataSet.copy(), true, false, false, false);
        returnDataSet = returnDataSet.union(billTypeLevelDataSet);
        returnDataSet = returnDataSet.addField("companyname", "companynameorder").addField(filter_reportcurrency.getPkValue().toString(), SELECT_FIELD_BANK_REPORT_CURRENCY).addField("'" + filter_reportcurrency.getString("name") + "'", "reportcurrencyname");
        returnDataSet = returnDataSet.select(new String[]{"company", "companyname", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currencyname", SELECT_FIELD_BANK_REPORT_CURRENCY, "reportcurrencyname", "companynameorder", "billtypeorder", "oriamountbilling", "oriamountpayoff", "oriamountenddate", "originalamount", "reportamount", "repamountbilling", "repamountpayoff", "repamountenddate", "usuallevel", "companysumlevel", "typesumlevel", "totalsumlevel"}).orderBy(new String[]{"totalsumlevel", "companynameorder ASC", "companysumlevel", "billtypeorder ASC", "typesumlevel", "currency.name ASC"});
        return returnDataSet;
    }

    private static DataSet getRecDataSet(Map<String, Object> transQueryParam, Set<Long> filterCurrIdSet, Map<String, QFilter[]> mapQfilter) {
        DynamicObject filter_reportcurrency = (DynamicObject)transQueryParam.get("filter_statcurrency");
        QFilter[] qFilter_rec = mapQfilter.get("qFilter_rec");
        QFilter[] qFilter_rec_final = mapQfilter.get("qFilter_rec_final");
        QFilter[] qFilter_rec_bill = mapQfilter.get("qFilter_rec_bill");
        QFilter[] qFilter_rec_bill_pool = mapQfilter.get("qFilter_rec_bill_pool");
        QFilter[] qFilter_recList_final = mapQfilter.get("qFilter_recList_final");
        QFilter[] qFilter_recTrade_bill = mapQfilter.get("qFilter_recTrade_bill");
        QFilter[] qFilter_rec_NoStatusfinal = mapQfilter.get("qFilter_rec_NoStatusfinal");
        DataSet recDataSet = QueryServiceHelper.queryDataSet((String)"ReceiveData", (String)CDM_RECEIVABLEBILL, (String)"company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount,draftbilltranstatus,draftbillstatus,bizdate", (QFilter[])qFilter_rec, null);
        DataSet recDataSet_Final = QueryServiceHelper.queryDataSet((String)"ReceiveData_final", (String)CDM_RECEIVABLEBILL, (String)"company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount,draftbilltranstatus,draftbillstatus,bizdate", (QFilter[])qFilter_recList_final, null);
        DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"BillData", (String)CDM_DRAFTTRADEBILL, (String)"company as companybill,company.name as companynamebill,drafttype as drafttypebill,drafttype.name as drafttypenamebill,currency as currencybill,currency.name as currencynamebill,tradetype,amount as amountbill", (QFilter[])qFilter_rec_bill, null);
        DataSet billTradeDataSetFinal = QueryServiceHelper.queryDataSet((String)"BillFinalData", (String)CDM_DRAFTTRADEBILL, (String)"company as companybilltf,company.name as companynamebilltf,drafttype as drafttypebilltf,drafttype.name as drafttypenamebilltf,currency as currencybilltf,currency.name as currencynamebilltf,tradetype,amount as amountbilltf", (QFilter[])qFilter_recTrade_bill, null);
        DataSet billpoolDataSet = QueryServiceHelper.queryDataSet((String)"BillPoolData", (String)CDM_BILLPOOLBIZ, (String)"company as companypool,company.name as companynamepool,entryentity.e_draftbill as  e_draftbillpool,entryentity.e_draftbill.draftbilltype as draftbilltypepool,entryentity.e_draftbill.draftbilltype.name as draftbilltypenamepool,currency as currencypool,currency.name as currencynamepool,businesstype,entryentity.e_draftbill.amount as amountpool", (QFilter[])qFilter_rec_bill_pool, null);
        DataSet recDataSetSum = recDataSet.copy().select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount"}).groupBy(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME}).sum("amount").finish();
        DataSet recFinalDataSet1 = recDataSet_Final.copy().select(new String[]{"company  as companyfinal1", "company.name  as companynamefinal1", "draftbilltype as draftbilltypefinal1", "draftbilltype.name  as draftbilltypenamefinal1", "currency  as currencyfinal1", "currency.name as currencynamefinal1", "amount as bedevideamount"}).groupBy(new String[]{"companyfinal1", "companynamefinal1", "draftbilltypefinal1", "draftbilltypenamefinal1", "currencyfinal1", "currencynamefinal1"}).sum("bedevideamount").finish();
        BillTradeQueryHelper.closeDataSet(recDataSet_Final);
        DataSet recNoStatusDataSet = QueryServiceHelper.queryDataSet((String)"RecNoStatusData", (String)CDM_RECEIVABLEBILL, (String)"company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount,draftbilltranstatus,draftbillstatus,bizdate", (QFilter[])qFilter_rec_NoStatusfinal, null);
        DataSet recNoStatusDataSetSum = recNoStatusDataSet.copy().select(new String[]{"company as companyNsfinal", "company.name as companynameNsfinal", "draftbilltype as draftbilltypeNsfinal", "draftbilltype.name as draftbilltypenameNsfinal", "currency as currencyNsfinal", "currency.name as currencynameNsfinal", "amount as amountNs"}).groupBy(new String[]{"companyNsfinal", "companynameNsfinal", "draftbilltypeNsfinal", "draftbilltypenameNsfinal", "currencyNsfinal", "currencynameNsfinal"}).sum("amountNs").finish();
        BillTradeQueryHelper.closeDataSet(recNoStatusDataSet);
        DataSet recFinalDataSet2 = QueryServiceHelper.queryDataSet((String)"ReceiveData_final_2", (String)CDM_RECEIVABLEBILL, (String)"company,company.name,draftbilltype,draftbilltype.name,currency,currency.name,amount as devideamount,draftbilltranstatus,draftbillstatus,bizdate", (QFilter[])qFilter_rec_final, null);
        DataSet recFinalDataSet2Sum = recFinalDataSet2.copy().select(new String[]{"company as companyfinal", "company.name as companynamefinal", "draftbilltype as draftbilltypefinal", "draftbilltype.name as draftbilltypenamefinal", "currency as currencyfinal", "currency.name as currencynamefinal", "devideamount"}).groupBy(new String[]{"companyfinal", "companynamefinal", "draftbilltypefinal", "draftbilltypenamefinal", "currencyfinal", "currencynamefinal"}).sum("devideamount").finish();
        recDataSetSum = recDataSetSum.fullJoin(recFinalDataSet1.copy()).on("company", "companyfinal1").on("draftbilltype", "draftbilltypefinal1").on("currency", "currencyfinal1").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount"}, new String[]{"companyfinal1", "companynamefinal1", "draftbilltypefinal1", "draftbilltypenamefinal1", "currencyfinal1", "currencynamefinal1", "bedevideamount"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companyfinal1"), BillTradeQueryHelper.getValidField("company.name", "companynamefinal1"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypefinal1"), BillTradeQueryHelper.getValidField("draftbilltype.name", "draftbilltypenamefinal1"), BillTradeQueryHelper.getValidField("currency", "currencyfinal1"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamefinal1"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount")});
        recDataSetSum = recDataSetSum.fullJoin(recFinalDataSet2Sum.copy()).on("company", "companyfinal").on("draftbilltype", "draftbilltypefinal").on("currency", "currencyfinal").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount"}, new String[]{"companyfinal", "companynamefinal", "draftbilltypefinal", "draftbilltypenamefinal", "currencyfinal", "currencynamefinal", "devideamount"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companyfinal"), BillTradeQueryHelper.getValidField("company.name", "companynamefinal"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypefinal"), BillTradeQueryHelper.getValidField("draftbilltype.name", "draftbilltypenamefinal"), BillTradeQueryHelper.getValidField("currency", "currencyfinal"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamefinal"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount")});
        BillTradeQueryHelper.closeDataSet(recFinalDataSet2Sum, recFinalDataSet2, recDataSet);
        recDataSetSum = recDataSetSum.fullJoin(billDataSet.copy().filter("tradetype = 'refund'").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish()).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill oriamountrecbill"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill")});
        recDataSetSum = recDataSetSum.fullJoin(billDataSet.copy().filter("tradetype = 'endorse'").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish()).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill oriamountendorse"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse")});
        recDataSetSum = recDataSetSum.fullJoin(billDataSet.copy().filter("tradetype = 'discount'").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish()).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill oriamountdiscount"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount")});
        recDataSetSum = recDataSetSum.fullJoin(billDataSet.copy().filter("tradetype = 'collect'").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish()).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill oriamountcollect"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect")});
        recDataSetSum = recDataSetSum.fullJoin(billDataSet.copy().filter("tradetype = 'pledge' or tradetype = 'trusteeship'").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish()).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill oriamountpledge"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge")});
        recDataSetSum = recDataSetSum.fullJoin(billDataSet.copy().filter("tradetype = 'rlspledge' or tradetype = 'retrieve'").groupBy(new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill"}).sum("amountbill").finish()).on("company", "companybill").on("draftbilltype", "drafttypebill").on("currency", "currencybill").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge"}, new String[]{"companybill", "companynamebill", "drafttypebill", "drafttypenamebill", "currencybill", "currencynamebill", "amountbill oriamountrlspledge"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybill"), BillTradeQueryHelper.getValidField("company.name", "companynamebill"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebill"), BillTradeQueryHelper.getValidField("draftbilltype.name", "drafttypenamebill"), BillTradeQueryHelper.getValidField("currency", "currencybill"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebill"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge")});
        BillTradeQueryHelper.closeDataSet(billDataSet);
        recDataSetSum = recDataSetSum.fullJoin(billpoolDataSet.copy().filter("businesstype = 'join'").groupBy(new String[]{"companypool", "companynamepool", "draftbilltypepool", "draftbilltypenamepool", "currencypool", "currencynamepool"}).sum("amountpool").finish()).on("company", "companypool").on("draftbilltype", "draftbilltypepool").on("currency", "currencypool").select(new String[]{"company", "company.name", "draftbilltype", "draftbilltype.name", "currency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge"}, new String[]{"companypool", "companynamepool", "draftbilltypepool", "draftbilltypenamepool", "currencypool", "currencynamepool", "amountpool oriamountenterpool"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companypool"), BillTradeQueryHelper.getValidField("company.name", "companynamepool"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypepool"), BillTradeQueryHelper.getValidField("draftbilltype.name", "draftbilltypenamepool"), BillTradeQueryHelper.getValidField("currency", "currencypool"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamepool"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool")});
        recDataSetSum = recDataSetSum.fullJoin(billpoolDataSet.copy().filter("businesstype = 'out'").groupBy(new String[]{"companypool", "companynamepool", "draftbilltypepool", "draftbilltypenamepool", "currencypool", "currencynamepool"}).sum("amountpool").finish()).on("company", "companypool").on("draftbilltype", "draftbilltypepool").on("currency", "currencypool").select(new String[]{"company", "company.name as companyname", "draftbilltype", "draftbilltype.name as billtype", "currency as orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool"}, new String[]{"companypool", "companynamepool", "draftbilltypepool", "draftbilltypenamepool", "currencypool", "currencynamepool", "amountpool oriamountoutpool"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companypool"), BillTradeQueryHelper.getValidField("companyname", "companynamepool"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypepool"), BillTradeQueryHelper.getValidField("billtype", "draftbilltypenamepool"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencypool"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamepool"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool")});
        BillTradeQueryHelper.closeDataSet(billpoolDataSet);
        recDataSetSum = recDataSetSum.fullJoin(recNoStatusDataSetSum.copy()).on("company", "companyNsfinal").on("draftbilltype", "draftbilltypeNsfinal").on("orginalcurrency", "currencyNsfinal").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool"}, new String[]{"companyNsfinal", "companynameNsfinal", "draftbilltypeNsfinal", "draftbilltypenameNsfinal", "currencyNsfinal", "currencynameNsfinal", "amountNs"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companyNsfinal"), BillTradeQueryHelper.getValidField("companyname", "companynameNsfinal"), BillTradeQueryHelper.getValidField("draftbilltype", "draftbilltypeNsfinal"), BillTradeQueryHelper.getValidField("billtype", "draftbilltypenameNsfinal"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencyNsfinal"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynameNsfinal"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("amountNs")});
        recDataSetSum = recDataSetSum.fullJoin(billTradeDataSetFinal.copy().filter("tradetype = 'endorse'").groupBy(new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf"}).sum("amountbilltf").finish()).on("company", "companybilltf").on("draftbilltype", "drafttypebilltf").on("orginalcurrency", "currencybilltf").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool", "amountNs"}, new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf", "amountbilltf amountfendorse"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybilltf"), BillTradeQueryHelper.getValidField("companyname", "companynamebilltf"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebilltf"), BillTradeQueryHelper.getValidField("billtype", "drafttypenamebilltf"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencybilltf"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebilltf"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("amountNs"), BillTradeQueryHelper.getZeroField("amountfendorse")});
        recDataSetSum = recDataSetSum.fullJoin(billTradeDataSetFinal.copy().filter("tradetype = 'discount'").groupBy(new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf"}).sum("amountbilltf").finish()).on("company", "companybilltf").on("draftbilltype", "drafttypebilltf").on("orginalcurrency", "currencybilltf").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool", "amountNs", "amountfendorse"}, new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf", "amountbilltf amountfdiscount"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybilltf"), BillTradeQueryHelper.getValidField("companyname", "companynamebilltf"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebilltf"), BillTradeQueryHelper.getValidField("billtype", "drafttypenamebilltf"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencybilltf"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebilltf"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("amountNs"), BillTradeQueryHelper.getZeroField("amountfendorse"), BillTradeQueryHelper.getZeroField("amountfdiscount")});
        recDataSetSum = recDataSetSum.fullJoin(billTradeDataSetFinal.copy().filter("tradetype = 'collect'").groupBy(new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf"}).sum("amountbilltf").finish()).on("company", "companybilltf").on("draftbilltype", "drafttypebilltf").on("orginalcurrency", "currencybilltf").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool", "amountNs", "amountfendorse", "amountfdiscount"}, new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf", "amountbilltf amountfcollect"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybilltf"), BillTradeQueryHelper.getValidField("companyname", "companynamebilltf"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebilltf"), BillTradeQueryHelper.getValidField("billtype", "drafttypenamebilltf"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencybilltf"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebilltf"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("amountNs"), BillTradeQueryHelper.getZeroField("amountfendorse"), BillTradeQueryHelper.getZeroField("amountfdiscount"), BillTradeQueryHelper.getZeroField("amountfcollect")});
        recDataSetSum = recDataSetSum.fullJoin(billTradeDataSetFinal.copy().filter("tradetype = 'refund'").groupBy(new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf"}).sum("amountbilltf").finish()).on("company", "companybilltf").on("draftbilltype", "drafttypebilltf").on("orginalcurrency", "currencybilltf").select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool", "amountNs", "amountfendorse", "amountfdiscount", "amountfcollect"}, new String[]{"companybilltf", "companynamebilltf", "drafttypebilltf", "drafttypenamebilltf", "currencybilltf", "currencynamebilltf", "amountbilltf amountfrefund"}).finish();
        recDataSetSum = recDataSetSum.select(new String[]{BillTradeQueryHelper.getValidField("company", "companybilltf"), BillTradeQueryHelper.getValidField("companyname", "companynamebilltf"), BillTradeQueryHelper.getValidField("draftbilltype", "drafttypebilltf"), BillTradeQueryHelper.getValidField("billtype", "drafttypenamebilltf"), BillTradeQueryHelper.getValidField("orginalcurrency", "currencybilltf"), BillTradeQueryHelper.getValidField(SELECT_FIELD_BANK_CURRENCY_NAME, "currencynamebilltf"), BillTradeQueryHelper.getZeroField("amount"), BillTradeQueryHelper.getZeroField("bedevideamount"), BillTradeQueryHelper.getZeroField("devideamount"), BillTradeQueryHelper.getZeroField("oriamountrecbill"), BillTradeQueryHelper.getZeroField("oriamountendorse"), BillTradeQueryHelper.getZeroField("oriamountdiscount"), BillTradeQueryHelper.getZeroField("oriamountcollect"), BillTradeQueryHelper.getZeroField("oriamountpledge"), BillTradeQueryHelper.getZeroField("oriamountrlspledge"), BillTradeQueryHelper.getZeroField("oriamountenterpool"), BillTradeQueryHelper.getZeroField("oriamountoutpool"), BillTradeQueryHelper.getZeroField("amountNs"), BillTradeQueryHelper.getZeroField("amountfendorse"), BillTradeQueryHelper.getZeroField("amountfdiscount"), BillTradeQueryHelper.getZeroField("amountfcollect"), BillTradeQueryHelper.getZeroField("amountfrefund")});
        BillTradeQueryHelper.closeDataSet(billTradeDataSetFinal, recNoStatusDataSetSum);
        recDataSetSum = recDataSetSum.select(new String[]{"company", "companyname", "draftbilltype", "billtype", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currency.name as currencyname", "amount", "bedevideamount", "devideamount", "oriamountrecbill", "oriamountendorse", "oriamountdiscount", "oriamountcollect", "oriamountpledge", "oriamountrlspledge", "oriamountenterpool", "oriamountoutpool", "amountNs", "amountfendorse", "amountfdiscount", "amountfcollect", "amountfrefund"}).orderBy(new String[]{"companyname ASC", "billtype ASC", "currency.name ASC"});
        recDataSetSum = recDataSetSum.addField("bedevideamount + amountfcollect + amountfdiscount + amountfendorse - amountNs - amountfrefund", "oriamountenddate");
        recDataSetSum = recDataSetSum.addField("amount + oriamountrecbill", "oriamountrecbill");
        recDataSetSum = recDataSetSum.addField("oriamountenddate + oriamountcollect + oriamountendorse + oriamountdiscount - oriamountrecbill", "originalamount");
        DataSet ratedataSet = BillTradeQueryHelper.getRate(transQueryParam, filterCurrIdSet, recDataSetSum);
        recDataSetSum = recDataSetSum.join(ratedataSet, JoinType.LEFT).on("orginalcurrency", EXRATE_TABLE_CURRENCY_ID).select(new String[]{"company", "companyname", "billtype", "billtype as billtypeorder", "orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME, "currencyname", BillTradeQueryHelper.getUnitField("oriamountrecbill"), BillTradeQueryHelper.getUnitField("oriamountendorse"), BillTradeQueryHelper.getUnitField("oriamountdiscount"), BillTradeQueryHelper.getUnitField("oriamountcollect"), BillTradeQueryHelper.getUnitField("oriamountpledge"), BillTradeQueryHelper.getUnitField("oriamountrlspledge"), BillTradeQueryHelper.getUnitField("oriamountenterpool"), BillTradeQueryHelper.getUnitField("oriamountoutpool"), BillTradeQueryHelper.getUnitField("oriamountenddate"), BillTradeQueryHelper.getUnitField("originalamount")}, new String[]{EXRATE_TABLE_EXCHG_RATE}).finish();
        BillTradeQueryHelper.closeDataSet(ratedataSet);
        DataSet returnDataSet = recDataSetSum.addField("oriamountrecbill * exchgRate", "repamountrecbill").addField("oriamountendorse * exchgRate", "repamountendorse").addField("oriamountdiscount * exchgRate", "repamountdiscount").addField("oriamountcollect * exchgRate", "repamountcollect").addField("oriamountpledge * exchgRate", "repamountpledge").addField("oriamountrlspledge * exchgRate", "repamountrlspledge").addField("oriamountenterpool * exchgRate", "repamountenterpool").addField("oriamountoutpool * exchgRate", "repamountoutpool").addField("originalamount * exchgRate", "reportamount").addField("oriamountenddate * exchgRate", "repamountenddate");
        returnDataSet = returnDataSet.addField("1", "usuallevel").addField("1", "typesumlevel").addField("1", "companysumlevel").addField("1", "totalsumlevel");
        DataSet billTypeLevelDataSet = returnDataSet.copy().groupBy(new String[]{"company", "companyname", "billtype", "billtypeorder"}).sum("repamountrecbill").sum("repamountendorse").sum("repamountdiscount").sum("repamountcollect").sum("repamountpledge").sum("repamountrlspledge").sum("repamountenterpool").sum("repamountoutpool").sum("reportamount").sum("repamountenddate").finish().addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "companysumlevel").addField("1", "totalsumlevel");
        billTypeLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(billTypeLevelDataSet.copy(), returnDataSet.copy(), false, true, false, false);
        returnDataSet = returnDataSet.union(billTypeLevelDataSet);
        DataSet companyLevelDataSet = returnDataSet.copy().filter("typesumlevel = 2").groupBy(new String[]{"company", "companyname"}).sum("repamountrecbill").sum("repamountendorse").sum("repamountdiscount").sum("repamountcollect").sum("repamountpledge").sum("repamountrlspledge").sum("repamountenterpool").sum("repamountoutpool").sum("reportamount").sum("repamountenddate").finish().addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel").addField("1", "totalsumlevel");
        companyLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(companyLevelDataSet.copy(), returnDataSet.copy(), false, false, true, false);
        returnDataSet = returnDataSet.union(companyLevelDataSet);
        DataSet allSumLevelDataSet = returnDataSet.copy().filter("companysumlevel = 3").groupBy(new String[]{"usuallevel"}).sum("repamountrecbill").sum("repamountendorse").sum("repamountdiscount").sum("repamountcollect").sum("repamountpledge").sum("repamountrlspledge").sum("repamountenterpool").sum("repamountoutpool").sum("reportamount").sum("repamountenddate").finish().addField("4", "totalsumlevel").addField("3", "companysumlevel").addField("2", "typesumlevel").addField("1", "usuallevel");
        billTypeLevelDataSet = BillTradeQueryHelper.addFieldSameEmptyFromTarget(allSumLevelDataSet.copy(), returnDataSet.copy(), true, false, false, false);
        returnDataSet = returnDataSet.union(billTypeLevelDataSet);
        returnDataSet = returnDataSet.addField("companyname", "companynameorder").addField(filter_reportcurrency.getPkValue().toString(), SELECT_FIELD_BANK_REPORT_CURRENCY).addField("'" + filter_reportcurrency.getString("name") + "'", "reportcurrencyname");
        returnDataSet = returnDataSet.select("company,companyname,billtype,orginalcurrency,currency.name,currencyname,reportcurrency,reportcurrencyname,oriamountrecbill,oriamountendorse,oriamountdiscount,oriamountcollect,oriamountpledge,oriamountrlspledge,oriamountenterpool,oriamountoutpool,oriamountenddate,originalamount,repamountrecbill,repamountendorse,repamountdiscount,companynameorder,billtypeorder,repamountcollect,repamountpledge,repamountrlspledge,repamountenterpool,repamountoutpool,reportamount,repamountenddate,usuallevel,companysumlevel,typesumlevel,totalsumlevel").orderBy(new String[]{"totalsumlevel", "companynameorder ASC", "companysumlevel", "billtypeorder ASC", "typesumlevel", "currency.name ASC"});
        return returnDataSet;
    }

    public static String getUnitField(String fieldA) {
        String caseStr = fieldA + radixStr + " as " + fieldA;
        return caseStr;
    }

    public static String getValidField(String fieldA, String fieldB) {
        String caseStr = "case when " + fieldA + " is null then + " + fieldB + " else " + fieldA + " end as " + fieldA;
        return caseStr;
    }

    public static String getZeroField(String fieldA) {
        String caseStr = "case when " + fieldA + " is null then 0  else " + fieldA + " end as " + fieldA;
        return caseStr;
    }

    private static DataSet addFieldSameEmptyFromTarget(DataSet sumDataSet, DataSet dataSet, boolean isTotal, boolean isType, boolean isCompany, boolean ispool) {
        Field[] fields = dataSet.getRowMeta().getFields();
        Field[] sumFields = sumDataSet.getRowMeta().getFields();
        Set fieldNameSet = Arrays.stream(sumFields).map(Field::getName).collect(Collectors.toSet());
        ArrayList<String> stringList = new ArrayList<String>(fields.length);
        List<Field> list = Arrays.asList(fields);
        for (Field field : list) {
            String name = field.getName();
            if (isCompany && "companyname".equals(name)) {
                name = BillTradeQueryHelper.getTotalName(name, isTotal, isType, ispool);
            } else if (isType && "billtype".equalsIgnoreCase(name)) {
                name = BillTradeQueryHelper.getTotalName(name, isTotal, isType, ispool);
            } else if (isTotal && "companyname".equals(name)) {
                name = BillTradeQueryHelper.getTotalName(name, isTotal, isType, ispool);
            } else if (ispool && "billpoolname".equals(name)) {
                name = BillTradeQueryHelper.getTotalName(name, isTotal, isType, ispool);
            } else if (!fieldNameSet.contains(name)) {
                name = "NULL AS " + name;
            }
            stringList.add(name);
        }
        return sumDataSet.select(String.join((CharSequence)COLUMN_SEPARATOR, stringList));
    }

    private static String getTotalName(String name, boolean isTotal, boolean isType, boolean ispool) {
        logger.info("getTotalName is new");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            if (isTotal) {
                String formatStr = String.format(ResManager.loadKDString((String)"'\u603b\u8ba1' as %s", (String)"BillTradeQueryHelper_3", (String)"tmc-cdm-report", (Object[])new Object[0]), name);
                logger.info("formatStr is:" + formatStr);
                if (formatStr.startsWith("Total as")) {
                    formatStr = formatStr.replace("Total as", "'Total' as");
                } else if (formatStr.startsWith("Total' as")) {
                    formatStr = formatStr.replace("Total' as", "'Total' as");
                }
                return formatStr;
            }
            if (isType) {
                return String.format(ResManager.loadKDString((String)"CONCAT( %1$s ,'\u7968\u636e\u7c7b\u578b\u5c0f\u8ba1') as %2$s", (String)"BillTradeQueryHelper_4", (String)"tmc-cdm-report", (Object[])new Object[0]), name, name);
            }
            if (ispool) {
                return String.format(ResManager.loadKDString((String)"CONCAT(%1$s ,'\u7968\u636e\u6c60\u5c0f\u8ba1') as %2$s", (String)"BillTradeQueryHelper_6", (String)"tmc-cdm-report", (Object[])new Object[0]), name, name);
            }
            return String.format(ResManager.loadKDString((String)"CONCAT( %1$s ,'\u8d44\u91d1\u7ec4\u7ec7\u5c0f\u8ba1') as %2$s", (String)"BillTradeQueryHelper_5", (String)"tmc-cdm-report", (Object[])new Object[0]), name, name);
        }
        return "A";
    }

    private static QFilter[] getQfilter(List<QFilter> qFilters) {
        ArrayList<QFilter> listArr = new ArrayList<QFilter>();
        for (QFilter qFilter : qFilters) {
            if (null == qFilter) continue;
            listArr.add(qFilter);
        }
        QFilter[] qFiltersArr = new QFilter[listArr.size()];
        for (int i = 0; i < listArr.size(); ++i) {
            qFiltersArr[i] = (QFilter)listArr.get(i);
        }
        return qFiltersArr;
    }

    private static DataSet getRate(Map<String, Object> transQueryParam, Set<Long> filterCurrIdSet, DataSet returnDataSet) {
        DataSet ratedataSet;
        if (filterCurrIdSet.size() > 0) {
            ratedataSet = BillTradeQueryHelper.getExratetableDataSet(transQueryParam, null);
        } else {
            DataSet currDataSet = returnDataSet.copy().select(new String[]{"orginalcurrency", SELECT_FIELD_BANK_CURRENCY_NAME}).distinct();
            Iterator it = currDataSet.iterator();
            HashMap<Long, String> currAndNameMap = new HashMap<Long, String>();
            while (it.hasNext()) {
                Row data = (Row)it.next();
                Long currId = data.getLong("orginalcurrency");
                String name = data.getString(SELECT_FIELD_BANK_CURRENCY_NAME);
                if (currAndNameMap.containsKey(currId)) continue;
                currAndNameMap.put(currId, name);
            }
            ratedataSet = BillTradeQueryHelper.getExratetableDataSet(transQueryParam, currAndNameMap);
        }
        return ratedataSet;
    }

    public static Date parseCurrDate() {
        Date currDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currDateStr = sdf.format(new Date());
        try {
            currDate = sdf.parse(currDateStr);
        }
        catch (ParseException e) {
            logger.error("", (Throwable)e);
        }
        return currDate;
    }

    private static Date parseDate(Date date, boolean islast) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (!islast) {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        } else {
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
        }
        date = c.getTime();
        return date;
    }

    private static DataSet getExratetableDataSet(Map<String, Object> transQueryParam, Map<Long, String> currAndNameMap) {
        Date filter_enddate = (Date)transQueryParam.get("filter_enddate");
        DynamicObject filter_exratetable = (DynamicObject)transQueryParam.get("filter_exratetable");
        DynamicObject filter_reportcurrency = (DynamicObject)transQueryParam.get("filter_statcurrency");
        DynamicObjectCollection filter_currency = (DynamicObjectCollection)transQueryParam.get("filter_currency");
        Long exrateTableId = Objects.isNull(filter_exratetable) ? Long.valueOf(0L) : (Long)filter_exratetable.getPkValue();
        Long reportCurrencyId = Objects.isNull(filter_reportcurrency) ? Long.valueOf(0L) : (Long)filter_reportcurrency.getPkValue();
        logger.info("\u6c47\u7387\u8868id:{},\u62a5\u544a\u5e01id:{}", (Object)exrateTableId, (Object)reportCurrencyId);
        Set<Object> filterCurrIdSet = new HashSet();
        if (null == currAndNameMap) {
            currAndNameMap = filter_currency.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
        }
        filterCurrIdSet = currAndNameMap.keySet();
        HashSet<Long> currencySet = new HashSet<Long>(64);
        ArrayList<Object[]> cnyList = new ArrayList<Object[]>(filterCurrIdSet.size());
        for (Long l : filterCurrIdSet) {
            if (!currencySet.add(l)) continue;
            logger.info("\u6839\u636e\u6e90\u5e01\u79cdID:{}\u3001\u76ee\u6807\u5e01\u79cdID:{}\u3001\u7ec4\u7ec7ID:{}", new Object[]{l, reportCurrencyId, ""});
            BigDecimal rate = BillTradeQueryHelper.getExchangeRateByTable(l, reportCurrencyId, 0L, filter_enddate, exrateTableId);
            logger.info("\u6839\u636e\u6e90\u5e01\u79cdID:{}\u3001\u76ee\u6807\u5e01\u79cdID:{}\u3001\u7ec4\u7ec7ID:{}\u3001\u6c47\u7387\u8868\u83b7\u53d6\u6c47\u7387\u503c:{}", new Object[]{l, reportCurrencyId, "", rate});
            Object[] obj = null;
            BigDecimal zero = new BigDecimal(BigInteger.ZERO);
            obj = Objects.isNull(rate) ? new Object[]{l, zero} : new Object[]{l, rate.setScale(reportAmtprecision, 4)};
            cnyList.add(obj);
        }
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field(EXRATE_TABLE_CURRENCY_ID, (DataType)DataType.LongType));
        field.add(new Field(EXRATE_TABLE_EXCHG_RATE, (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        logger.info("\u6784\u5efa\u6c47\u7387\u8868DataSet");
        Algo algo = Algo.create((String)"");
        DataSet exchgRateDataSet = algo.createDataSet(cnyList, rowMeta);
        exchgRateDataSet = exchgRateDataSet.addField(reportCurrencyId.toString(), SELECT_FIELD_BANK_REPORT_CURRENCY);
        return exchgRateDataSet;
    }

    public static BigDecimal getExchangeRateByTable(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date exratedate, Long exchangeRateTableId) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return exchangeRate;
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exratedate);
        return exchangeRate;
    }

    public static DynamicObjectCollection beforeBindData() {
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg(RequestContext.get().getCurrUserId(), "cdm_report_billstrade", "47150e89000000ac");
        return orgList;
    }

    public static DynamicObject getCasInitInfo(long orgId) {
        return SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
    }

    public static CurrencyUnit getCurrencyUnit(String unit) {
        CurrencyUnit currencyUnit = CURRENCY_UNIT_MAP.get(unit);
        if (Objects.isNull((Object)currencyUnit)) {
            currencyUnit = CurrencyUnit.ORIGINAL;
        }
        return currencyUnit;
    }

    private static void closeDataSet(DataSet ... dataSets) {
        if (Objects.isNull(dataSets)) {
            return;
        }
        for (DataSet dataSet : dataSets) {
            if (Objects.isNull(dataSet)) continue;
            dataSet.close();
        }
    }

    public static enum CurrencyUnit {
        BILLION("1000000000", "1000000000", new MultiLangEnumBridge("\u4ebf", "BillTradeQueryHelper_8", "tmc-cdm-report")),
        MILLION("1000000", "1000000", new MultiLangEnumBridge("\u767e\u4e07", "BillTradeQueryHelper_9", "tmc-cdm-report")),
        TENTHOUSAND("10000", "10000", new MultiLangEnumBridge("\u4e07", "BillTradeQueryHelper_10", "tmc-cdm-report")),
        THOUSAND("1000", "1000", new MultiLangEnumBridge("\u5343", "BillTradeQueryHelper_11", "tmc-cdm-report")),
        ORIGINAL("1", "1", new MultiLangEnumBridge("\u539f\u5355\u4f4d", "BillTradeQueryHelper_12", "tmc-cdm-report"));

        private String value;
        private String radix;
        private MultiLangEnumBridge name;

        private CurrencyUnit(String value, String radix, MultiLangEnumBridge name) {
            this.value = value;
            this.radix = radix;
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public String getRadix() {
            return this.radix;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }
    }
}

