/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RptFilterParamHelper {
    public static QFilter initOrgFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "org.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_org")) {
            property = propertyMapping.get("filter_org");
        }
        if (!EmptyUtil.isEmpty((Object)paramMap.get("orgids"))) {
            return new QFilter(property, "in", paramMap.get("orgids"));
        }
        if (!EmptyUtil.isEmpty((Object)paramMap.get("filter_company_ID"))) {
            return new QFilter(property, "in", paramMap.get("filter_company_ID"));
        }
        return new QFilter("'1'", "=", (Object)"1");
    }

    public static QFilter initBankFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "bank.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_bank")) {
            property = propertyMapping.get("filter_bank");
        }
        return RptFilterParamHelper.f7MultiSelectFilter(paramMap, "filter_bank", property);
    }

    public static QFilter initCurrencyFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "currency.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_currencies")) {
            property = propertyMapping.get("filter_currencies");
        }
        return RptFilterParamHelper.f7MultiSelectFilter(paramMap, "filter_currencies", property);
    }

    public static QFilter initBillTypeFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "billtype.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_billtypebase")) {
            property = propertyMapping.get("filter_billtypebase");
        }
        return RptFilterParamHelper.f7MultiSelectFilter(paramMap, "filter_billtypebase", property);
    }

    public static QFilter initAccountBankFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "accountbank.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_accountbank")) {
            property = propertyMapping.get("filter_accountbank");
        }
        return RptFilterParamHelper.f7MultiSelectFilter(paramMap, "filter_accountbank", property);
    }

    public static QFilter initBillMediumFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "billtype.billmedium";
        if (propertyMapping != null && propertyMapping.containsKey("filter_billmedium")) {
            property = propertyMapping.get("filter_billmedium");
        }
        return RptFilterParamHelper.selectFilter(paramMap, "filter_billmedium", property);
    }

    public static QFilter f7MultiSelectFilter(Map<String, Object> paramMap, String filterKey, String property) {
        QFilter filter = null;
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filterKey))) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)paramMap.get(filterKey);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject currency : dynamicObjects) {
                idList.add(currency.getLong("id"));
            }
            if (!idList.isEmpty()) {
                filter = new QFilter(property, "in", idList);
            }
        }
        return filter;
    }

    public static QFilter f7MultiSelectNameFilter(Map<String, Object> paramMap, String filterKey, String property, String entityName) {
        QFilter filter = null;
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filterKey))) {
            DynamicObject[] entitys;
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)paramMap.get(filterKey);
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject dynamic : dynamicObjects) {
                idList.add(dynamic.getLong("id"));
            }
            ArrayList<String> nameList = new ArrayList<String>(8);
            for (DynamicObject dynamicObject : entitys = BusinessDataServiceHelper.load((String)entityName, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) {
                nameList.add(dynamicObject.getString("name"));
            }
            if (!EmptyUtil.isEmpty(nameList)) {
                filter = new QFilter(property, "in", nameList);
            }
        }
        return filter;
    }

    public static QFilter selectFilter(Map<String, Object> paramMap, String filterKey, String property) {
        String value;
        QFilter filter = null;
        if (!EmptyUtil.isEmpty((Object)paramMap.get(filterKey)) && EmptyUtil.isNoEmpty((String)(value = (String)paramMap.get(filterKey))) && !"all".equals(value)) {
            filter = new QFilter(property, "=", (Object)value);
        }
        return filter;
    }

    public static QFilter initBillAccepterFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String datatype = (String)paramMap.get("filter_datatype");
        QFilter filter = null;
        if (EmptyUtil.isNoEmpty((String)datatype)) {
            if (StringUtils.equals((CharSequence)datatype, (CharSequence)"A")) {
                return RptFilterParamHelper.accepterBankFilter(paramMap, propertyMapping);
            }
            return RptFilterParamHelper.accepterFiFilter(paramMap, propertyMapping);
        }
        return filter;
    }

    private static QFilter accepterFiFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String acceptertype = (String)paramMap.get("filter_acceptertyp_fi");
        QFilter filter = null;
        if (EmptyUtil.isNoEmpty((String)acceptertype) && !StringUtils.equals((CharSequence)acceptertype, (CharSequence)"all")) {
            if (StringUtils.equals((CharSequence)acceptertype, (CharSequence)"A")) {
                return RptFilterParamHelper.f7MultiSelectFilter(paramMap, "filter_accepter_fi", "accepterfinorg.id");
            }
            String accepterName = (String)paramMap.get("filter_acceptername");
            if (!EmptyUtil.isEmpty((String)accepterName)) {
                String[] accepterNames = accepterName.split(",");
                ArrayList<String> acceptNameList = new ArrayList<String>(8);
                for (String acceptName : accepterNames) {
                    acceptNameList.add(acceptName);
                }
                if (!acceptNameList.isEmpty()) {
                    filter = new QFilter("acceptername", "in", acceptNameList);
                }
                return filter;
            }
        }
        return filter;
    }

    private static QFilter accepterBankFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String acceptertype = (String)paramMap.get("filter_acceptertyp_bank");
        QFilter filter = null;
        if (EmptyUtil.isNoEmpty((String)acceptertype) && !StringUtils.equals((CharSequence)acceptertype, (CharSequence)"all")) {
            if (StringUtils.equals((CharSequence)acceptertype, (CharSequence)"A")) {
                return RptFilterParamHelper.f7MultiSelectNameFilter(paramMap, "filter_accepter_bank", "acceptername", "bd_bebank");
            }
            String accepterName = (String)paramMap.get("filter_acceptername");
            if (!EmptyUtil.isEmpty((String)accepterName)) {
                String[] accepterNames = accepterName.split(",");
                ArrayList<String> acceptNameList = new ArrayList<String>(8);
                for (String acceptName : accepterNames) {
                    acceptNameList.add(acceptName);
                }
                if (!acceptNameList.isEmpty()) {
                    filter = new QFilter("acceptername", "in", acceptNameList);
                }
                return filter;
            }
        }
        return filter;
    }

    public static QFilter initDateRange(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        String property = "bizdate";
        if (propertyMapping != null && propertyMapping.containsKey("filter_dateranges")) {
            property = propertyMapping.get("filter_dateranges");
        }
        QFilter filter = null;
        String dateRange = String.valueOf(paramMap.get("filter_dateranges"));
        if (!EmptyUtil.isEmpty((String)dateRange)) {
            filter = RptDateRangeEnum.CUSTOM.getValue().equals(dateRange) ? new QFilter(property, ">=", paramMap.get("filter_dateranges_startdate")).and(new QFilter(property, "<=", paramMap.get("filter_dateranges_enddate"))) : new QFilter(property, ">=", (Object)RptFilterParamHelper.explainStartDate(dateRange)).and(new QFilter(property, "<=", (Object)RptFilterParamHelper.explainEndDate(dateRange)));
        }
        return filter;
    }

    public static QFilter initWarnDateRange(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        QFilter filter = null;
        Date expiredDate = (Date)paramMap.get("filter_expireddate");
        int warndays = (Integer)paramMap.get("filter_warndays");
        if (!EmptyUtil.isEmpty((Object)expiredDate)) {
            filter = new QFilter("draftbillexpiredate", ">=", (Object)DateUtils.getNextDay((Date)expiredDate, (int)(-warndays)));
            filter.and(new QFilter("draftbillexpiredate", "<=", (Object)expiredDate));
        }
        return filter;
    }

    private static Date explainStartDate(String dateStr) {
        Date startDate = null;
        Timestamp currentTime = DateUtils.getCurrentTime();
        switch (dateStr) {
            case "thismonth": {
                startDate = DateUtils.getMinMonthDate((Date)new Date());
                break;
            }
            case "thisquarter": {
                startDate = DateUtils.getFirstSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "sixmonth": {
                startDate = DateUtils.getLastMonth((Date)currentTime, (int)6);
                break;
            }
            case "oneyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)1);
                break;
            }
            case "twoyear": {
                startDate = DateUtils.getLastYear((Date)currentTime, (int)2);
                break;
            }
        }
        return startDate;
    }

    private static Date explainEndDate(String dateStr) {
        Date endDate = new Date();
        switch (dateStr) {
            case "thismonth": {
                endDate = DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "thisquarter": {
                endDate = DateUtils.getLastSeasonDate((Date)DateUtils.getCurrentDate());
                break;
            }
        }
        return endDate;
    }

    public static QFilter initFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping, List<Long> orgIds) {
        QFilter billMediumFilter;
        QFilter dateRangeFilter;
        QFilter accountBankFilter;
        QFilter billTypeFilter;
        QFilter currencyFilter;
        QFilter filter = new QFilter("org.id", "in", orgIds);
        QFilter bankFilter = RptFilterParamHelper.initBankFilter(paramMap, propertyMapping);
        if (bankFilter != null) {
            filter = filter.and(bankFilter);
        }
        if ((currencyFilter = RptFilterParamHelper.initCurrencyFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(currencyFilter);
        }
        if ((billTypeFilter = RptFilterParamHelper.initBillTypeFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billTypeFilter);
        }
        if ((accountBankFilter = RptFilterParamHelper.initAccountBankFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(accountBankFilter);
        }
        if ((dateRangeFilter = RptFilterParamHelper.initDateRange(paramMap, propertyMapping)) != null) {
            filter = filter.and(dateRangeFilter);
        }
        if ((billMediumFilter = RptFilterParamHelper.initBillMediumFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billMediumFilter);
        }
        return filter;
    }
}

