/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillEndorseReportViewPlugin
extends AbstractReportFormPlugin {
    private static String SUM_METHOD_ORG = "1";
    private static final String SYSTEM_TYPE = "tmc-cdm-report";

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        String sumMethod = (String)this.getModel().getValue("summethod");
        event.setTreeReportList(true);
        if (SUM_METHOD_ORG.equals(sumMethod)) {
            event.setTreeExpandColId("companyname");
        } else {
            event.setTreeExpandColId("inendorser");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.changeEndorser();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "endorsertype": {
                this.changeEndorser();
                break;
            }
            case "filter_dateranges": {
                DateRangeEdit daterange = (DateRangeEdit)this.getControl("daterange");
                String value = (String)this.getModel().getValue("filter_dateranges");
                if (!"custom".equals(value)) {
                    this.getModel().setValue("filter_dateranges_startdate", null);
                    this.getModel().setValue("filter_dateranges_enddate", null);
                    daterange.setMustInput(false);
                    break;
                }
                daterange.setMustInput(true);
                break;
            }
        }
    }

    private void changeEndorser() {
        String endorserType = this.getModel().getDataEntity().getString("endorsertype");
        TextEdit textEdit = (TextEdit)this.getControl("beendorsertext");
        ItemClassEdit itemClassEdit = (ItemClassEdit)this.getControl("beendorser");
        this.getModel().setValue("beendorsertext", (Object)"");
        this.getModel().setValue("beendorser", (Object)"");
        if (StringUtils.isEmpty((CharSequence)endorserType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"beendorsertext"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"beendorser"});
            this.getModel().setValue("payeetype", (Object)"");
            textEdit.setMustInput(false);
            itemClassEdit.setMustInput(false);
            return;
        }
        if ("others".equals(endorserType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"beendorsertext"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"beendorser"});
            this.getModel().setValue("payeetype", (Object)"");
            textEdit.setMustInput(true);
            itemClassEdit.setMustInput(false);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"beendorsertext"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"beendorser"});
        this.getModel().setValue("payeetype", (Object)endorserType);
        textEdit.setMustInput(false);
        itemClassEdit.setMustInput(true);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.checkFilter(queryParam);
    }

    private Boolean checkFilter(ReportQueryParam queryParam) {
        String beEndorserText;
        String endorserType = queryParam.getFilter().getString("endorsertype");
        if (StringUtils.isNotEmpty((CharSequence)endorserType) && "others".equals(endorserType) && StringUtils.isEmpty((CharSequence)(beEndorserText = queryParam.getFilter().getString("beendorsertext")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillEndorseReportViewPlugin1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        String beEndorser = queryParam.getFilter().getString("beendorser");
        if (StringUtils.isNotEmpty((CharSequence)endorserType) && !"others".equals(endorserType) && StringUtils.isEmpty((CharSequence)beEndorser)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillEndorseReportViewPlugin1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        String dateRange = (String)this.getModel().getValue("filter_dateranges");
        if (RptDateRangeEnum.CUSTOM.getValue().equals(dateRange)) {
            Date startDate = (Date)this.getModel().getValue("filter_dateranges_startdate");
            Date endDate = (Date)this.getModel().getValue("filter_dateranges_enddate");
            if (EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillChequeViewPlugin0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (startDate.after(endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"BillChequeViewPlugin1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

