/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillSumReportListViewPlugin
extends AbstractReportFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.defaultOrg();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrgPropMustInput();
    }

    private void setOrgPropMustInput() {
        boolean isMustInput = ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"));
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"filter_org"});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object exRateTable;
            Object org;
            Object sumType = filterInfo.getValue("filter_sumtype");
            if (sumType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u603b\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayableBillSumReportListViewPlugin_0", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay) && null == (org = filterInfo.getValue("filter_org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillSumReportListViewPlugin_2", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object acceptorType = filterInfo.getValue("filter_acceptortype");
            if (acceptorType != null) {
                Object acceptorText;
                if ("finorg".equals(String.valueOf(acceptorType))) {
                    Object acceptorOrg = filterInfo.getValue("filter_acceptororg");
                    if (acceptorOrg == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u627f\u5151\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayableBillSumReportListViewPlugin_4", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                        return false;
                    }
                } else if ("nonfinorginfo".equals(String.valueOf(acceptorType)) && ObjectUtils.isEmpty((Object)(acceptorText = filterInfo.getValue("filter_acceptortext")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u627f\u5151\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayableBillSumReportListViewPlugin_5", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    return false;
                }
            }
            if ((exRateTable = filterInfo.getValue("filter_exratetable")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillSumReportListViewPlugin_7", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object reportCurrency = this.getModel().getValue("filter_statcurrency");
            if (reportCurrency == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayableBillSumReportListViewPlugin_8", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            String dateRanges = (String)filterInfo.getValue("filter_dateranges");
            Object queryDateStart = filterInfo.getValue("filter_querydate_start");
            Object queryDateEnd = filterInfo.getValue("filter_querydate_end");
            if ("custom".equals(dateRanges) && (queryDateStart == null || queryDateEnd == null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayableBillSumReportListViewPlugin_9", (String)"tmc-cdm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        queryParam.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        switch (property) {
            case "filter_acceptortype": {
                this.getModel().setValue("filter_acceptororg", null);
                this.getModel().setValue("filter_acceptortext", null);
                if ("finorg".equals(newValue)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"filter_acceptororg"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"filter_acceptortext"});
                    break;
                }
                if ("nonfinorginfo".equals(newValue)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"filter_acceptororg"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"filter_acceptortext"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"filter_acceptororg"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filter_acceptortext"});
                break;
            }
            case "filter_dateranges": {
                if ("custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"filter_querydate"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"filter_querydate"});
                this.getModel().setValue("filter_querydate_start", null);
                this.getModel().setValue("filter_querydate_end", null);
                break;
            }
            case "filter_queryway": {
                this.setOrgPropMustInput();
                break;
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filter = event.getQueryParam().getFilter();
        String sumType = filter.getString("filter_sumtype");
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)column;
            String fieldKey = reportColumn.getFieldKey();
            if ("company".equals(sumType) && ("acceptername".equals(fieldKey) || "paybilltype".equals(fieldKey))) {
                reportColumn.setHide(true);
                continue;
            }
            if ("acceptername".equals(sumType) && ("company".equals(fieldKey) || "paybilltype".equals(fieldKey))) {
                reportColumn.setHide(true);
                continue;
            }
            if ("currency".equals(sumType) && ("company".equals(fieldKey) || "acceptername".equals(fieldKey) || "paybilltype".equals(fieldKey))) {
                reportColumn.setHide(true);
                continue;
            }
            if (!"paybilltype".equals(sumType) || !"company".equals(fieldKey) && !"acceptername".equals(fieldKey)) continue;
            reportColumn.setHide(true);
        }
    }

    private void defaultOrg() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        DynamicObjectCollection orgDy = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (authOrgIds != null && !authOrgIds.isEmpty() && orgDy.size() == 0) {
            DynamicObjectCollection coll;
            DynamicObjectCollection dynamicObjects1;
            DynamicObject dynamicObjects;
            if (authOrgIds.contains(org)) {
                dynamicObjects = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                dynamicObjects1 = new DynamicObjectCollection();
                dynamicObjects1.add((Object)dynamicObjects);
                this.getModel().setValue("filter_org", (Object)dynamicObjects1);
            } else {
                dynamicObjects = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObjects)) {
                    dynamicObjects1 = new DynamicObjectCollection();
                    dynamicObjects1.add((Object)dynamicObjects);
                    this.getModel().setValue("filter_org", (Object)dynamicObjects1);
                }
            }
            if (dynamicObjects != null && (coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"exratetable,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", dynamicObjects.getPkValue())}, null)) != null && !coll.isEmpty()) {
                this.getModel().setValue("filter_statcurrency", (Object)((DynamicObject)coll.get(0)).getLong("standardcurrency"));
                this.getModel().setValue("filter_exratetable", (Object)((DynamicObject)coll.get(0)).getLong("exratetable"));
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_acceptororg"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_acceptortext"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"filter_querydate"});
    }
}

