/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.cdm.report.helper.RptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class BillChequeDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(3);
    private static final Map<String, String> PROPERTY_MAPPING_MAP = new HashMap<String, String>(1);
    public static final String SELECT = "id,org.name as company,org.id as companyid ,batchno,billno,chequestatus,purchdate,billtype.name as billtype,bank.name as bank,accountbank.bankaccountnumber as bankaccountnumber,currency,relateamount,amount,(case when chequestatus = '0' then 1 else  0 end) as empty,(case when chequestatus = '2' then 1 else  0 end) as fill,(case when chequestatus = '3' then 1 else  0 end) as invalid";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam param) {
        Map commFilter = param.getFilter().getCommFilter();
        Map<String, Object> paramMap = ReportDataHelper.transQueryParam(param);
        List orgIds = this.getQueryOrgIds(param);
        QFilter filter = RptFilterParamHelper.initFilter(paramMap, PROPERTY_MAPPING_MAP, orgIds);
        boolean isEmpty = (Boolean)paramMap.get("filter_isempty");
        if (isEmpty) {
            filter.and(new QFilter("chequestatus", "=", (Object)"0"));
        }
        ArrayList<Object> filters = new ArrayList<Object>(commFilter.size());
        for (Map.Entry entry : commFilter.entrySet()) {
            filters.add(entry.getValue());
        }
        filters.add(filter);
        dataSet = QueryServiceHelper.queryDataSet((String)"cdm_cheque_book", (String)"cdm_cheque_book", (String)SELECT, (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet emptyDataSet = dataSet.copy().filter("chequestatus = '0'").select("id,batchno as batchno1,billno");
        GroupbyDataSet groupby = emptyDataSet.groupBy(new String[]{"batchno1"});
        groupby.minP("id", "billno", "billno_min");
        groupby.maxP("id", "billno", "billno_max");
        emptyDataSet = groupby.finish();
        emptyDataSet = emptyDataSet.addField("case when billno_min = billno_max then billno_min else concat(billno_min,'-',billno_max) end", "billno_start");
        String[] leftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] rightSelector = (String[])Arrays.stream(emptyDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.leftJoin(emptyDataSet).on("batchno", "batchno1").select(leftSelector, rightSelector).finish();
        String calUnits = "1";
        if (!EmptyUtil.isEmpty((Object)paramMap.get("filter_currencyunit"))) {
            calUnits = (String)paramMap.get("filter_currencyunit");
        }
        dataSet = this.getSumDataSet(dataSet, calUnits);
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        dataSet = ReportDataHelper.exchangeRate(dataSet, filterCurrencies, reportCurrency, (DynamicObject)paramMap.get("filter_exratetable"));
        dataSet = dataSet.addField("relateamount_sum * excval", "report_amount_sum");
        if ("org".equals(paramMap.get("filter_queryway"))) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cdm", (String)"cdm_report_cheque_sum", (String)"47150e89000000ac");
            dataSet = this.getTreeDataSet(dataSet, null, orgIdList);
            dataSet = dataSet.orderBy(new String[]{"longnumber", "purchdate desc"});
        } else if ("orgview".equals(paramMap.get("filter_queryway"))) {
            Long companyViewId = (Long)paramMap.get("companyviewnum");
            dataSet = this.getTreeDataSet(dataSet, companyViewId, null);
            dataSet = dataSet.orderBy(new String[]{"longnumber", "purchdate desc"});
        }
        return dataSet.addField(String.valueOf(reportCurrency.getPkValue()), "report_currency");
    }

    private DataSet getSumDataSet(DataSet bizDs, String calUnits) {
        StringBuilder group = new StringBuilder("company,companyid ,batchno,purchdate,billtype,bank,bankaccountnumber,currency,amount,billno_start");
        ArrayList<String> bankAccountGroup = new ArrayList<String>();
        bankAccountGroup.addAll(Arrays.asList(group.toString().split(",")));
        GroupbyDataSet groupby = bizDs.groupBy(bankAccountGroup.toArray(new String[0]));
        groupby.sum("relateamount /" + calUnits, "relateamount_sum");
        groupby.sum("empty", "empty_sum");
        groupby.sum("fill", "fill_sum");
        groupby.sum("invalid", "invalid_sum");
        return groupby.finish();
    }

    private DataSet getTreeDataSet(DataSet bizDs, Long companyViewId, List<Long> orgIdList) {
        Map<String, String> vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
        ArrayList<String> statList = new ArrayList<String>(Arrays.asList("amount", "report_amount_sum", "empty_sum", "fill_sum", "invalid_sum"));
        Map<String, String> vbizBaseMap = ReportDataHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
        bizDs = ReportDataHelper.getBizDsWithOrgTree(bizDs, "rowid", "companyid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
        bizDs = ReportDataHelper.getSumDataSet(bizDs, statList, true, (AbstractTmcListDataPlugin)this);
        return bizDs;
    }

    static {
        V_TREE_BASE_COMPANY_MAP.put("company", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("companyid", "rowid");
        PROPERTY_MAPPING_MAP.put("filter_dateranges", "purchdate");
    }
}

