/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillEndorseTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.report.helper.ReportDataHelper;
import kd.tmc.cdm.report.helper.RptFilterParamHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class BillEndorseDetailDataListPlugin
extends AbstractTmcListDataPlugin {
    private static final String SYSTEM_TYPE = "tmc-cdm-report";
    private static final Map<String, String> PROPERTY_MAPPING_MAP = new HashMap<String, String>(4);

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        Map<String, Object> paramMap = ReportDataHelper.transQueryParam(param);
        QFilter filter = BillEndorseDetailDataListPlugin.initEndorseDetailFilter(paramMap, PROPERTY_MAPPING_MAP);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        return this.groupEndorseDetail(paramMap, filters);
    }

    public static QFilter initEndorseDetailFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        boolean includeExpired;
        QFilter billTypeFilter;
        QFilter filter = new QFilter("'1'", "=", (Object)"1");
        String multiSettlementtype = (String)paramMap.get("filter_settlementtype");
        if (!EmptyUtil.isEmpty((String)multiSettlementtype)) {
            multiSettlementtype = multiSettlementtype.substring(1, multiSettlementtype.length() - 1);
            QFilter settlementtypeFilter = new QFilter("draftbilltype.settlementtype", "in", (Object)multiSettlementtype.split(","));
            filter = filter.and(settlementtypeFilter);
        }
        if ((billTypeFilter = RptFilterParamHelper.initBillTypeFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billTypeFilter);
        }
        if (!(includeExpired = ((Boolean)paramMap.get("filter_expiredbills")).booleanValue())) {
            QFilter expireDateFilter = new QFilter("draftbillexpiredate", ">", (Object)new Date());
            filter = filter.and(expireDateFilter);
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        filter = filter.and(billstatusFilter);
        QFilter draftbilltranstatusFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        filter = filter.and(draftbilltranstatusFilter);
        QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "!=", (Object)"splited");
        filter = filter.and(draftBillStatusFilter);
        String draftbillno = (String)paramMap.get("filter_draftbillno");
        if (!EmptyUtil.isEmpty((String)draftbillno)) {
            String[] billNos = draftbillno.split(" ");
            QFilter draftbillnoFilter = new QFilter("draftbillno", "in", (Object)billNos);
            filter = filter.and(draftbillnoFilter);
        }
        Date filterStartDate = (Date)paramMap.get("filter_querydate_start");
        Date filterEndDate = (Date)paramMap.get("filter_querydate_end");
        if (!ObjectUtils.isEmpty((Object)filterStartDate) && !ObjectUtils.isEmpty((Object)filterEndDate)) {
            filterStartDate = DateUtils.getDataFormat((Date)filterStartDate, (boolean)true);
            filterEndDate = DateUtils.getDataFormat((Date)filterEndDate, (boolean)false);
        }
        QFilter startDateQFilter = new QFilter("bizdate", ">=", (Object)filterStartDate);
        QFilter endDateQFilter = new QFilter("bizdate", "<=", (Object)filterEndDate);
        filter.and(startDateQFilter).and(endDateQFilter);
        return filter;
    }

    private DataSet groupEndorseDetail(Map<String, Object> paramMap, List<QFilter> filters) {
        DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)"cdm_receivablebill", (String)"cdm_receivablebill", (String)"id,billno,company.id as companyid,company.name as company,draftbillno,subbillrange,standardbillamount,drawername,receivername,acceptername,draftbilltype.settlementtype as settlementtype,amount,supperbillamount,currency.id as currency", (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet receivableDataSetGroup = baseDataSet.groupBy(new String[]{"draftbillno", "subbillrange", "drawername", "receivername", "acceptername", "settlementtype", "amount", "supperbillamount", "currency"});
        baseDataSet = receivableDataSetGroup.sum("standardbillamount").finish();
        DataSet payableDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)"id,billno,company.id as companyid,company.name as company,draftbillno as draftbillno,subbillrange as subbillrange,standardbillamount,drawername,receivername,acceptername,draftbilltype.settlementtype as settlementtype,amount,supperbillamount,currency.id as currency", (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet payableDataSetGroup = payableDataSet.groupBy(new String[]{"draftbillno", "subbillrange", "drawername", "receivername", "acceptername", "settlementtype", "amount", "supperbillamount", "currency"});
        payableDataSet = payableDataSetGroup.sum("standardbillamount").finish();
        baseDataSet = baseDataSet.union(payableDataSet);
        GroupbyDataSet baseDataSetGroup = baseDataSet.groupBy(new String[]{"draftbillno", "subbillrange", "drawername", "receivername", "acceptername", "settlementtype", "amount", "supperbillamount", "currency"});
        baseDataSet = baseDataSetGroup.sum("standardbillamount").finish();
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("draftbillno", (DataType)DataType.StringType));
        fields.add(new Field("drawer", (DataType)DataType.StringType));
        fields.add(new Field("receiver", (DataType)DataType.StringType));
        fields.add(new Field("accepter", (DataType)DataType.StringType));
        fields.add(new Field("currency", (DataType)DataType.LongType));
        fields.add(new Field("amount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("supperbillamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("subbillrange", (DataType)DataType.StringType));
        fields.add(new Field("settlementtype", (DataType)DataType.StringType));
        fields.add(new Field("bizdate", (DataType)DataType.StringType));
        fields.add(new Field("draftbilltype", (DataType)DataType.StringType));
        fields.add(new Field("endortype", (DataType)DataType.StringType));
        fields.add(new Field("endorsor", (DataType)DataType.StringType));
        fields.add(new Field("beendorsor", (DataType)DataType.StringType));
        DataSet resultDataset = null;
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)"cdm_getDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Row data : baseDataSet) {
            String draftBillNo = data.getString("draftbillno");
            String drawerName = data.getString("drawername");
            String receiverName = data.getString("receivername");
            String accepterName = data.getString("acceptername");
            Long currencyId = data.getLong("currency");
            BigDecimal amount = data.getBigDecimal("amount");
            BigDecimal supperBillAmount = data.getBigDecimal("supperbillamount");
            String subBillRange = data.getString("subbillrange");
            String settlementType = data.getString("settlementtype");
            String settlementTypeStr = SettleMentTypeEnum.getName((String)settlementType);
            ArrayList<QFilter> baseFilters = new ArrayList<QFilter>();
            baseFilters.add(new QFilter("draftbillno", "=", (Object)draftBillNo));
            baseFilters.add(new QFilter("subbillrange", "=", (Object)subBillRange));
            baseFilters.add(new QFilter("drawername", "=", (Object)drawerName));
            baseFilters.add(new QFilter("receivername", "=", (Object)receiverName));
            baseFilters.add(new QFilter("acceptername", "=", (Object)accepterName));
            baseFilters.add(new QFilter("draftbilltype.settlementtype", "=", (Object)settlementType));
            baseFilters.add(new QFilter("currency.id", "=", (Object)currencyId));
            baseFilters.add(new QFilter("amount", "=", (Object)amount));
            baseFilters.add(new QFilter("supperbillamount", "=", (Object)supperBillAmount));
            baseFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            baseFilters.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
            baseFilters.add(new QFilter("draftbillstatus", "!=", (Object)"splited"));
            ArrayList<QFilter> payableFilters = new ArrayList<QFilter>(baseFilters);
            payableFilters.add(new QFilter("rptype", "=", (Object)"paybill"));
            Object[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,bizdate,drawername,receivername", (QFilter[])payableFilters.toArray(new QFilter[0]), (String)"createtime ASC");
            if (!EmptyUtil.isEmpty((Object[])payableBills)) {
                Date bizDateDb = payableBills[0].getDate("bizdate");
                String bizDateDbStr = DateUtils.formatString((Date)bizDateDb, (String)"yyyy-MM-dd");
                String drawerNameDb = payableBills[0].getString("drawername");
                String receiverNameDb = payableBills[0].getString("receivername");
                Object[] rowDatas = new Object[]{draftBillNo, drawerName, receiverName, accepterName, currencyId, amount, supperBillAmount, subBillRange, settlementTypeStr, bizDateDbStr, ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e", (String)"BillEndorseDetailDataListPlugin0", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u51fa\u7968\u767b\u8bb0", (String)"BillEndorseDetailDataListPlugin1", (String)SYSTEM_TYPE, (Object[])new Object[0]), drawerNameDb, receiverNameDb};
                dsBuilder.append(rowDatas);
            }
            ArrayList<QFilter> receivableFilters = new ArrayList<QFilter>(baseFilters);
            receivableFilters.add(new QFilter("rptype", "=", (Object)"receivebill"));
            DynamicObject[] receivableBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,bizdate,delivername,deliver,company,endorseentry.entryid,endorseentry.signdate,endorseentry.endorsetype,endorseentry.initiatorname,endorseentry.opponentname", (QFilter[])receivableFilters.toArray(new QFilter[0]), (String)"createtime ASC,endorseentry.signdate DESC");
            int count = 0;
            for (DynamicObject receivableBill : receivableBills) {
                boolean isNoNeedDisplay;
                boolean displayFlag;
                Date bizDateDb = receivableBill.getDate("bizdate");
                String bizDateDbStr = DateUtils.formatString((Date)bizDateDb, (String)"yyyy-MM-dd");
                String deliverNameDb = receivableBill.getString("delivername");
                DynamicObject company = receivableBill.getDynamicObject("company");
                String companyNameDb = "";
                if (!EmptyUtil.isEmpty((DynamicObject)company)) {
                    companyNameDb = company.getString("name");
                }
                DynamicObjectCollection endorseentry = receivableBill.getDynamicObjectCollection("endorseentry");
                Object[] rowDatas = new Object[14];
                if (EmptyUtil.isEmpty((Object[])payableBills) && ++count == 1) {
                    rowDatas[0] = draftBillNo;
                    rowDatas[1] = drawerName;
                    rowDatas[2] = receiverName;
                    rowDatas[3] = accepterName;
                    rowDatas[4] = currencyId;
                    rowDatas[5] = amount;
                    rowDatas[6] = supperBillAmount;
                    rowDatas[7] = subBillRange;
                    rowDatas[8] = settlementTypeStr;
                }
                rowDatas[9] = bizDateDbStr;
                rowDatas[10] = ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e", (String)"BillEndorseDetailDataListPlugin2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                rowDatas[11] = ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"BillEndorseDetailDataListPlugin3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                rowDatas[12] = deliverNameDb;
                rowDatas[13] = companyNameDb;
                dsBuilder.append(rowDatas);
                boolean bl = displayFlag = count == endorseentry.size();
                if (EmptyUtil.isEmpty((DynamicObjectCollection)endorseentry) || !displayFlag) continue;
                DynamicObject endorseInfo = (DynamicObject)endorseentry.get(endorseentry.size() - 1);
                Date signDate = endorseInfo.getDate("signdate");
                String signDateStr = null;
                if (!EmptyUtil.isEmpty((Object)signDate)) {
                    signDateStr = DateUtils.formatString((Date)signDate, (String)"yyyy-MM-dd");
                }
                String endorseType = endorseInfo.getString("endorsetype");
                String endorseTypeStr = BillEndorseTypeEnum.getName((String)endorseType);
                String initiatorName = endorseInfo.getString("initiatorname");
                String opponentName = endorseInfo.getString("opponentname");
                boolean bl2 = isNoNeedDisplay = StringUtils.equals((CharSequence)bizDateDbStr, (CharSequence)signDateStr) && StringUtils.equals((CharSequence)companyNameDb, (CharSequence)opponentName);
                if (EmptyUtil.equals((CharSequence)endorseType, (CharSequence)BillEndorseTypeEnum.ACCEPTANCE.getValue()) || EmptyUtil.equals((CharSequence)endorseType, (CharSequence)BillEndorseTypeEnum.INVOICE.getValue()) || isNoNeedDisplay) continue;
                Object[] rowDatas1 = new Object[14];
                rowDatas1[9] = signDateStr;
                rowDatas1[10] = ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e", (String)"BillEndorseDetailDataListPlugin2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                rowDatas1[11] = endorseTypeStr;
                rowDatas1[12] = initiatorName;
                rowDatas1[13] = opponentName;
                dsBuilder.append(rowDatas1);
            }
        }
        resultDataset = dsBuilder.build();
        return resultDataset;
    }

    static {
        PROPERTY_MAPPING_MAP.put("filter_company", "company.id");
        PROPERTY_MAPPING_MAP.put("filter_billtypebase", "draftbilltype.id");
        PROPERTY_MAPPING_MAP.put("filter_billmedium", "draftbilltype.billmedium");
    }
}

