/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.plugin.view;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.report.helper.OrgHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.form.AbstractTmcOrgViewRptFormPlugin;

public class BillDynamicQueryDetailViewPlugin
extends AbstractTmcOrgViewRptFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(BillDynamicQueryDetailViewPlugin.class);

    protected String getFilterOrgField() {
        return "filter_org";
    }

    protected String getFilterOrgViewField() {
        return "filter_orgview";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.orgF7();
        this.billTypeF7();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.initQueryFromSum();
    }

    private void initQueryFromSum() {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object filterStr = customParams.get("filter");
        if (!EmptyUtil.isEmpty(filterStr)) {
            if (customParams.get("queryDetail") != null) {
                this.queryDetailByClickLetterNum(customParams);
            }
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        }
    }

    private void queryDetailByClickLetterNum(Map<String, Object> customParams) {
        Object filterStr = customParams.get("filter");
        if (!EmptyUtil.isEmpty((Object)filterStr)) {
            FilterInfo filter = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)((String)filterStr));
            List filterItems = filter.getFilterItems();
            for (FilterItemInfo filterItem : filterItems) {
                String propName = filterItem.getPropName();
                Object value = filterItem.getValue();
                if (this.getView().getControl(propName) == null) continue;
                this.getModel().setValue(propName, value);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgId = this.getOrgId();
        log.info("[BillDynamicQueryDetailViewPlugin]orgId: {}", (Object)orgId);
        if (EmptyUtil.isNoEmpty((Long)orgId)) {
            DynamicObject baseCurrency;
            this.getModel().setValue("filter_org", (Object)new Object[]{orgId});
            DynamicObject standardExRateTable = SystemStatusCtrolHelper.getStandardExRateTable((long)orgId);
            if (EmptyUtil.isNoEmpty((DynamicObject)standardExRateTable)) {
                this.getModel().setValue("filter_exratetable", standardExRateTable.getPkValue());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(baseCurrency = OrgHelper.getBaseCurrency(orgId)))) {
                this.getModel().setValue("filter_reportcurrency", baseCurrency.getPkValue());
            }
        }
    }

    public void beforeBindData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getFilterOrgViewField()});
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getFilterOrgField()});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getFilterOrgViewField()});
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getFilterOrgField()});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        if (filter != null) {
            Date queryEndDate = filter.getDate("filter_queryenddate");
            if (queryEndDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillDynamicQueryDetailPlugin_1", (String)"tmc-cdm-report", (Object[])new Object[0]));
                return false;
            }
            Object billType = filter.getValue("filter_billtype");
            if (billType == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillDynamicQueryDetailPlugin_2", (String)"tmc-cdm-report", (Object[])new Object[0]));
                return false;
            }
            Object exRateTable = filter.getValue("filter_exratetable");
            if (exRateTable == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillDynamicQueryDetailPlugin_3", (String)"tmc-cdm-report", (Object[])new Object[0]));
                return false;
            }
            Object reportCurrency = filter.getValue("filter_reportcurrency");
            if (reportCurrency == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillDynamicQueryDetailPlugin_4", (String)"tmc-cdm-report", (Object[])new Object[0]));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        switch (pro) {
            case "filter_billtype": {
                if (newValue == oldValue) break;
                this.getModel().setValue("filter_billtypebase", null);
                break;
            }
            case "filter_queryway": {
                if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(this.getModel().getValue("filter_queryway"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{this.getFilterOrgField()});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{this.getFilterOrgField()});
                break;
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filter = event.getQueryParam().getFilter();
        String statDim = filter.getString("filter_statdim");
        List columns = event.getColumns();
        ReportColumn dimColumn = columns.stream().filter(c -> StringUtils.equals((CharSequence)((ReportColumn)c).getFieldKey(), (CharSequence)"statcoltext")).findAny().orElse(null);
        if (EmptyUtil.isEmpty((Object)dimColumn)) {
            return;
        }
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            String key = reportColumn.getFieldKey();
            if (!StringUtils.equals((CharSequence)key, (CharSequence)statDim)) continue;
            reportColumn.setHide(true);
            dimColumn.setCaption(reportColumn.getCaption());
        }
    }

    private void orgF7() {
        BasedataEdit org = (BasedataEdit)this.getControl("filter_org");
        org.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            RequestContext requestContext = RequestContext.get();
            String appId = this.getView().getFormShowParameter().getAppId();
            String entityName = this.getModel().getDataEntityType().getName();
            List authorizedBankOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)requestContext.getCurrUserId(), (String)appId, (String)entityName, (String)"47150e89000000ac");
            if (EmptyUtil.isEmpty((Collection)authorizedBankOrgIds)) {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0L));
            } else {
                Object[] objectArray;
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authorizedBankOrgIds)}, null);
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)coll)) {
                    objectArray = OrgHelper.getIdList(coll);
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = 0L;
                }
                QFilter qFilterOfBank = new QFilter("id", "in", (Object)objectArray);
                showParameter.getListFilterParameter().setFilter(qFilterOfBank);
            }
        });
    }

    private void billTypeF7() {
        BasedataEdit billTypeBase = (BasedataEdit)this.getControl("filter_billtypebase");
        billTypeBase.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String billType = (String)this.getModel().getValue("filter_billtype");
            if (EmptyUtil.isEmpty((String)billType)) {
                return;
            }
            Set billTypeSet = Arrays.stream(billType.split(",", -1)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterOfBillType = new QFilter("settlementtype", "in", billTypeSet);
            showParameter.getListFilterParameter().setFilter(qFilterOfBillType);
        });
    }

    public Long getOrgId() {
        DynamicObjectCollection col;
        QFilter functionFilter;
        QFilter enableFilter;
        RequestContext requestContext = RequestContext.get();
        QFilter qFilter = new QFilter("id", "=", (Object)requestContext.getOrgId());
        DynamicObject currentUserOrg = TmcDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])new QFilter[]{qFilter, enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE), functionFilter = new QFilter("fisbankroll", "=", (Object)Boolean.TRUE)});
        if (EmptyUtil.isNoEmpty((DynamicObject)currentUserOrg) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(col = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)currentUserOrg.getLong("id")), new QFilter("isfinishinit", "=", (Object)"1")}, null)))) {
            return currentUserOrg.getLong("id");
        }
        DynamicObjectCollection coll = this.getCasInitData();
        return coll != null && coll.size() > 0 ? Long.valueOf(((DynamicObject)coll.get(0)).getLong("id")) : null;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        switch (fieldName = evt.getFieldName()) {
            case "billno": {
                this.showBillDetail(rowIndex, reportModel);
            }
        }
    }

    private void showBillDetail(int index, IReportListModel reportModel) {
        DynamicObject rowData = reportModel.getRowData(index);
        String rpType = rowData.getString("rptype");
        IReportView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId((Object)rowData.getLong("id"));
        parameter.setAppId(view.getFormShowParameter().getAppId());
        parameter.setParentFormId(formId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(StringUtils.equals((CharSequence)rpType, (CharSequence)"receivebill") ? "cdm_receivablebill" : "cdm_payablebill");
        parameter.setCustomParam("sourceBill", (Object)"cdm_report_bill_dy_detail");
        view.showForm((FormShowParameter)parameter);
    }

    private DynamicObjectCollection getCasInitData() {
        RequestContext requestContext = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getModel().getDataEntityType().getName();
        List authorizedBankOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)requestContext.getCurrUserId(), (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (EmptyUtil.isEmpty((Collection)authorizedBankOrgIds)) {
            return null;
        }
        return QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authorizedBankOrgIds), new QFilter("isfinishinit", "=", (Object)"1")}, null);
    }
}

