/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.report.print;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.tmc.cdm.report.helper.BillTradeConstant;
import kd.tmc.cdm.report.helper.BillTradeQueryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillTradeReportPrintPlugin
extends AbstractPrintServicePlugin {
    private static Map<String, Map<String, Class>> COLUMN_CONFIG_MAP = Collections.unmodifiableMap(new HashMap<String, Map<String, Class>>(4){
        {
            this.put(BillTradeReportPrintPlugin.TABLE_FIELD, new HashMap<String, Class>(32){
                {
                    super(x0);
                    this.put(BillTradeReportPrintPlugin.COMPANYNAME, String.class);
                    this.put(BillTradeReportPrintPlugin.BILLTYPE, String.class);
                    this.put(BillTradeReportPrintPlugin.ORGINALCURRENCY, String.class);
                    this.put("reportcurrency", String.class);
                    this.put(BillTradeReportPrintPlugin.ORIGINALAMOUNT, String.class);
                    this.put(BillTradeReportPrintPlugin.REPORTAMOUNT, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTENDDATE, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTENDDATE, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTRECBILL, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTRECBILL, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTENDORSE, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTENDORSE, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTDISCOUNT, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTDISCOUNT, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTCOLLECT, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTCOLLECT, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTPLEDGE, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTPLEDGE, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTRLSPLEDGE, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTRLSPLEDGE, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTENTERPOOL, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTENTERPOOL, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTOUTPOOL, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTOUTPOOL, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTBILLING, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTBILLING, String.class);
                    this.put(BillTradeReportPrintPlugin.ORIAMOUNTPAYOFF, String.class);
                    this.put(BillTradeReportPrintPlugin.REPAMOUNTPAYOFF, String.class);
                    this.put(BillTradeReportPrintPlugin.BILLPOOL, String.class);
                    this.put(BillTradeReportPrintPlugin.BILLPOOLNAME, String.class);
                    this.put(BillTradeReportPrintPlugin.REPORTCURRENCYNAME, String.class);
                    this.put(BillTradeReportPrintPlugin.CURRENCYNAME, String.class);
                }
            });
            this.put(BillTradeReportPrintPlugin.TABLE_HEAD, new HashMap<String, Class>(2){
                {
                    super(x0);
                    this.put(BillTradeReportPrintPlugin.CURRENCY_UNIT, String.class);
                    this.put("reportcurrency", String.class);
                }
            });
        }
    });
    private static final String TABLE_FIELD = "table_field";
    private static final String TABLE_HEAD = "table_head";
    private static final String COMPANYNAME = "companyname";
    private static final String BILLTYPE = "billtype";
    private static final String ORGINALCURRENCY = "orginalcurrency";
    private static final String REPORTCURRENCY = "reportcurrency";
    private static final String ORIGINALAMOUNT = "originalamount";
    private static final String REPORTAMOUNT = "reportamount";
    private static final String ORIAMOUNTENDDATE = "oriamountenddate";
    private static final String REPAMOUNTENDDATE = "repamountenddate";
    private static final String ORIAMOUNTRECBILL = "oriamountrecbill";
    private static final String REPAMOUNTRECBILL = "repamountrecbill";
    private static final String ORIAMOUNTENDORSE = "oriamountendorse";
    private static final String REPAMOUNTENDORSE = "repamountendorse";
    private static final String ORIAMOUNTDISCOUNT = "oriamountdiscount";
    private static final String REPAMOUNTDISCOUNT = "repamountdiscount";
    private static final String ORIAMOUNTCOLLECT = "oriamountcollect";
    private static final String REPAMOUNTCOLLECT = "repamountcollect";
    private static final String ORIAMOUNTPLEDGE = "oriamountpledge";
    private static final String REPAMOUNTPLEDGE = "repamountpledge";
    private static final String ORIAMOUNTRLSPLEDGE = "oriamountrlspledge";
    private static final String REPAMOUNTRLSPLEDGE = "repamountrlspledge";
    private static final String ORIAMOUNTENTERPOOL = "oriamountenterpool";
    private static final String REPAMOUNTENTERPOOL = "repamountenterpool";
    private static final String ORIAMOUNTOUTPOOL = "oriamountoutpool";
    private static final String REPAMOUNTOUTPOOL = "repamountoutpool";
    private static final String ORIAMOUNTBILLING = "oriamountbilling";
    private static final String REPAMOUNTBILLING = "repamountbilling";
    private static final String ORIAMOUNTPAYOFF = "oriamountpayoff";
    private static final String REPAMOUNTPAYOFF = "repamountpayoff";
    private static final String CURRENCY_UNIT = "currencyunit";
    private static final String REPORT_CURRENCY = "reportcurrency";
    private static final String BILLPOOL = "billpool";
    private static final String BILLPOOLNAME = "billpoolname";
    private static final String REPORTCURRENCYNAME = "reportcurrencyname";
    private static final String CURRENCYNAME = "currencyname";

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        DynamicObject reportCurrency;
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        ReportDataProvider o = (ReportDataProvider)e.getSource();
        ReportQueryParam queryParam = o.getQueryParam();
        String dataSourceName = e.getDataSourceName();
        ReportDataProvider reportDataProvider = (ReportDataProvider)e.getSource();
        String typeName = reportDataProvider.getMainEntityType().getName();
        DynamicObjectType customDT = this.rigisterType(dataSourceName);
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo filterItem = filter.getFilterItem("filter_statcurrency");
        if (Objects.isNull(filterItem) || Objects.isNull(reportCurrency = (DynamicObject)filterItem.getValue())) {
            return;
        }
        reportCurrency = BusinessDataServiceHelper.loadSingle((Object)reportCurrency.getPkValue(), (DynamicObjectType)reportCurrency.getDynamicObjectType());
        if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_HEAD)) {
            String statisticunit = filter.getString("filter_currencyunit");
            DynamicObject capitalsumhead = new DynamicObject(customDT);
            capitalsumhead.set(CURRENCY_UNIT, (Object)ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a%s", (String)"BillTradeReportPrintPlugin1", (String)"tmc-cdm-report", (Object[])new Object[]{BillTradeQueryHelper.getCurrencyUnit(statisticunit).getName().getDescription()}));
            capitalsumhead.set("reportcurrency", (Object)ResManager.loadKDString((String)"\u62a5\u544a\u5e01\uff1a%s", (String)"BillTradeReportPrintPlugin0", (String)"tmc-cdm-report", (Object[])new Object[]{reportCurrency.getString("name")}));
            dyns.add(capitalsumhead);
            return;
        }
        if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_FIELD)) {
            DataSet dataSet = null;
            dataSet = filter.containProp("filter_billtradepool") ? BillTradeQueryHelper.query(queryParam, Boolean.TRUE) : BillTradeQueryHelper.query(queryParam, Boolean.FALSE);
            String dataType = "";
            if (typeName.equalsIgnoreCase("cdm_report_billstrade")) {
                FilterItemInfo filter_datatype = filter.getFilterItem("filter_datatype");
                dataType = "A".equalsIgnoreCase(filter_datatype.getString()) ? "A" : "B";
            } else if (typeName.equalsIgnoreCase("cdm_report_billpooltrade")) {
                dataType = "C";
            }
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                DynamicObject capitalsumbody = this.fillData(row, customDT, reportCurrency, dataType);
                dyns.add(capitalsumbody);
            }
            if (EmptyUtil.isNoEmpty((Object)dataSet)) {
                dataSet.close();
            }
        }
    }

    private DynamicObject fillData(Row row, DynamicObjectType customDT, DynamicObject reportCurrency, String dataType) {
        DataEntityPropertyCollection properties = customDT.getProperties();
        DynamicObject capitalsumbody = new DynamicObject(customDT);
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (dataType.equalsIgnoreCase("A") ? !Arrays.asList(BillTradeConstant.fieldArr_rec).contains(name) : (dataType.equalsIgnoreCase("B") ? !Arrays.asList(BillTradeConstant.fieldArr_pay).contains(name) : dataType.equalsIgnoreCase("C") && !Arrays.asList(BillTradeConstant.fieldArr_pool).contains(name))) continue;
            capitalsumbody.set(name, this.getValueFormatIfNeed(name, row, reportCurrency, dataType));
        }
        return capitalsumbody;
    }

    private Object getValueFormatIfNeed(String name, Row row, DynamicObject reportCurrency, String dataType) {
        Object obj = row.get(name);
        if (Objects.isNull(obj)) {
            return "";
        }
        return obj.toString();
    }

    private String getDataSource(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "frombank": {
                return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AbstractBeiQingAnlsDataPlugin_9", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "import": {
                return ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165", (String)"AbstractBeiQingAnlsDataPlugin_10", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "modify": {
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u4fee\u590d", (String)"AbstractBeiQingAnlsDataPlugin_11", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getAmountValue(Object obj, String currencySign, Integer currencyAmtPrecision) {
        String value = "";
        if (obj instanceof Integer) {
            value = obj.toString();
        } else {
            if (obj instanceof BigDecimal) {
                BigDecimal amount = (BigDecimal)obj;
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    return BigDecimal.ZERO.toString();
                }
                return currencySign + BillTradeReportPrintPlugin.formatDecimal(amount, currencyAmtPrecision);
            }
            if (obj instanceof Double) {
                Double doubleValue = (Double)obj;
                BigDecimal decimal = BigDecimal.valueOf(doubleValue);
                return currencySign + BillTradeReportPrintPlugin.formatDecimal(decimal, currencyAmtPrecision);
            }
            value = obj.toString();
        }
        return value;
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(BillTradeReportPrintPlugin.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    private String getAcctStyle(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "basic": {
                return ResManager.loadKDString((String)"\u57fa\u672c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "normal": {
                return ResManager.loadKDString((String)"\u4e00\u822c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_1", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "temp": {
                return ResManager.loadKDString((String)"\u4e34\u65f6\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_2", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "spcl": {
                return ResManager.loadKDString((String)"\u4e13\u7528\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_3", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "fgn_curr": {
                return ResManager.loadKDString((String)"\u7ecf\u5e38\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_4", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "fng_fin": {
                return ResManager.loadKDString((String)"\u8d44\u672c\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_5", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getAcctType(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "in_out": {
                return ResManager.loadKDString((String)"\u6536\u652f\u6237", (String)"AbstractBeiQingAnlsDataPlugin_6", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "in": {
                return ResManager.loadKDString((String)"\u6536\u5165\u6237", (String)"AbstractBeiQingAnlsDataPlugin_7", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "out": {
                return ResManager.loadKDString((String)"\u652f\u51fa\u6237", (String)"AbstractBeiQingAnlsDataPlugin_8", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private DynamicObjectType rigisterType(String dataSourceName) {
        DynamicObjectType customDT = new DynamicObjectType();
        Map<String, Class> classMap = COLUMN_CONFIG_MAP.get(dataSourceName);
        if (Objects.isNull(classMap)) {
            return customDT;
        }
        for (Map.Entry<String, Class> entry : classMap.entrySet()) {
            Class clazz = entry.getValue();
            customDT.registerProperty(entry.getKey(), entry.getValue(), this.getDefaultValue(clazz), false);
        }
        return customDT;
    }

    private Object getDefaultValue(Class clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return "";
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return BigDecimal.ZERO;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return 0;
        }
        return null;
    }
}

