/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.allocation;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.RecEleDraftHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftAllocation2DraftTradeConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(DraftAllocation2DraftTradeConvertPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        boolean autoallocation = Boolean.parseBoolean(this.getOption().getVariableValue("autoallocation", "false"));
        logger.info("isSubmitEle and autoallocation is:" + autoallocation);
        for (ExtendedDataEntity billDataEntity : billDataEntities) {
            DynamicObject casPayBillDy;
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject draftAllocation = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cdm_draftallocation");
            String dispatchRule = draftAllocation.getString("dispatchrule");
            DynamicObject draftTrade = billDataEntity.getDataEntity();
            DynamicObject draftBill = ((DynamicObject)draftTrade.getDynamicObjectCollection("entrys").get(0)).getDynamicObject("draftbill");
            DynamicObjectCollection entrys = draftTrade.getDynamicObjectCollection("entrys");
            DynamicObject drafttype = draftTrade.getDynamicObject("drafttype");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) && entrys.size() > 0) {
                for (DynamicObject entry : entrys) {
                    BigDecimal billamt = entry.getBigDecimal("billamt");
                    BigDecimal billamountavailable = entry.getDynamicObject("draftbill").getBigDecimal("amount");
                    if (drafttype == null || !BillMediumEnum.ELECTRIC.getValue().equals(drafttype.getString("billmedium")) || billamt == null || billamountavailable == null || billamt.compareTo(billamountavailable) == 0) continue;
                    entry.set("isneedsplit", (Object)true);
                }
            }
            long sourceBillId = draftAllocation.getLong("sourcebillid");
            boolean isFromCas = false;
            if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((DynamicObject)(casPayBillDy = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"cas_paybill")))) {
                isFromCas = true;
            }
            logger.info("isFromCas is:" + isFromCas);
            DynamicObjectCollection entry = draftTrade.getDynamicObjectCollection("entrys");
            Optional<DynamicObject> first = entry.stream().map(row -> row.getDynamicObject("draftbill")).findFirst();
            if (first.isPresent() && "indirect".equals(dispatchRule)) {
                DynamicObject[] receivableBills = null;
                DynamicObject entryDraftBill = first.get();
                if (this.isSubmitEle(entryDraftBill)) {
                    BigDecimal billamt = ((DynamicObject)entry.get(0)).getBigDecimal("billamt");
                    String draftBillNo = draftBill.getString("draftbillno");
                    boolean issplit = draftBill.getBoolean("issplit");
                    QFilter draftBillNoFilter = new QFilter("draftbillno", "=", (Object)draftBillNo);
                    QFilter amountFilter = new QFilter("amount", "=", (Object)billamt);
                    QFilter draftrptypeFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                    QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
                    QFilter companyFilter = new QFilter("company", "=", draftAllocation.getDynamicObject("incompany").getPkValue());
                    QFilter qFilterAll = draftBillNoFilter.and(draftBillStatusFilter).and(companyFilter).and(draftrptypeFilter).and(amountFilter);
                    logger.info("isSubmitEle and issplit is:" + issplit);
                    if (issplit) {
                        String subbillrange = draftBill.getString("subbillrange");
                        QFilter issplitFilter = new QFilter("subbillrange", "=", (Object)subbillrange);
                        qFilterAll = qFilterAll.and(issplitFilter);
                    }
                    receivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])qFilterAll.toArray());
                }
                if (EmptyUtil.isEmpty(receivableBills)) {
                    logger.info("receivableBills is null");
                    receivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter("sourcedraft", "=", first.get().getPkValue()).toArray());
                }
                if (null != receivableBills && receivableBills.length > 0) {
                    logger.info("cdm_draftallocation.entrys will be Clear.");
                    try {
                        entry.stream().map(row -> row.getDynamicObject("draftbill")).filter(Objects::nonNull).forEach(o -> logger.info(String.join((CharSequence)" , ", o.getPkValue().toString(), o.getString("draftbillno"))));
                    }
                    catch (Exception e1) {
                        logger.error("alloc to tradeBill has error", (Throwable)e1);
                    }
                    entry.clear();
                    Iterator row2 = entry.addNew();
                    logger.info("alloc will change bill:" + receivableBills[0].getPkValue());
                    DynamicObject draftBillDy = BusinessDataServiceHelper.loadSingle((Object)receivableBills[0].getPkValue(), (String)"cdm_receivablebill");
                    row2.set("draftbill", draftBillDy);
                    row2.set("billamt", draftBillDy.getBigDecimal("availableamount"));
                }
            }
            HashMap<Long, Long> billIdAndLogIdMap = new HashMap<Long, Long>(8);
            DynamicObjectCollection allocEntrys = draftAllocation.getDynamicObjectCollection("entryentity");
            logger.info("allocEntrys is:" + EmptyUtil.isEmpty((DynamicObjectCollection)allocEntrys));
            for (DynamicObject allocEntry : allocEntrys) {
                long draftId = allocEntry.getDynamicObject("e_draftbill").getLong("id");
                long billLogId = allocEntry.getLong("draftbilllogid");
                logger.info("draftId is:" + draftId + ",billLogId is:" + billLogId);
                billIdAndLogIdMap.put(draftId, billLogId);
            }
            logger.info("billIdAndLogIdMap is:" + SerializationUtils.toJsonString(billIdAndLogIdMap));
            DynamicObjectCollection tradeBillEntrys = draftTrade.getDynamicObjectCollection("entrys");
            for (DynamicObject tradeBillEntry : tradeBillEntrys) {
                long draftBillId = tradeBillEntry.getDynamicObject("draftbill").getLong("id");
                logger.info("draftBillId is:" + draftBillId);
                Long billLogId = (Long)billIdAndLogIdMap.get(draftBillId);
                if (!EmptyUtil.isNoEmpty((Long)billLogId)) continue;
                tradeBillEntry.set("billlogid", (Object)billLogId);
            }
        }
    }

    protected boolean isSubmitEle(DynamicObject draftBill) {
        DynamicObject draftBillType = draftBill.getDynamicObject("draftbilltype");
        draftBillType = TmcDataServiceHelper.loadSingle((Object)draftBillType.getPkValue(), (String)"cdm_billtype");
        String billMedium = draftBillType.getString("billmedium");
        logger.info("billMedium:" + billMedium);
        return Objects.equals(billMedium, BillMediumEnum.ELECTRIC.getValue()) && RecEleDraftHelper.isElectronicbill((Object)draftBill.getDynamicObject("company").getPkValue());
    }
}

