/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.elcDraft;

import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.ReturnNoteSetHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class ElectronicSignImportOp
extends AbstractTmcBatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(ElectronicSignImportOp.class);
    private static final String CDM_ELECTRONIC_SIGN_DEAL = "cdm_electronic_sign_deal";

    protected void beforeImportOp(Map<String, Object> rowdata, Map<String, Object> option) {
        this.fillDefaultDataAndCheck(rowdata);
    }

    protected void afterImportOp(List<Map<String, Object>> datas) {
        DynamicObject[] electronicSignBills;
        if (datas == null || datas.size() <= 0) {
            return;
        }
        for (DynamicObject electronicSignBill : electronicSignBills = TmcDataServiceHelper.load((Object[])datas.stream().filter(elem -> (Boolean)elem.get("success")).map(elem -> (Long)elem.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CDM_ELECTRONIC_SIGN_DEAL))) {
            try {
                String queryDraftType;
                electronicSignBill.set("datasource", (Object)"import");
                electronicSignBill.set("opstatus", (Object)DraftBillOpStatusEnum.SYNC_SUCCESS.getValue());
                boolean isReturnNote = ReturnNoteSetHelper.isReturnNote((DynamicObject)electronicSignBill.getDynamicObject("company"), (DynamicObject)electronicSignBill);
                electronicSignBill.set("returnnotetag", (Object)isReturnNote);
                electronicSignBill.set("rptype", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                if (StringUtils.isEmpty((CharSequence)electronicSignBill.getString("opstatus"))) {
                    electronicSignBill.set("opstatus", (Object)DraftBillOpStatusEnum.SYNC_SUCCESS.getValue());
                }
                electronicSignBill.set("querydrafttype", (Object)(StringUtils.isEmpty((CharSequence)(queryDraftType = electronicSignBill.getString("querydrafttype"))) ? EleDraftExistCatEnum.REPLY.getValue() : queryDraftType));
                electronicSignBill.set("applicantacctext", (Object)electronicSignBill.getString("conectno"));
                electronicSignBill.set("isinsertpayorrec", (Object)Boolean.TRUE);
                String subRange = StringUtils.isEmpty((CharSequence)electronicSignBill.getString("subrange")) ? "0" : electronicSignBill.getString("subrange");
                electronicSignBill.set("subrange", (Object)subRange);
                electronicSignBill.set("initsubrange", (Object)subRange);
                electronicSignBill.set("initamount", (Object)electronicSignBill.getBigDecimal("amount"));
                electronicSignBill.set("interfacetype", (Object)(StringUtils.isEmpty((CharSequence)"cirstatus") ? "1" : "0"));
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        SaveServiceHelper.save((DynamicObject[])electronicSignBills);
    }

    public String getDefaultImportType() {
        return "overridenew";
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    private void fillDefaultDataAndCheck(Map<String, Object> data) {
        String billNo = (String)data.get("billno");
        String connectNo = (String)data.get("conectno");
        String subRange = (String)data.get("subrange");
        QFilter signImpFilter = new QFilter("billno", "=", (Object)billNo);
        signImpFilter.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        signImpFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.REPLY.getValue()));
        signImpFilter.and(new QFilter("conectno", "=", (Object)connectNo));
        signImpFilter.and(new QFilter("subrange", "=", (Object)(subRange == null ? "0" : subRange)));
        DynamicObject[] draftBillList = BusinessDataServiceHelper.load((String)CDM_ELECTRONIC_SIGN_DEAL, (String)"id,rptype,billno,ticketstatus,opstatus,bizdate,conectno,bankconsultno,createtime,entryentity,subrange,isnotesideserror,tradetype,ebstatus,preholdername,company,entryentity,draftaccount,isautosignin", (QFilter[])new QFilter[]{signImpFilter});
        if (draftBillList.length > 0) {
            int localSize = draftBillList[0].getDynamicObjectCollection("entryentity").size();
            JSONArray entryEntityArray = (JSONArray)data.get("entryentity");
            int importSize = entryEntityArray.size();
            if (importSize == localSize) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801\u201c%s\u201d\u91cd\u590d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ElectronicSignImportOp_0", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), billNo));
            }
        }
    }
}

