/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.tradebill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.opplugin.tradebill.TradeBillConvertPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CollectTradeBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(TradeBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        log.info("TradeBillConvertPlugin is start");
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"cdm_drafttradebill");
            Object tradeType = tradeBill.get("tradetype");
            DynamicObject drafttype = tradeBill.getDynamicObject("drafttype");
            String settlementtype = drafttype.getString("settlementtype");
            DynamicObjectCollection entrys = tradeBill.getDynamicObjectCollection("entrys");
            HashMap<String, BigDecimal> mnymap = new HashMap<String, BigDecimal>();
            HashMap<String, String> settlementNum = new HashMap<String, String>();
            for (DynamicObject entry : entrys) {
                String transStatus;
                BigDecimal destmoney;
                BigDecimal ormoney;
                String acceptername = entry.getDynamicObject("draftbill").getString("acceptername");
                String drawername = entry.getDynamicObject("draftbill").getString("drawername");
                BigDecimal billamt = entry.getDynamicObject("draftbill").getBigDecimal("amount");
                if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                    if (mnymap.get("checkandpromissory") == null) {
                        mnymap.put("checkandpromissory", billamt);
                    } else {
                        ormoney = (BigDecimal)mnymap.get("checkandpromissory");
                        destmoney = ormoney.add(billamt);
                        mnymap.put("checkandpromissory", destmoney);
                    }
                } else if (mnymap.get(acceptername) == null) {
                    mnymap.put(acceptername, billamt);
                } else {
                    ormoney = (BigDecimal)mnymap.get(acceptername);
                    destmoney = ormoney.add(billamt);
                    mnymap.put(acceptername, destmoney);
                }
                if (!EmptyUtil.isEmpty((String)(transStatus = entry.getString("transtatus"))) && !DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus)) continue;
                String draftbillno = entry.getDynamicObject("draftbill").getString("draftbillno");
                if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                    if (settlementNum.get("checkandpromissory") == null) {
                        settlementNum.put("checkandpromissory", draftbillno);
                        continue;
                    }
                    draftbillno = (String)settlementNum.get("checkandpromissory") + "; " + draftbillno;
                    settlementNum.put("checkandpromissory", draftbillno);
                    continue;
                }
                if (settlementNum.get(acceptername) == null) {
                    settlementNum.put(acceptername, draftbillno);
                    continue;
                }
                draftbillno = (String)settlementNum.get(acceptername) + "; " + draftbillno;
                settlementNum.put(acceptername, draftbillno);
            }
            DynamicObject recbill = billDataEntity.getDataEntity();
            String f7_payer = recbill.getString("payername");
            DynamicObjectCollection recentrys = recbill.getDynamicObjectCollection("entry");
            for (DynamicObject recentry : recentrys) {
                if (mnymap.get("checkandpromissory") != null) {
                    recentry.set("e_receivableamt", mnymap.get("checkandpromissory"));
                    recentry.set("e_actamt", mnymap.get("checkandpromissory"));
                    continue;
                }
                recentry.set("e_receivableamt", mnymap.get(f7_payer));
                recentry.set("e_actamt", mnymap.get(f7_payer));
            }
            if (DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType)) {
                DynamicObject recBill = billDataEntity.getDataEntity();
                if (settlementNum.get("checkandpromissory") != null) {
                    recBill.set("settletnumber", settlementNum.get("checkandpromissory"));
                    continue;
                }
                String payername = recbill.getString("payername");
                recBill.set("settletnumber", settlementNum.get(payername));
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u6258\u6536\u540e\u53f0\u4e0b\u63a8\u6536\u6b3e\u5355\u53ea\u652f\u6301\u7968\u636e\u6258\u6536\u7968\u636e\u7c7b\u578b\uff01", (String)"CollectTradeBillConvertPlugin_0", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        log.info("TradeBillConvertPlugin is end");
    }
}

