/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.tradebill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillBaseDataImport
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(TradeBillBaseDataImport.class);
    private static final String DRAFTBILL = "draftbill";

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        logger.info("TradeBillBaseDataImport,queryImportBasedata start");
        Map searchResult = e.getSearchResult();
        Map jsonObject = ((RowMapper)e.getSource()).getSourceObj();
        String rpType = EmptyUtil.isEmpty(jsonObject.get("rptype")) ? "receivebill" : (String)jsonObject.get("rptype");
        long companyId = EmptyUtil.isEmpty(jsonObject.get("company")) ? 0L : ((JSONObject)jsonObject.get("company")).getLong("id");
        String companyNumber = EmptyUtil.isEmpty(jsonObject.get("company")) ? "" : ((JSONObject)jsonObject.get("company")).getString("number");
        String billNo = (String)jsonObject.get("billno");
        Map<String, String> draftBillStatusEntryMap = this.getDraftBillStatusEntryMap(jsonObject);
        logger.info("queryImportBasedata,companyId:" + companyId + ",companyNumber:" + companyNumber + ",rpType:" + rpType);
        for (Map.Entry entry : searchResult.entrySet()) {
            DynamicObject[] draftBills;
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            if (!basedataItem.getFieldKey().equals(DRAFTBILL)) continue;
            String draftBillStatus = EmptyUtil.isEmpty((String)draftBillStatusEntryMap.get(basedataItem.getSearchValue())) ? "registered" : draftBillStatusEntryMap.get(basedataItem.getSearchValue());
            QFilter qFilter = new QFilter("id", "in", entry.getValue());
            qFilter.and("rptype", "=", (Object)rpType);
            qFilter.and("draftbillstatus", "=", (Object)draftBillStatus);
            qFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
            for (DynamicObject draftBill : draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,company,rptype,draftbillstatus", (QFilter[])qFilter.toArray())) {
                long companyIdDb = draftBill.getDynamicObject("company").getLong("id");
                String rpTypeDb = draftBill.getString("rptype");
                String draftBillStatusDb = draftBill.getString("draftbillstatus");
                boolean isMatch = companyId == companyIdDb || companyId == 0L;
                logger.info("isMatch:" + isMatch + ",billNo:" + billNo + ",draftBillNo:" + basedataItem.getSearchValue() + ",companyId:" + companyId + ",companyIdDb:" + companyIdDb + ",rpType:" + rpType + ",rpTypeDb:" + rpTypeDb + ",draftBillStatus:" + draftBillStatus + ",draftBillStatusDb:" + draftBillStatusDb);
                if (!isMatch) continue;
                entry.setValue(Collections.singletonList(draftBill.getPkValue()));
                logger.info("isMatch success,matchId:" + draftBill.getLong("id") + ",billNo:" + billNo + ",draftBillNo:" + basedataItem.getSearchValue());
            }
        }
    }

    private Map<String, String> getDraftBillStatusEntryMap(Map<String, Object> jsonObject) {
        long companyId;
        HashMap<String, String> draftBillStatusEntryMap = new HashMap<String, String>(8);
        long l = companyId = EmptyUtil.isEmpty((Object)jsonObject.get("company")) ? 0L : ((JSONObject)jsonObject.get("company")).getLong("id");
        if (!EmptyUtil.isEmpty((Long)companyId)) {
            Object entrys = jsonObject.get("entrys");
            if (!EmptyUtil.isEmpty((Object)entrys)) {
                JSONArray jsonArray = (JSONArray)entrys;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject entry = jsonArray.getJSONObject(i);
                    String draftBillNo = entry.getJSONObject(DRAFTBILL).getString("draftbillno");
                    String draftBillStatus = entry.getString("draftbillstatusfield");
                    draftBillStatusEntryMap.put(draftBillNo, draftBillStatus);
                }
            }
        } else {
            String draftBillStatus = (String)jsonObject.get("draftbillstatusfield");
            String draftBillNo = "";
            if (!EmptyUtil.isEmpty((Object)jsonObject.get(DRAFTBILL))) {
                draftBillNo = ((JSONObject)jsonObject.get(DRAFTBILL)).getString("draftbillno");
            }
            draftBillStatusEntryMap.put(draftBillNo, draftBillStatus);
        }
        return draftBillStatusEntryMap;
    }
}

