/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.opplugin.tradebill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(TradeBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        log.info("TradeBillConvertPlugin is start");
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"cdm_drafttradebill");
            Object tradeType = tradeBill.get("tradetype");
            String settlementNum = tradeBill.getDynamicObjectCollection("entrys").stream().filter(o -> {
                String transStatus = o.getString("transtatus");
                return EmptyUtil.isEmpty((String)transStatus) || DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus);
            }).map(o -> o.getDynamicObject("draftbill").getString("draftbillno")).collect(Collectors.joining("; "));
            if (DraftTradeTypeEnum.DISCOUNT.getValue().equals(tradeType) || DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType) || DraftTradeTypeEnum.PAYINTEREST.getValue().equals(tradeType)) {
                DynamicObject recBill = billDataEntity.getDataEntity();
                recBill.set("settletnumber", (Object)settlementNum);
                continue;
            }
            if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
                DynamicObject payBill = billDataEntity.getDataEntity();
                DynamicObjectCollection tradeBillEntry = tradeBill.getDynamicObjectCollection("entrys");
                Object[] idArr = tradeBillEntry.stream().map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
                DynamicObject[] draftBillF7Arr = TmcDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                DynamicObject firstDraftBill = draftBillF7Arr[0];
                DynamicObjectCollection settleTypeList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)payBill, (String)"draftbill", (DynamicObject[])draftBillF7Arr);
                payBill.set("draftbill", (Object)settleTypeList);
                payBill.set("settletnumber", (Object)settlementNum);
                Map variables = this.getOption().getVariables();
                DynamicObject acct = Objects.equals(String.valueOf(Boolean.TRUE), variables.get("deposit")) ? tradeBill.getDynamicObject("depositaccount") : firstDraftBill.getDynamicObject("draweraccount");
                payBill.set("payeracctbank", (Object)acct);
                if (Objects.nonNull(acct)) {
                    payBill.set("payerbank", acct.get("bank"));
                }
                String settlementType = tradeBill.getDynamicObject("drafttype").getString("settlementtype");
                if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                    payBill.set("payeename", firstDraftBill.get("acceptername"));
                } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                    payBill.set("payeebanknum", firstDraftBill.get("accepteraccount"));
                    payBill.set("payeebankname", firstDraftBill.get("accepterbankname"));
                    payBill.set("payeename", firstDraftBill.get("acceptername"));
                } else {
                    payBill.set("payeebanknum", firstDraftBill.get("receiveraccount"));
                    payBill.set("payeename", firstDraftBill.get("receivername"));
                    DynamicObject recBank = firstDraftBill.getDynamicObject("receiverbank");
                    if (recBank != null) {
                        payBill.set("payeebankname", (Object)recBank.getString("name"));
                    }
                }
                if (!tradeBill.getBoolean("depositdeduct") && (!tradeBill.getBoolean("deposit") || variables.containsKey("deposit") && Objects.equals(String.valueOf(Boolean.TRUE), variables.get("deposit")))) continue;
                BigDecimal amount = tradeBill.getBigDecimal("amount").subtract(tradeBill.getBigDecimal("depositamount")).subtract(tradeBill.getBigDecimal("deductamount"));
                payBill.set("actpayamt", (Object)amount);
                DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
                DynamicObjectCollection entryDelete = new DynamicObjectCollection();
                int entrySize = entry.size();
                if (entrySize > 1) {
                    for (int i = 1; i < entrySize; ++i) {
                        entryDelete.add(entry.get(i));
                    }
                    entry.removeAll((Collection)entryDelete);
                }
                ((DynamicObject)entry.get(0)).set("e_actamt", (Object)amount);
                ((DynamicObject)entry.get(0)).set("e_payableamt", (Object)amount);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7968\u636e\u7c7b\u578b: %s", (String)"TradeBillConvertPlugin_0", (String)"tmc-cdm-opplugin", (Object[])new Object[0]), tradeType));
        }
        log.info("TradeBillConvertPlugin is end");
    }

    private DynamicObject getSettlementType(String settlementType) {
        QFilter statusFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("settlementtype", "=", (Object)settlementType);
        return TmcDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id", (QFilter[])new QFilter[]{statusFilter, enableFilter, typeFilter});
    }
}

