/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.security.SecureRandom;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.cdm.common.constant.BFRow;
import kd.tmc.cdm.common.constant.DBRouteConst;

public class BotpHelper {
    private static final Log logger = LogFactory.getLog(BotpHelper.class);

    @Deprecated
    public static DynamicObject[] push(String sourceEntity, String TargetEntity, DynamicObject info) {
        return BotpHelper.push(info, TargetEntity);
    }

    public static DynamicObject[] push(DynamicObject info, String TargetEntity) {
        String sourceEntity = info.getDataEntityType().getName();
        String ruleId = BotpHelper.getDefaultBotpRule(sourceEntity, TargetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(TargetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)TargetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < dynamicresults.size(); ++i) {
            dataEntities[i] = (DynamicObject)dynamicresults.get(i);
            String number = codeRuleService.getNumber(TargetEntity, (DynamicObject)dynamicresults.get(i), ((DynamicObject)dynamicresults.get(i)).getString("org.id"));
            if (StringUtils.isEmpty((String)number)) {
                if (BotpHelper.isDevEnv()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    number = simpleDateFormat.format(new Date());
                    number = number + String.valueOf(random.nextInt(1000000));
                } else {
                    ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\uff01", (String)"BotpHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
            }
            dataEntities[i].set("billno", (Object)number);
        }
        return dataEntities;
    }

    public static DynamicObject[] push(DynamicObject info, String TargetEntity, Map<String, String> CustomParam) {
        String sourceEntity = info.getDataEntityType().getName();
        String ruleId = BotpHelper.getDefaultBotpRule(sourceEntity, TargetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(TargetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        if (CustomParam != null) {
            CustomParam.entrySet().stream().forEach(item -> args.addCustomParam((String)item.getKey(), (String)item.getValue()));
        }
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)TargetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < dynamicresults.size(); ++i) {
            dataEntities[i] = (DynamicObject)dynamicresults.get(i);
            String number = codeRuleService.getNumber(TargetEntity, (DynamicObject)dynamicresults.get(i), ((DynamicObject)dynamicresults.get(i)).getString("org.id"));
            if (StringUtils.isEmpty((String)number)) {
                if (BotpHelper.isDevEnv()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    number = simpleDateFormat.format(new Date());
                    number = number + String.valueOf(random.nextInt(1000000));
                } else {
                    ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\uff01", (String)"BotpHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
            }
            dataEntities[i].set("billno", (Object)number);
        }
        return dataEntities;
    }

    public static DynamicObject[] pushByRule(DynamicObject info, String targetEntity, String ruleId) {
        BotpHelper.getBotpRule(ruleId);
        String sourceEntity = info.getDataEntityType().getName();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < dynamicresults.size(); ++i) {
            dataEntities[i] = (DynamicObject)dynamicresults.get(i);
            String number = codeRuleService.getNumber(targetEntity, (DynamicObject)dynamicresults.get(i), ((DynamicObject)dynamicresults.get(i)).getString("org.id"));
            if (StringUtils.isEmpty((String)number)) {
                if (BotpHelper.isDevEnv()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    number = simpleDateFormat.format(new Date());
                    number = number + String.valueOf(random.nextInt(1000000));
                } else {
                    ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\uff01", (String)"BotpHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
            }
            dataEntities[i].set("billno", (Object)number);
        }
        return dataEntities;
    }

    private static String getDefaultBotpRule(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\uff01", (String)"BotpHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return rules[0].getString("id");
    }

    private static String getBotpRule(String ruleId) {
        QFilter[] filter = new QFilter[]{new QFilter("id", "=", (Object)ruleId)};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\uff01", (String)"BotpHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        return rules[0].getString("id");
    }

    public static List<BFRow> getLinkedBill(Long id, boolean isLinkUp) {
        String sql = null;
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        if (isLinkUp) {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FTBILLID= ?";
            params.add(new SqlParameter(":FTBILLID", -5, (Object)id));
        } else {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FSBILLID= ?";
            params.add(new SqlParameter(":FSBILLID", -5, (Object)id));
        }
        ResultSetHandler<List<BFRow>> action = new ResultSetHandler<List<BFRow>>(){

            public List<BFRow> handle(ResultSet rs) throws Exception {
                ArrayList<BFRow> rowIds = new ArrayList<BFRow>(10);
                while (rs.next()) {
                    Long id = rs.getLong("FID");
                    Long sTableId = rs.getLong("FSTABLEID");
                    Long sBillId = rs.getLong("FSBILLID");
                    Long tTableId = rs.getLong("FTTABLEID");
                    Long tBillId = rs.getLong("FTBILLID");
                    BFRow rowId = new BFRow(id, sBillId, sTableId, tTableId, tBillId);
                    rowIds.add(rowId);
                }
                return rowIds;
            }
        };
        List rowIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        return rowIds;
    }

    public static List<Long> getLinkedBillIds(Long id, boolean isLinkUp, String entityName) {
        ArrayList<Long> paybillIds = new ArrayList<Long>(0);
        if (id == null || Long.compare(id, 0L) == 0 || entityName == null || entityName.length() < 1) {
            return paybillIds;
        }
        List<BFRow> rowIds = BotpHelper.getLinkedBill(id, isLinkUp);
        if (rowIds == null || rowIds.size() < 1) {
            return paybillIds;
        }
        Long paybillTableId = BotpHelper.getTableIdByEntityKey(entityName);
        rowIds.stream().filter(item -> paybillTableId.compareTo(item.getsTableId()) == 0).forEach(item -> paybillIds.add(item.getsBillid()));
        return paybillIds;
    }

    public static Long getTableIdByEntityKey(final String entityName) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FEntityKey = ? ");
        parameters[0] = new SqlParameter(":FEntityKey", 12, (Object)entityName);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(entityName);
                    tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getTableId();
    }

    public static void saveRelation(String sourceEntityKey, Collection<Long> sourcePks, String targetEntityKey, Long targetPk) {
        Long sourceTableId = BotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = BotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<BFRow> rows = new ArrayList<BFRow>(sourcePks.size());
        for (Long sourcePk : sourcePks) {
            long pk = DBServiceHelper.genGlobalLongId();
            BFRow row = new BFRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        BotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void saveRelation(String sourceEntityKey, Long sourcePk, String targetEntityKey, Collection<Long> targetPks) {
        Long sourceTableId = BotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = BotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<BFRow> rows = new ArrayList<BFRow>(targetPks.size());
        for (Long targetPk : targetPks) {
            long pk = DBServiceHelper.genGlobalLongId();
            BFRow row = new BFRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        BotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void saveRelation(DBRoute dbRoute, String sourceEntityKey, Long sourcePk, String targetEntityKey, Collection<Long> targetPks) {
        Long sourceTableId = BotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = BotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<BFRow> rows = new ArrayList<BFRow>(targetPks.size());
        for (Long targetPk : targetPks) {
            long pk = DBServiceHelper.genGlobalLongId();
            BFRow row = new BFRow(pk, sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        BotpHelper.saveRelation(dbRoute, rows, targetEntityKey);
    }

    public static void saveRelation(List<BFRow> rows, String targetEntityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("CAS_BOTP_ERROR", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\uff01", (String)"BotpHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]), targetEntityKey)), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        BotpHelper.saveBizRelation(rows, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            BotpHelper.saveSysRelation(rows);
        }
    }

    public static void saveRelation(DBRoute dbRoute, List<BFRow> rows, String targetEntityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("CAS_BOTP_ERROR", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\uff01", (String)"BotpHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]), targetEntityKey)), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        BotpHelper.saveBizRelation(dbRoute, rows, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            BotpHelper.saveSysRelation(rows);
        }
    }

    private static void saveSysRelation(List<BFRow> rows) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        for (BFRow row : rows) {
            params.clear();
            params.add(new SqlParameter(":FID", -5, (Object)row.getId()));
            params.add(new SqlParameter(":FSTABLEID", -5, (Object)row.getsTableId()));
            params.add(new SqlParameter(":FSBILLID", -5, (Object)row.getsBillid()));
            params.add(new SqlParameter(":FTTABLEID", -5, (Object)row.gettTableId()));
            params.add(new SqlParameter(":FTBILLID", -5, (Object)row.getTbillId()));
            params.add(new SqlParameter(":FCREATETIME", 91, (Object)new Date()));
            batchParameters.add(params.toArray(new SqlParameter[params.size()]));
        }
        String sBuilder = "INSERT INTO T_BOTP_BillTracker (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sBuilder, batchParameters);
    }

    private static void saveBizRelation(List<BFRow> rows, String tc, String lk) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(10);
        for (BFRow row : rows) {
            params_tc.clear();
            params_lk.clear();
            Long id_tc = DBServiceHelper.genGlobalLongId();
            Long FTBillId = row.getTbillId();
            Long FTTableId = row.gettTableId();
            Long FTId = row.getTbillId();
            Long FSBillId = row.getsBillid();
            Long FSTableId = row.getsTableId();
            Long FSId = row.getsBillid();
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            params_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            deleteBatchParameters.add(new SqlParameter[]{new SqlParameter(":FId", -5, (Object)FTId)});
        }
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FId= ?";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sBuilder_lk, lkBatchParameters);
    }

    private static void saveBizRelation(DBRoute dbRoute, List<BFRow> rows, String tc, String lk) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(10);
        for (BFRow row : rows) {
            params_tc.clear();
            params_lk.clear();
            Long id_tc = DBServiceHelper.genGlobalLongId();
            Long FTBillId = row.getTbillId();
            Long FTTableId = row.gettTableId();
            Long FTId = row.getTbillId();
            Long FSBillId = row.getsBillid();
            Long FSTableId = row.getsTableId();
            Long FSId = row.getsBillid();
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            params_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            deleteBatchParameters.add(new SqlParameter[]{new SqlParameter(":FId", -5, (Object)FTId)});
        }
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FId= ?";
        DB.executeBatch((DBRoute)dbRoute, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_lk, lkBatchParameters);
    }

    private static boolean isDevEnv() {
        String tenantId = RequestContext.get().getTenantId();
        String userName = RequestContext.get().getUserName();
        return "devbiz".equals(tenantId) || "dev1211".equals(tenantId) || "IERP".equals(userName);
    }

    public static DynamicObject[] pushBySpecifiedEntry(DynamicObject[] srcBills, String entryPropName, Set<Long> entryIdSet, String targetEntity) {
        PushArgs pushArgs = new PushArgs();
        String srcEntityName = srcBills[0].getDataEntityType().getName();
        pushArgs.setSourceEntityNumber(srcEntityName);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setAppId("");
        pushArgs.setDefOrgId(Long.valueOf(0L));
        pushArgs.setRuleId("");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : srcBills) {
            DynamicObjectCollection entries = srcBill.getDynamicObjectCollection(entryPropName);
            for (DynamicObject entry : entries) {
                if (!entryIdSet.contains(entry.getPkValue())) continue;
                ListSelectedRow row = new ListSelectedRow((Object)srcBill.getLong("id"));
                row.setEntryEntityKey(entryPropName);
                row.setEntryPrimaryKeyValue(entry.getPkValue());
                selectedRows.add(row);
            }
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            logger.error("push pushresult error:" + errMessage);
            ErrorCode ec = new ErrorCode("", errMessage);
            throw new KDException(ec, new Object[0]);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        return targetBillObjs.toArray(new DynamicObject[0]);
    }
}

