/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CasHelper {
    private static final String[] DELIMITERS = new String[]{";", ","};

    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        if (o instanceof Long) {
            return o == null || (Long)o == 0L;
        }
        if (o instanceof BigDecimal) {
            return o == null || ((BigDecimal)o).compareTo(BigDecimal.ZERO) == 0;
        }
        return o == null;
    }

    public static boolean isNotEmpty(Object o) {
        return !CasHelper.isEmpty(o);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(CasHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static String idListToInClause(List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append(idList.get(0));
        } else {
            Iterator<Long> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append(it.next()).append(", ");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String idsToInClause(List<String> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append('\'');
            sb.append(idList.get(0));
            sb.append('\'');
        } else {
            Iterator<String> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append('\'');
                sb.append(it.next());
                sb.append('\'');
                sb.append(", \n");
            }
            sb.append('\'');
            sb.append(it.next());
            sb.append('\'');
        }
        return sb.toString();
    }

    public static List<Long> getIdList(DynamicObject[] infos) {
        ArrayList<Long> idList = new ArrayList<Long>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.getPkValue() == null ? 0L : Long.parseLong(info.getPkValue().toString()));
        }
        return idList;
    }

    public static DynamicObject loadSingleFromCache(Object pk, String entityName) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
    }

    public static String getStackTraceMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.flush();
        return sw.toString();
    }

    public static boolean isEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj2 == null && obj1 instanceof String) {
                return StringUtils.isBlank((Object)obj1);
            }
            if (obj1 == null && obj2 instanceof String) {
                return StringUtils.isBlank((Object)obj2);
            }
            return false;
        }
        if (obj1.getClass().equals(obj2.getClass())) {
            if (obj1 instanceof BigDecimal) {
                return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
            }
            if (obj1 instanceof DynamicObject) {
                return ((DynamicObject)obj1).getPkValue().equals(((DynamicObject)obj2).getPkValue());
            }
            return obj1.equals(obj2);
        }
        return false;
    }

    public static String removeFieldPrefix(String field) {
        int index = field.indexOf(46);
        index = index > 0 ? ++index : 0;
        return field.substring(index);
    }

    public static <T> T[] mergeArrays(T[] t1, T[] t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + t2.length);
        for (int i = 0; i < t2.length; ++i) {
            copyOf[i + t1.length] = t2[i];
        }
        return copyOf;
    }

    public static <T> T[] mergeArrays(T[] t1, T t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + 1);
        copyOf[t1.length] = t2;
        return copyOf;
    }

    public static Long getCurrentUser() {
        return RequestContext.get().getCurrUserId();
    }

    public static int getSelectedRowSize(ListSelectedRowCollection selectedRows) {
        HashSet pkIds = new HashSet();
        selectedRows.forEach(row -> pkIds.add((Long)row.getPrimaryKeyValue()));
        return pkIds.size();
    }

    public static boolean isEmpty(DynamicObject[] objs) {
        return objs == null || objs.length == 0;
    }

    public static OperateErrorInfo getOperateErrorInfo(Object pk, String meg, String title) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setTitle(title);
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    public static void showOperationResultMulti(OperationResult operationResult, String operateName, IFormView view) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        int errorCount = errorInfos.size();
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u5f20\uff0c\u5931\u8d25%4$s\u5f20", (String)"CasHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]), operationResult.getBillCount(), StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, operationResult.getBillCount() - errorCount, errorCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        view.showForm(parameters);
    }

    public static boolean isNum(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Long getLong(Object obj) {
        return Long.parseLong(String.valueOf(obj));
    }

    public static String getLocalValue(DynamicObject obj, String prop) {
        if (obj == null || CasHelper.isEmpty(prop)) {
            return "";
        }
        String localeValue = obj.getLocaleString(prop).getLocaleValue();
        if (CasHelper.isEmpty(localeValue)) {
            String value = obj.getString(prop);
            return CasHelper.isEmpty(value) ? "" : value;
        }
        return localeValue;
    }

    public static List<String> getOverrideField(Object keyFields) {
        List<String> fieldList = new ArrayList<String>(10);
        String fields = String.valueOf(keyFields);
        if (CasHelper.isNotEmpty(fields)) {
            String[] field = fields.split(",");
            fieldList = Arrays.asList(field);
            fieldList = fieldList.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        return fieldList;
    }

    public static DynamicObject dealReverse(DynamicObject payBill, Set<Long> draftIdSet) {
        DynamicObject newPayBill;
        block6: {
            int i;
            DynamicObjectCollection draftInfoEntrys;
            DynamicObjectCollection draftBills;
            block7: {
                Object[] draftBillsDb;
                Set payBillDraftIdSet;
                newPayBill = (DynamicObject)OrmUtils.clone((Object)payBill, (IDataEntityType)payBill.getDataEntityType(), (boolean)true, (boolean)true);
                newPayBill.set("actpayamt", (Object)newPayBill.getBigDecimal("actpayamt").negate());
                newPayBill.set("fee", (Object)newPayBill.getBigDecimal("fee").negate());
                newPayBill.set("localamt", (Object)newPayBill.getBigDecimal("localamt").negate());
                newPayBill.set("dpamt", (Object)newPayBill.getBigDecimal("dpamt").negate());
                newPayBill.set("dplocalamt", (Object)newPayBill.getBigDecimal("dplocalamt").negate());
                newPayBill.set("billstatus", (Object)"A");
                newPayBill.set("expectdate", null);
                newPayBill.set("bizdate", (Object)new Date());
                newPayBill.set("description", (Object)String.format(ResManager.loadKDString((String)"\u3010\u7968\u636e\u9000\u7968\u3011%s", (String)"CasHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]), newPayBill.getString("description")));
                String generateNumber = CodeRuleHelper.generateNumber("cas_paybill", newPayBill, null, null);
                if (StringUtils.isEmpty((CharSequence)generateNumber)) {
                    generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                }
                if (!(payBillDraftIdSet = (draftBills = newPayBill.getDynamicObjectCollection("draftbill")).stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet())).containsAll(draftIdSet) && EmptyUtil.isNoEmpty((Object[])(draftBillsDb = BusinessDataServiceHelper.load((Object[])draftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))))) {
                    draftBills.clear();
                    for (Object draftBill : draftBillsDb) {
                        DynamicObject dynamicObject = draftBills.addNew();
                        dynamicObject.set("fbasedataid", draftBill);
                        dynamicObject.set("fbasedataid_id", draftBill.getPkValue());
                    }
                }
                newPayBill.set("billno", (Object)generateNumber);
                newPayBill.set("isvoucher", null);
                newPayBill.set("auditor", null);
                newPayBill.set("auditdate", null);
                newPayBill.set("cashier", null);
                newPayBill.set("paydate", null);
                newPayBill.set("sourcetype", (Object)"CDM");
                newPayBill.set("entrance", null);
                DynamicObjectCollection entrys = newPayBill.getDynamicObjectCollection("entry");
                entrys.forEach(entry -> {
                    entry.set("e_payableamt", (Object)entry.getBigDecimal("e_payableamt").negate());
                    entry.set("e_payablelocamt", (Object)entry.getBigDecimal("e_payablelocamt").negate());
                    entry.set("e_unsettledlocalamt", (Object)entry.getBigDecimal("e_unsettledlocalamt").negate());
                    entry.set("e_discountamt", (Object)entry.getBigDecimal("e_discountamt").negate());
                    entry.set("e_discountlocamt", (Object)entry.getBigDecimal("e_discountlocamt").negate());
                    entry.set("e_actamt", (Object)entry.getBigDecimal("e_actamt").negate());
                    entry.set("e_localamt", (Object)entry.getBigDecimal("e_localamt").negate());
                    entry.set("e_lockamt", (Object)entry.getBigDecimal("e_lockamt").negate());
                    entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_unlockamt").negate());
                    entry.set("e_settledamt", (Object)BigDecimal.ZERO);
                    entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableamt"));
                    entry.set("e_sourcebillid", (Object)0);
                    entry.set("e_sourcebillentryid", (Object)0);
                    entry.set("e_scheid", (Object)0);
                    DynamicObjectCollection entry_lk = entry.getDynamicObjectCollection("entry_lk");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entry_lk)) {
                        entry_lk.clear();
                    }
                });
                draftInfoEntrys = newPayBill.getDynamicObjectCollection("cas_draftinfo");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfoEntrys)) break block6;
                List otherDraftList = draftInfoEntrys.stream().filter(e -> !draftIdSet.contains(e.getDynamicObject("draftbillinfo").getLong("id"))).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(otherDraftList)) {
                    draftInfoEntrys.removeAll(otherDraftList);
                }
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfoEntrys)) break block7;
                for (i = 0; i < draftInfoEntrys.size(); ++i) {
                    DynamicObject draftInfoEntry = (DynamicObject)draftInfoEntrys.get(i);
                    draftInfoEntry.set("draftbilllogid", (Object)0L);
                    draftInfoEntry.set("srcbillid", (Object)0L);
                    draftInfoEntry.set("srcbillid", (Object)0L);
                    draftInfoEntry.set("srcbillindex", (Object)(i + 1));
                }
                break block6;
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBills)) break block6;
            for (i = 0; i < draftBills.size(); ++i) {
                DynamicObject newDraft = (DynamicObject)draftBills.get(i);
                DynamicObject fbasedataid = newDraft.getDynamicObject("fbasedataid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                DynamicObject cas_draftinfo = draftInfoEntrys.addNew();
                cas_draftinfo.set("transamount", (Object)fbasedataid.getBigDecimal("amount"));
                cas_draftinfo.set("paybillcurrency", (Object)fbasedataid.getDynamicObject("currency").getLong("id"));
                cas_draftinfo.set("draftbillinfo", (Object)fbasedataid);
                cas_draftinfo.set("srcbillindex", (Object)(i + 1));
            }
        }
        return newPayBill;
    }

    public static void addCasDraftInfoEntry(DynamicObjectCollection draftInfoEntries, DynamicObject ... draftBills) {
        if (draftInfoEntries == null || EmptyUtil.isEmpty((Object[])draftBills)) {
            return;
        }
        Set draftIdSet = draftInfoEntries.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getPkValue()).collect(Collectors.toSet());
        for (DynamicObject draftBill : draftBills) {
            if (draftIdSet.contains(draftBill.getPkValue())) continue;
            DynamicObject cas_draftinfo = draftInfoEntries.addNew();
            cas_draftinfo.set("transamount", (Object)draftBill.getBigDecimal("amount"));
            cas_draftinfo.set("paybillcurrency", (Object)draftBill.getDynamicObject("currency").getLong("id"));
            cas_draftinfo.set("draftbillinfo", (Object)draftBill);
        }
    }

    public static void addCasRecDraftInfoEntry(DynamicObjectCollection draftInfoEntries, DynamicObject ... draftBills) {
        if (draftInfoEntries == null || EmptyUtil.isEmpty((Object[])draftBills)) {
            return;
        }
        Set draftIdSet = draftInfoEntries.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getPkValue()).collect(Collectors.toSet());
        for (DynamicObject draftBill : draftBills) {
            if (draftIdSet.contains(draftBill.getPkValue())) continue;
            DynamicObject cas_draftinfo = draftInfoEntries.addNew();
            cas_draftinfo.set("transamount", (Object)draftBill.getBigDecimal("amount"));
            cas_draftinfo.set("recbillcurrency", (Object)draftBill.getDynamicObject("currency"));
            cas_draftinfo.set("draftbillinfo", (Object)draftBill);
        }
    }

    public static void removePayApplyCasDraftInfo(DynamicObject draftBill, DynamicObject payBill) {
        DynamicObjectCollection cas_payinfo;
        DynamicObject payapplyBill;
        String sourcebilltype = payBill.getString("sourcebilltype");
        long sourcebillid = payBill.getLong("sourcebillid");
        if ("cas_payapplybill".equals(sourcebilltype) && EmptyUtil.isNoEmpty((Long)sourcebillid) && EmptyUtil.isNoEmpty((DynamicObject)(payapplyBill = TmcDataServiceHelper.loadSingle((String)"cas_payapplybill", (String)"id,cas_payinfo,entry_settletnumber,entry_draftbill,cas_draftinfo,draftbillinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)}))) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(cas_payinfo = payapplyBill.getDynamicObjectCollection("cas_payinfo")))) {
            for (DynamicObject payInfo : cas_payinfo) {
                String entry_settletnumber = payInfo.getString("entry_settletnumber");
                String draftbillno = draftBill.getString("draftbillno");
                if (!EmptyUtil.isNoEmpty((String)entry_settletnumber) || !entry_settletnumber.equals(draftbillno)) continue;
                payInfo.set("entry_settletnumber", null);
                payInfo.set("entry_draftbill", null);
            }
            DynamicObjectCollection cas_draftinfo = payapplyBill.getDynamicObjectCollection("cas_draftinfo");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftinfo)) {
                cas_draftinfo.removeIf(draftInfo -> draftBill.getPkValue().equals(draftInfo.getDynamicObject("draftbillinfo").getPkValue()));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payapplyBill});
        }
    }

    public static String subString(String str, int maxLength) {
        return CasHelper.subString(str, maxLength, DELIMITERS);
    }

    public static String subString(String str, int maxLength, String ... delimiters) {
        if (StringUtils.isBlank((CharSequence)str) || str.length() <= maxLength) {
            return str;
        }
        for (String delimiter : delimiters) {
            String[] split = str.split(delimiter);
            if (split.length == 1) continue;
            StringBuilder sb = new StringBuilder();
            for (String sn : split) {
                if (sb.length() + sn.length() > maxLength) {
                    sb.delete(sb.length() - delimiter.length(), sb.length());
                    return sb.toString();
                }
                sb.append(sn).append(delimiter);
            }
        }
        return str.substring(0, maxLength);
    }
}

