/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.Date;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.ObjectUtils;

public class CdmCommonHelper {
    public static void showWebBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get("formId");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        if (null != paramMap.get("pkValue")) {
            showParameter.setPkId(paramMap.get("pkValue"));
            showParameter.setStatusValue(OperationStatus.VIEW.getValue());
        }
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get("showType"), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        CdmCommonHelper.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    private static void openPage(FormShowParameter showParameter, Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get("formName") != null) {
            showParameter.setCaption((String)paramMap.get("formName"));
        }
        Boolean needCallBack = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get("needCallBack"), (Object)Boolean.FALSE);
        String formId = (String)paramMap.get("formId");
        if (needCallBack.booleanValue()) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, formId));
        }
        if (paramMap.get("customParam") != null) {
            Map customParam = (Map)paramMap.get("customParam");
            showParameter.getCustomParams().putAll(customParam);
        }
        formPlugin.getView().showForm(showParameter);
    }

    public static boolean needToReloadPageData(DynamicObject dataEntity, String entityName) {
        Date lastModifyTime = dataEntity.getDate("modifytime");
        Object id = dataEntity.getPkValue();
        if (EmptyUtil.isNoEmpty((Object)lastModifyTime) && EmptyUtil.isNoEmpty((Object)id) && dataEntity.getDataEntityState().getFromDatabase()) {
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)"modifytime,createtime");
            Date newModifyTime = EmptyUtil.isNoEmpty((Object)data.getDate("modifytime")) ? data.getDate("modifytime") : data.getDate("createtime");
            return newModifyTime.compareTo(lastModifyTime) != 0;
        }
        return false;
    }
}

