/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EleDraftHelper {
    private static final Log logger = LogFactory.getLog(EleDraftHelper.class);

    public static String tranSubRangeStyle(String subRange) {
        if (StringUtils.isNotEmpty((String)subRange) && subRange.contains(",")) {
            if (subRange.length() < 12) {
                return "0";
            }
            String[] subRangeArr = subRange.split(",");
            long subBillStartFlag = Long.parseLong(subRangeArr[0]);
            long subBillEndFlag = Long.parseLong(subRangeArr[1]);
            return subBillStartFlag + "-" + subBillEndFlag;
        }
        return "0";
    }

    public static String tranSubRangeStartNo(String subRange) {
        if (StringUtils.isNotEmpty((String)subRange) && subRange.contains("-")) {
            String[] subRangeArr = subRange.split("-");
            long subBillStartFlag = Long.parseLong(subRangeArr[0]);
            return String.format("%012d", subBillStartFlag);
        }
        return "0";
    }

    public static String tranSubRangeEndNo(String subRange) {
        if (StringUtils.isNotEmpty((String)subRange) && subRange.contains("-")) {
            String[] subRangeArr = subRange.split("-");
            long subBillEndFlag = Long.parseLong(subRangeArr[1]);
            return String.format("%012d", subBillEndFlag);
        }
        return "0";
    }

    public static String tranSubRangeToYQ(String subRange) {
        if (StringUtils.isNotEmpty((String)subRange) && subRange.contains("-")) {
            String[] subRangeArr = subRange.split("-");
            long subBillStartFlag = Long.parseLong(subRangeArr[0]);
            long subBillEndFlag = Long.parseLong(subRangeArr[1]);
            return String.format("%012d", subBillStartFlag) + "," + String.format("%012d", subBillEndFlag);
        }
        return "";
    }

    public static Pair<Long, Long> tranSubRangeToLeftRight(String subRange) {
        if (StringUtils.isNotEmpty((String)subRange) && subRange.contains("-")) {
            String[] subRangeArr = subRange.split("-");
            long subBillStartFlag = Long.parseLong(subRangeArr[0]);
            long subBillEndFlag = Long.parseLong(subRangeArr[1]);
            return Pair.of((Object)subBillStartFlag, (Object)subBillEndFlag);
        }
        return null;
    }

    public static String isNewECDs(String noteStatus, String subRange) {
        return StringUtils.isNotEmpty((String)noteStatus) ? EleDraftIsNewECDS.NEW.getValue() : EleDraftIsNewECDS.OLD.getValue();
    }

    public static void splitBill(DynamicObject eleRecBill) {
        BigDecimal amount = eleRecBill.getBigDecimal("amount");
        BigDecimal locAmt = eleRecBill.getBigDecimal("locamt");
        String ebStatus = eleRecBill.getString("ebstatus");
        String usedEleBill = eleRecBill.getString("subrange");
        String initSubRange = eleRecBill.getString("initsubrange");
        logger.info("EleDraftHelper.splitBill eleRecBill billNo = {}, amount = {},locAmt = {},ebStatus = {}", new Object[]{eleRecBill.getString("billno"), amount, locAmt, ebStatus});
        if (locAmt != null && amount.compareTo(locAmt) != 0 && (EbStatus.BANK_SUCCESS.getName().equals(ebStatus) || EbStatus.BANK_FAIL.getName().equals(ebStatus)) && !usedEleBill.equals(initSubRange)) {
            Pair<Long, Long> rangeLong;
            String startFlag = String.valueOf(Long.parseLong(usedEleBill.substring(0, usedEleBill.indexOf("-"))) + locAmt.multiply(BigDecimal.valueOf(100L)).longValue());
            String endFlag = initSubRange.substring(initSubRange.indexOf("-") + 1);
            String subEleBill = startFlag + "-" + endFlag;
            logger.info("EleDraftHelper.splitBill eleRecBill subEleBill = {}", (Object)subEleBill);
            eleRecBill.set("subrange", (Object)subEleBill);
            if (subEleBill.length() > 1 && (rangeLong = EleDraftHelper.tranSubRangeToLeftRight(subEleBill)) != null) {
                long subBillStartFlag = (Long)rangeLong.getLeft();
                long subBillEndFlag = (Long)rangeLong.getRight();
                BigDecimal splitAmount = BigDecimal.valueOf((double)(subBillEndFlag - subBillStartFlag + 1L) * 0.01);
                eleRecBill.set("amount", (Object)splitAmount);
                logger.info("EleDraftHelper.splitBill eleRecBill splitAmount = {}", (Object)splitAmount);
                BigDecimal usedAmount = eleRecBill.getBigDecimal("usedamount");
                eleRecBill.set("usedamount", (Object)usedAmount.add(locAmt));
            }
        }
    }

    public static DynamicObject findBeBankByUnionNumber(String unionNumber) {
        QFilter unionNumberQFilter = new QFilter("union_number", "=", (Object)unionNumber);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{unionNumberQFilter});
        if (load.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load[0].getPkValue(), (String)"bd_bebank");
        }
        return null;
    }

    public static DynamicObject findBeBankByName(String bankName) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)bankName);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{nameQFilter});
        if (load.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load[0].getPkValue(), (String)"bd_bebank");
        }
        return null;
    }

    public static DynamicObject findBeBankByNameAndNo(String bankName, String bankNo) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)bankName);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{nameQFilter});
        if (load.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load[0].getPkValue(), (String)"bd_bebank");
        }
        QFilter noQFilter = new QFilter("union_number", "=", (Object)bankNo);
        DynamicObject[] load2 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{noQFilter});
        if (load2.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load2[0].getPkValue(), (String)"bd_bebank");
        }
        return null;
    }
}

