/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.AcceptPromiseTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillHelp {
    public static Object getCompanyIdByRec(DynamicObject data) {
        String payeeType = data.getString("payeetype");
        DynamicObject receiverObj = data.getDynamicObject("receiver");
        if (EmptyUtil.isEmpty((DynamicObject)receiverObj)) {
            return null;
        }
        Object receiver = receiverObj.getPkValue();
        return PayableBillHelp.getCompany(payeeType, receiver);
    }

    public static Object getCompanyIdByBeen(DynamicObject data) {
        String payeeType = data.getString("payeetypetext");
        DynamicObject beenDorSorObj = data.getDynamicObject("beendorsor");
        if (EmptyUtil.isEmpty((DynamicObject)beenDorSorObj)) {
            return null;
        }
        Object beendorsor = beenDorSorObj.getPkValue();
        return PayableBillHelp.getCompany(payeeType, beendorsor);
    }

    public static Object getCompany(String payeeType, Object receiver) {
        Object companyId = null;
        if (AcceptPromiseTypeEnum.BD_SUPPLIER.getValue().equals(payeeType)) {
            DynamicObject supplierDO = BusinessDataServiceHelper.loadSingle((Object)receiver, (String)AcceptPromiseTypeEnum.BD_SUPPLIER.getValue());
            DynamicObject internal_company = supplierDO.getDynamicObject("internal_company");
            if (CasHelper.isEmpty(internal_company)) {
                return null;
            }
            companyId = internal_company.getPkValue();
        } else if (AcceptPromiseTypeEnum.BD_CUSTOMER.getValue().equals(payeeType)) {
            DynamicObject customerDO = BusinessDataServiceHelper.loadSingle((Object)receiver, (String)AcceptPromiseTypeEnum.BD_CUSTOMER.getValue());
            DynamicObject internal_company = customerDO.getDynamicObject("internal_company");
            if (CasHelper.isEmpty(internal_company)) {
                return null;
            }
            companyId = internal_company.getPkValue();
        } else if (AcceptPromiseTypeEnum.BOS_ORG.getValue().equals(payeeType)) {
            companyId = receiver;
        } else {
            return null;
        }
        return companyId;
    }

    public static boolean isCheckOrPromissoryBillType(DynamicObject draftBillType) {
        String settlementType = draftBillType != null ? draftBillType.getString("settlementtype") : "";
        return StringUtils.equals((CharSequence)SettleMentTypeEnum.PROMISSORY.getValue(), (CharSequence)settlementType) || StringUtils.equals((CharSequence)SettleMentTypeEnum.CHECK.getValue(), (CharSequence)settlementType);
    }
}

