/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecClaimRuleHelper {
    private static final Log LOGGER = LogFactory.getLog(RecClaimRuleHelper.class);

    public static DynamicObject getClaimInfoByMatchRule(Long sourcebillid, String handleScheme) {
        DynamicObject rule;
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        QFilter filter = new QFilter("id", "=", (Object)sourcebillid);
        DynamicObject matchingRule = null;
        DynamicObject[] cdmRecBill = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,company", (QFilter[])new QFilter[]{filter});
        if (!CasHelper.isEmpty(cdmRecBill) && (matchingRule = RecClaimRuleHelper.getMatchingRule(cdmRecBill[0], handleScheme)) == null) {
            LOGGER.info("matchingRule is null");
            return null;
        }
        DynamicObjectCollection detailAllDys = RecClaimRuleHelper.getBankDetailDy(matchingRule, fldProperties, new QFilter[]{filter});
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)detailAllDys) && (rule = RecClaimRuleHelper.getMatchingRule((DynamicObject)detailAllDys.get(0), handleScheme)) != null && !CasHelper.isEmpty(rule)) {
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("rule_entity");
            List<Object> entryEntity = new ArrayList(entryentity);
            if (StringUtils.isNotEmpty((CharSequence)handleScheme)) {
                entryEntity = entryEntity.stream().filter(o -> handleScheme.equals(o.getString("e_handlescheme"))).collect(Collectors.toList());
            }
            if (!EmptyUtil.isEmpty(entryEntity)) {
                for (DynamicObject entryrule : entryEntity) {
                    if (!RecClaimRuleHelper.isMatchRule(entryrule, (DynamicObject)detailAllDys.get(0), fldProperties)) continue;
                    return entryrule;
                }
            }
        }
        return null;
    }

    private static DynamicObjectCollection getBankDetailDy(DynamicObject matchingRule, Map<String, DynamicProperty> fldProperties, QFilter[] filters) {
        if (null == matchingRule) {
            return null;
        }
        DynamicObjectCollection entryentity = matchingRule.getDynamicObjectCollection("rule_entity");
        HashSet<String> ruleFieldSet = new HashSet<String>(8);
        ruleFieldSet.add("company.id");
        ruleFieldSet.add("id");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)entryentity)) {
            for (int i = 0; i < entryentity.size(); ++i) {
                Iterator filterObj;
                FilterCondition filterCondition;
                DynamicObject entryrule = (DynamicObject)entryentity.get(i);
                String filterStr = entryrule.getString("e_datafilter_TAG");
                if (CasHelper.isEmpty(filterStr) || !EmptyUtil.isNoEmpty((Object)(filterCondition = (filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class)).getFilterCondition()))) continue;
                List filterRows = filterCondition.getFilterRow();
                for (SimpleFilterRow filterRow : filterRows) {
                    ruleFieldSet.add(filterRow.getFieldName());
                }
            }
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        boolean isOk = selProps.retainAll(ruleFieldSet);
        String selectString = StringUtils.join((Object[])selProps.toArray(new Object[selProps.size()]), (String)",");
        LOGGER.info("selectString is:" + selectString);
        DynamicObjectCollection rows = null;
        DataSet dsn = QueryServiceHelper.queryDataSet((String)RecClaimRuleHelper.class.getName(), (String)"cdm_receivablebill", (String)selectString, (QFilter[])filters, null);
        Object object = null;
        try {
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dsn != null) {
                if (object != null) {
                    try {
                        dsn.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dsn.close();
                }
            }
        }
        if (rows != null && rows.size() > 0) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (String prop : selProps) {
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        int rowsize = rows == null ? 0 : rows.size();
        LOGGER.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u5e94\u6536\u7968\u636e\u6570\u91cf\u4e3a: " + rowsize + "");
        return rows;
    }

    public static Map<Long, List<DynamicObject>> getBankDetailDyBatch(Map<Long, DynamicObject> matchingRuleMap, Map<String, DynamicProperty> fldProperties, QFilter[] filters) {
        Map<Long, List<DynamicObject>> orgIdAndBillListMap = new HashMap<Long, List<DynamicObject>>();
        if (EmptyUtil.isEmpty(matchingRuleMap) || matchingRuleMap.size() == 0) {
            return orgIdAndBillListMap;
        }
        HashSet<String> ruleFieldSet = new HashSet<String>(8);
        for (Map.Entry<Long, DynamicObject> entry : matchingRuleMap.entrySet()) {
            DynamicObject matchingRule = entry.getValue();
            DynamicObjectCollection entryentity = matchingRule.getDynamicObjectCollection("rule_entity");
            ruleFieldSet.add("company.id");
            ruleFieldSet.add("id");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entryentity)) continue;
            for (int i = 0; i < entryentity.size(); ++i) {
                CRCondition filterObj;
                Iterator filterCondition;
                DynamicObject entryrule = (DynamicObject)entryentity.get(i);
                String filterStr = entryrule.getString("e_datafilter_TAG");
                if (CasHelper.isEmpty(filterStr) || !EmptyUtil.isNoEmpty((Object)(filterCondition = (filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class)).getFilterCondition()))) continue;
                List filterRows = filterCondition.getFilterRow();
                for (SimpleFilterRow filterRow : filterRows) {
                    ruleFieldSet.add(filterRow.getFieldName());
                }
            }
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        boolean isOk = selProps.retainAll(ruleFieldSet);
        String selectString = StringUtils.join((Object[])selProps.toArray(new Object[selProps.size()]), (String)",");
        LOGGER.info("selectString is:" + selectString);
        DynamicObjectCollection rows = new DynamicObjectCollection();
        DataSet dsn = QueryServiceHelper.queryDataSet((String)RecClaimRuleHelper.class.getName(), (String)"cdm_receivablebill", (String)selectString, (QFilter[])filters, null);
        Object object = null;
        try {
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Throwable filterCondition) {
            object = filterCondition;
            throw filterCondition;
        }
        finally {
            if (dsn != null) {
                if (object != null) {
                    try {
                        dsn.close();
                    }
                    catch (Throwable filterCondition) {
                        ((Throwable)object).addSuppressed(filterCondition);
                    }
                } else {
                    dsn.close();
                }
            }
        }
        if (null != rows && rows.size() > 0) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (String prop : selProps) {
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        int rowsize = rows == null ? 0 : rows.size();
        LOGGER.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u5e94\u6536\u7968\u636e\u6570\u91cf\u4e3a: " + rowsize + "");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rows)) {
            orgIdAndBillListMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("company.id")));
        }
        return orgIdAndBillListMap;
    }

    private static boolean isMatchRule(DynamicObject entryrule, DynamicObject detailDy, Map<String, DynamicProperty> fldProperties) {
        boolean isMatchRule = false;
        String filterStr = entryrule.getString("e_datafilter_TAG");
        if (!CasHelper.isEmpty(filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                    if (baseBoolean.booleanValue()) {
                        isMatchRule = true;
                    }
                }
                catch (Exception ee) {
                    LOGGER.error((Throwable)ee);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    public static Map<Long, DynamicObject> isMatchRuleBatch(Map<Long, DynamicObject> companyIdAndRuleMap, Set<Long> unnoticeIdSet, String handleScheme) {
        HashMap<Long, DynamicObject> billIdAndMatchMap = new HashMap<Long, DynamicObject>(8);
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        if (EmptyUtil.isNoEmpty(companyIdAndRuleMap) && companyIdAndRuleMap.size() > 0) {
            Map<Long, List<DynamicObject>> billIdAnBillMap = RecClaimRuleHelper.getBankDetailDyBatch(companyIdAndRuleMap, fldProperties, new QFilter[]{new QFilter("id", "in", unnoticeIdSet)});
            block0: for (Map.Entry<Long, DynamicObject> entry : companyIdAndRuleMap.entrySet()) {
                DynamicObject rule = entry.getValue();
                List<DynamicObject> detailDys = billIdAnBillMap.get(entry.getKey());
                if (rule == null || CasHelper.isEmpty(rule)) continue;
                int batchBillSize = detailDys.size();
                DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("rule_entity");
                List<Object> entryEntity = new ArrayList(entryentity);
                if (StringUtils.isNotEmpty((CharSequence)handleScheme)) {
                    entryEntity = entryEntity.stream().filter(o -> handleScheme.equals(o.getString("e_handlescheme"))).collect(Collectors.toList());
                }
                if (EmptyUtil.isEmpty(entryEntity)) continue;
                for (DynamicObject entryrule : entryEntity) {
                    int entryMatcSsize;
                    Map<Long, DynamicObject> billIdAndMatchMapByEntry = RecClaimRuleHelper.getMatchMap(entryrule, detailDys, fldProperties);
                    if (EmptyUtil.isNoEmpty(billIdAndMatchMapByEntry) && billIdAndMatchMapByEntry.size() > 0) {
                        billIdAndMatchMap.putAll(billIdAndMatchMapByEntry);
                    }
                    if (batchBillSize != (entryMatcSsize = billIdAndMatchMapByEntry.size())) continue;
                    continue block0;
                }
            }
        }
        return billIdAndMatchMap;
    }

    public static Map<Long, DynamicObject> getMatchMap(DynamicObject entryrule, List<DynamicObject> detailDys, Map<String, DynamicProperty> fldProperties) {
        boolean isMatchRule = false;
        HashMap<Long, DynamicObject> billIdAndMatchMap = new HashMap<Long, DynamicObject>(6);
        String filterStr = entryrule.getString("e_datafilter_TAG");
        if (!CasHelper.isEmpty(filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    for (DynamicObject detailDy : detailDys) {
                        Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                        if (!baseBoolean.booleanValue()) continue;
                        billIdAndMatchMap.put(detailDy.getLong("id"), entryrule);
                    }
                }
                catch (Exception ee) {
                    LOGGER.error("getMatchMap has error:", (Throwable)ee);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        if (isMatchRule) {
            for (DynamicObject detailDy : detailDys) {
                billIdAndMatchMap.put(detailDy.getLong("id"), entryrule);
            }
        }
        return billIdAndMatchMap;
    }

    private static DynamicObject getMatchingRule(DynamicObject detailAllDys, String handleScheme) {
        QFilter ruleCommonFilter = RecClaimRuleHelper.getRuleCommonFilter(detailAllDys, handleScheme, false);
        String properties = "org_entry.u_org,rule_entity.e_datafilter_TAG,rule_entity.e_savenotifi_TAG,rule_entity.e_handlescheme,rule_entity.e_rulesname,rule_entity.e_noticegroup";
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"cdm_recbill_noticerule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
        if (rules.length == 0) {
            ruleCommonFilter = RecClaimRuleHelper.getRuleCommonFilter(detailAllDys, handleScheme, true);
            rules = BusinessDataServiceHelper.load((String)"cdm_recbill_noticerule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
        }
        if (rules.length == 0) {
            return null;
        }
        return rules[0];
    }

    public static Map<Long, DynamicObject> getMatchingRuleBatch(Set<Long> billCompanyIDdSet, String handleScheme) {
        HashMap<Long, DynamicObject> companyIdAndRuleMap;
        block7: {
            Object[] rules;
            String properties;
            QFilter ruleCommonFilter;
            block6: {
                companyIdAndRuleMap = new HashMap<Long, DynamicObject>(8);
                ruleCommonFilter = RecClaimRuleHelper.getRuleCommonFilterBatch(billCompanyIDdSet, handleScheme, false);
                properties = "org_entry.u_org,rule_entity.e_datafilter_TAG,rule_entity.e_savenotifi_TAG,rule_entity.e_handlescheme,rule_entity.e_rulesname,rule_entity.e_noticegroup";
                rules = BusinessDataServiceHelper.load((String)"cdm_recbill_noticerule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
                if (rules.length != 0) break block6;
                ruleCommonFilter = RecClaimRuleHelper.getRuleCommonFilterBatch(billCompanyIDdSet, handleScheme, true);
                rules = BusinessDataServiceHelper.load((String)"cdm_recbill_noticerule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
                if (!EmptyUtil.isNoEmpty((Object[])rules)) break block7;
                for (Long companyId : billCompanyIDdSet) {
                    companyIdAndRuleMap.put(companyId, (DynamicObject)rules[0]);
                }
                break block7;
            }
            HashSet<Long> entryOrgIdSet = new HashSet<Long>(6);
            for (Object rule : rules) {
                DynamicObjectCollection org_entry = rule.getDynamicObjectCollection("org_entry");
                for (DynamicObject entry : org_entry) {
                    long orgId = entry.getDynamicObject("u_org").getLong("id");
                    if (!billCompanyIDdSet.contains(orgId)) continue;
                    companyIdAndRuleMap.put(orgId, (DynamicObject)rule);
                    entryOrgIdSet.add(orgId);
                }
            }
            if (!entryOrgIdSet.containsAll(billCompanyIDdSet)) {
                billCompanyIDdSet.retainAll(entryOrgIdSet);
                ruleCommonFilter = RecClaimRuleHelper.getRuleCommonFilterBatch(billCompanyIDdSet, handleScheme, true);
                Object[] rulesNoOrg = BusinessDataServiceHelper.load((String)"cdm_recbill_noticerule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
                if (EmptyUtil.isNoEmpty((Object[])rulesNoOrg)) {
                    Object rule = rulesNoOrg[0];
                    for (Long companyId : entryOrgIdSet) {
                        if (!billCompanyIDdSet.contains(companyId)) continue;
                        companyIdAndRuleMap.put(companyId, (DynamicObject)rule);
                    }
                }
            }
        }
        return companyIdAndRuleMap;
    }

    private static QFilter getRuleCommonFilter(DynamicObject detailDy, String handleScheme, Boolean isFaceAllOrg) {
        Object company = detailDy.get("company.id");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.isNotEmpty((CharSequence)handleScheme)) {
            filter.and(new QFilter("rule_entity.e_handlescheme", "=", (Object)handleScheme));
        }
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", company));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org"));
        }
        return filter;
    }

    private static QFilter getRuleCommonFilterBatch(Set<Long> billCompanyIdSet, String handleScheme, Boolean isFaceAllOrg) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.isNotEmpty((CharSequence)handleScheme)) {
            filter.and(new QFilter("rule_entity.e_handlescheme", "=", (Object)handleScheme));
        }
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "in", billCompanyIdSet));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org"));
        }
        return filter;
    }
}

