/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReturnNoteSetHelper {
    private static final Log logger = LogFactory.getLog(ReturnNoteSetHelper.class);

    public static boolean isReturnNote(DynamicObject company, DynamicObject electronicBill) {
        try {
            long eleDraftId = electronicBill.getLong("id");
            String signCompanyName = company.getString("name");
            String issueTicketName = electronicBill.getString("issueticketertext");
            DynamicObjectCollection entryEntity = electronicBill.getDynamicObjectCollection("entryentity");
            logger.info("ReturnNoteSetHelper entryEntity.size:" + entryEntity.size() + "id is " + eleDraftId + "billno is:" + electronicBill.getString("billno"));
            if (entryEntity.size() == 0) {
                if (signCompanyName.equals(issueTicketName)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            List businessCodeList = entryEntity.stream().filter(o -> "02".equals(o.getString("businesscode")) || "03".equals(o.getString("businesscode"))).collect(Collectors.toList());
            if (entryEntity.size() == businessCodeList.size()) {
                return Boolean.FALSE;
            }
            HashSet<String> endorseeSet = new HashSet<String>();
            HashSet<String> repeatSet = new HashSet<String>();
            Object[] returnnotesets = BusinessDataServiceHelper.load((String)"cdm_returnnoteset", (String)"id,isrepeatreturn,excepcompany,excependorsereqendor,excependoriscop,", null);
            endorseeSet.add(issueTicketName);
            String collectionName = electronicBill.getString("collectionertext");
            endorseeSet.add(collectionName);
            String promiseName = electronicBill.getString("promisertext");
            String preHolderName = electronicBill.getString("preholdername");
            String tickStatus = electronicBill.getString("ticketstatus");
            String noteStatus = electronicBill.getString("notestatus");
            if (EleDraftBillStatusEnum.ACCEPTANCE.getValue().equals(tickStatus) || EleDraftBillStatusEnum.INVOICE.getValue().equals(tickStatus) || EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) || EleDraftNoteStatusEnum.CS02.getValue().equals(noteStatus)) {
                logger.info("ReturnNoteSetHelper is not match status");
                return false;
            }
            boolean isSamePreHolder = entryEntity.stream().filter(e -> !"02".equals(e.getString("businesscode")) && !"03".equals(e.getString("businesscode"))).anyMatch(o -> o.getString("endorser").equals(signCompanyName));
            boolean isReturndate = signCompanyName.equals(issueTicketName) || signCompanyName.equals(collectionName) || isSamePreHolder;
            boolean isRepeatReturn = returnnotesets[0].getBoolean("isrepeatreturn");
            logger.info("isRepeatReturn is that:" + isRepeatReturn + ",isReturndate :" + isReturndate + ",signCompanyName :" + signCompanyName);
            if (!isReturndate && !isRepeatReturn) {
                return Boolean.FALSE;
            }
            if (isReturndate && !isRepeatReturn) {
                return Boolean.TRUE;
            }
            boolean isReturnDraft = false;
            if (isRepeatReturn) {
                boolean isIntoMatchRepeat = false;
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && EmptyUtil.isNoEmpty((Object[])returnnotesets) && isRepeatReturn) {
                    List endorseList = entryEntity.stream().filter(e -> !"02".equals(e.getString("businesscode")) && !"03".equals(e.getString("businesscode"))).collect(Collectors.toList());
                    Map<Object, Object> orgNameAndDyMap = new HashMap(16);
                    if (EmptyUtil.isNoEmpty(endorseList)) {
                        logger.info("endorseList is:" + endorseList.size());
                        for (DynamicObject endorseInfo : endorseList) {
                            String endorserStr = endorseInfo.getString("endorser");
                            String endorseeStr = endorseInfo.getString("endorsee");
                            repeatSet.add(endorserStr);
                            repeatSet.add(endorseeStr);
                        }
                        QFilter qFilter = new QFilter("name", "in", (Object)repeatSet.toArray(new String[0]));
                        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,name,fisbankroll,fisaccounting", (QFilter[])new QFilter[]{qFilter});
                        orgNameAndDyMap = orgs.stream().collect(Collectors.groupingBy(e -> e.getString("name")));
                    }
                    boolean isExcepEndorserEqendor = returnnotesets[0].getBoolean("excependorsereqendor");
                    boolean isExcependoriscop = returnnotesets[0].getBoolean("excependoriscop");
                    boolean isExcepcompany = returnnotesets[0].getBoolean("excepcompany");
                    logger.info("isExcepEndorserEqendor is:" + isExcepEndorserEqendor + ",isExcependoriscop:" + isExcependoriscop + ",isExcepcompany:" + isExcepcompany + "\uff0cendorseeSet is:" + SerializationUtils.toJsonString(endorseeSet));
                    int size = endorseList.size();
                    for (int i = 0; i < size; ++i) {
                        DynamicObject entry = (DynamicObject)endorseList.get(i);
                        String endorser = entry.getString("endorser");
                        String endorsee = entry.getString("endorsee");
                        logger.info("endorser is:" + endorser + ",endorsee:" + endorsee + ",collectionName:" + collectionName + ",i:" + i);
                        if (endorseeSet.contains(endorser)) {
                            List preHolderList;
                            if (i == size - 1 && collectionName.equals(endorser) && !endorser.equals(endorsee)) continue;
                            isIntoMatchRepeat = true;
                            boolean isSameEndorse = endorser.equals(endorsee);
                            logger.info("isSameEndorse is:" + isSameEndorse);
                            if (isSameEndorse && isExcepEndorserEqendor) continue;
                            List endorseeList = (List)orgNameAndDyMap.get(endorsee);
                            if (EmptyUtil.isNoEmpty((Object)endorseeList)) {
                                DynamicObject endorseeDy = (DynamicObject)endorseeList.get(0);
                                boolean isBankroll = endorseeDy.getBoolean("fisbankroll");
                                boolean isAccounting = endorseeDy.getBoolean("fisaccounting");
                                logger.info("endorseeList is:" + endorseeList.size() + ",isBankroll:" + isBankroll + ",isAccounting:" + isAccounting + ",endorsee:" + endorsee);
                                if ((isBankroll || isAccounting) && isExcependoriscop) continue;
                            }
                            if (EmptyUtil.isNoEmpty((Object)(preHolderList = (List)orgNameAndDyMap.get(endorser)))) {
                                DynamicObject preHolderDy = (DynamicObject)preHolderList.get(0);
                                boolean isBankroll = preHolderDy.getBoolean("fisbankroll");
                                boolean isAccounting = preHolderDy.getBoolean("fisaccounting");
                                logger.info("preHolderList is:" + preHolderList.size() + ",isBankroll:" + isBankroll + ",isAccounting:" + isAccounting + ",endorser:" + endorser);
                                if ((isBankroll || isAccounting) && isExcepcompany) continue;
                            }
                            isReturnDraft = Boolean.TRUE;
                            logger.info("isReturnDraft is true:");
                            break;
                        }
                        int afterAdd = i + 1;
                        logger.info("afterAdd is:" + afterAdd + ", endorseList.size():" + endorseList.size());
                        if (afterAdd >= endorseList.size()) continue;
                        boolean isSkpi = false;
                        for (int j = afterAdd; j < endorseList.size(); ++j) {
                            List preHolderList;
                            DynamicObject endorseFromEntry = (DynamicObject)endorseList.get(j);
                            String endorserFromEntry = endorseFromEntry.getString("endorser");
                            String endorseeFromEntry = endorseFromEntry.getString("endorsee");
                            boolean isSamePreHolderByEntry = endorserFromEntry.equals(endorser);
                            logger.info("isSamePreHolderByEntry" + isSamePreHolderByEntry + ", j" + j);
                            if (!isSamePreHolderByEntry) continue;
                            isIntoMatchRepeat = true;
                            boolean isSameEndorse = endorseeFromEntry.equals(endorserFromEntry);
                            logger.info("isSameEndorse" + isSameEndorse + ", j" + j + ",endorseeFromEntry:" + endorseeFromEntry);
                            if (isSameEndorse && isExcepEndorserEqendor) continue;
                            List endorseeList = (List)orgNameAndDyMap.get(endorseeFromEntry);
                            if (EmptyUtil.isNoEmpty((Object)endorseeList)) {
                                DynamicObject endorseeDy = (DynamicObject)endorseeList.get(0);
                                boolean isBankroll = endorseeDy.getBoolean("fisbankroll");
                                boolean isAccounting = endorseeDy.getBoolean("fisaccounting");
                                logger.info("endorseeList is:" + endorseeList.size() + ",isBankroll:" + isBankroll + ",isAccounting:" + isAccounting + ",endorseeFromEntry:" + endorseeFromEntry);
                                if ((isBankroll || isAccounting) && isExcependoriscop) continue;
                            }
                            if (EmptyUtil.isNoEmpty((Object)(preHolderList = (List)orgNameAndDyMap.get(endorserFromEntry)))) {
                                DynamicObject preHolderDy = (DynamicObject)preHolderList.get(0);
                                boolean isBankroll = preHolderDy.getBoolean("fisbankroll");
                                boolean isAccounting = preHolderDy.getBoolean("fisaccounting");
                                logger.info("preHolderList is:" + preHolderList.size() + ",isBankroll:" + isBankroll + ",isAccounting:" + isAccounting + ",endorserFromEntry:" + endorserFromEntry);
                                if ((isBankroll || isAccounting) && isExcepcompany) continue;
                            }
                            isReturnDraft = Boolean.TRUE;
                            isSkpi = Boolean.TRUE;
                            logger.info("isReturnDraft is:" + isReturnDraft);
                            break;
                        }
                        if (isSkpi) break;
                    }
                }
                logger.info("isReturnDraft is:" + isReturnDraft + ",isIntoMatchRepeat:" + isIntoMatchRepeat);
                if (!isReturnDraft && !isIntoMatchRepeat) {
                    isReturnDraft = isReturndate;
                }
            }
            logger.info(" after isReturnDraft is:" + isReturnDraft);
            return isReturnDraft;
        }
        catch (Exception e2) {
            logger.error("ReturnNoteSetHelper.isReturnNote has exception:", (Throwable)e2);
            throw new KDBizException(e2.getMessage());
        }
    }
}

