/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.constant.TradeBillConst;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillChangeHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillHelper {
    private static final Log logger = LogFactory.getLog(TradeBillHelper.class);

    public static DynamicObject[] getDraftArrByTradeBillArr(DynamicObject[] tradeBillArr) {
        Object[] draftPkArr = Arrays.stream(tradeBillArr).map(o -> o.getDynamicObjectCollection("entrys")).flatMap(Collection::stream).map(o -> o.getDynamicObject("draftbill")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).distinct().toArray();
        DynamicObject[] draftArr = TmcDataServiceHelper.load((Object[])draftPkArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        return draftArr;
    }

    public static DynamicObject[] getDraftArrByTradeBillArr2(DynamicObject[] tradeBillArr) {
        Object[] draftPkArr = Arrays.stream(tradeBillArr).map(o -> o.getDynamicObjectCollection("entrys")).flatMap(Collection::stream).map(o -> o.getDynamicObject("draftbill")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).distinct().toArray();
        return TmcDataServiceHelper.load((Object[])draftPkArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
    }

    public static Map<Object, DynamicObject> getDraftId2TradeBillMap(DynamicObject[] tradeBillArr) {
        Map<Object, DynamicObject> draftId2TradeBillMap = Arrays.stream(tradeBillArr).map(o -> o.getDynamicObjectCollection("entrys").stream().collect(Collectors.toMap(t -> t.getDynamicObject("draftbill").getPkValue(), t -> o, (t1, t2) -> t1))).flatMap(o -> o.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
        return draftId2TradeBillMap;
    }

    public static Map<String, String> getDraftId2NameMap(DynamicObject[] tradeBillArr) {
        Map<String, String> draftId2NameMap = Arrays.stream(tradeBillArr).map(o -> o.getDynamicObjectCollection("entrys").stream().collect(Collectors.toMap(t -> t.getDynamicObject("draftbill").getString("id"), t -> t.getDynamicObject("draftbill").getString("billno"), (t1, t2) -> t1))).flatMap(o -> o.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o1));
        return draftId2NameMap;
    }

    public static Map<String, Set<String>> lockByBillId(DynamicObject[] dataEntities, String billType) {
        logger.info("lockByBillId is that:" + billType);
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        StringJoiner errorMsg = new StringJoiner(";");
        HashSet<String> requestIds = new HashSet<String>();
        HashSet<String> notNeedDealTradeBIllSet = new HashSet<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        Map<String, String> draftId2NameMap = TradeBillHelper.getDraftId2NameMap(dataEntities);
        HashMap<String, String> draftId2TradeIdMap = new HashMap<String, String>();
        HashMap tradeIdAndBillListMap = new HashMap(8);
        for (DynamicObject dynamicObject : dataEntities) {
            String tradeIdStr = dynamicObject.getString("id");
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entrys");
            HashSet<String> draftBillIdSet = new HashSet<String>();
            for (DynamicObject entry : entrys) {
                String draftBillId = entry.getDynamicObject("draftbill").getString("id");
                draftId2TradeIdMap.put(draftBillId, tradeIdStr);
                draftBillIdSet.add(draftBillId);
            }
            tradeIdAndBillListMap.put(tradeIdStr, draftBillIdSet);
        }
        ArrayList<String> billidsList = new ArrayList<String>(draftId2NameMap.keySet());
        try {
            logger.info("will lock bill is that:" + SerializationUtils.toJsonString(billidsList));
            Map lockResultMap = MutexServiceHelper.batchRequestWithLostTime(billidsList, (String)"tmc-cdm-business", (String)billType);
            for (Map.Entry entry : lockResultMap.entrySet()) {
                String key = (String)entry.getKey();
                if (Boolean.TRUE.equals(entry.getValue())) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (!requestFailIds.isEmpty()) {
                HashSet notNeedDealDraftIdSet = new HashSet();
                for (String requestFailId : requestFailIds) {
                    String willRemoveTradeBill = (String)draftId2TradeIdMap.get(requestFailId);
                    notNeedDealTradeBIllSet.add(willRemoveTradeBill);
                    notNeedDealDraftIdSet.addAll((Collection)tradeIdAndBillListMap.get(willRemoveTradeBill));
                    String billno = draftId2NameMap.get(requestFailId);
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u7968\u636e%s\u6b63\u5728\u6709\u5176\u4ed6\u4e1a\u52a1\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TradeBillHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]), billno));
                }
                logger.info("notNeedDealDraftIdSet before that:" + SerializationUtils.toJsonString(notNeedDealDraftIdSet));
                notNeedDealDraftIdSet.retainAll(requestIds);
                logger.info("notNeedDealDraftIdSet after that:" + SerializationUtils.toJsonString(notNeedDealDraftIdSet));
                if (EmptyUtil.isNoEmpty(notNeedDealDraftIdSet)) {
                    try {
                        logger.info("release notNeedDealDraftIdSet\uff1a" + SerializationUtils.toJsonString(notNeedDealDraftIdSet));
                        ArrayList arrayList = new ArrayList(notNeedDealDraftIdSet);
                        Map releaseResultMap = MutexServiceHelper.batchRelease(arrayList, (String)"tmc-cdm-business", (String)billType);
                        requestIds.removeAll(notNeedDealDraftIdSet);
                        logger.info("releaseResultMap is:", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
                    }
                    catch (Exception exception) {
                        logger.error("release eror is:", (Throwable)exception);
                        throw new KDBizException(ResManager.loadKDString((String)"\u91ca\u653e\u4e92\u65a5\u9501\u5931\u8d25\u3002", (String)"TradeBillHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    }
                }
            }
            resultMap.put("succLockSet", requestIds);
            resultMap.put("notNeedDealTradeBIllSet", notNeedDealTradeBIllSet);
        }
        catch (Exception e1) {
            logger.error("to get lock Exception is:", (Throwable)e1);
            errorMsg.add(ResManager.loadKDString((String)"\u5355\u636e\u52a0\u9501\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TradeBillHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            logger.info("release eror is that:" + errorMsg);
        }
        return resultMap;
    }

    public static Map<String, Long> getTradeBillIdAndLogMap(DynamicObject[] newDataEntities) {
        HashMap<String, Long> tradeBillAndLogIdMap = new HashMap<String, Long>();
        for (DynamicObject newDataEntitie : newDataEntities) {
            long tradeBillId = newDataEntitie.getLong("id");
            DynamicObjectCollection entrys = newDataEntitie.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                DynamicObject draftBill = entry.getDynamicObject("draftbill");
                String keyStr = tradeBillId + "_" + draftBill.getLong("id");
                long billLogId = entry.getLong("billlogid");
                tradeBillAndLogIdMap.put(keyStr, billLogId);
            }
        }
        return tradeBillAndLogIdMap;
    }

    public static Map<String, DynamicObject> getTradeBillIdAndSubBillMap(Set<Long> billIdSet, Set<Long> tradeBillIdSet) {
        DynamicObject[] subRecBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billno,rptype,draftbillstatus,supperbillid,claimnoticebillno,lockedamount,equaltradebillid,subbillendflag,sourcebillid,amount,subbillquantity,subbillrange,subbillstartflag,createtime", (QFilter[])new QFilter[]{new QFilter("supperbillid", "in", billIdSet), new QFilter("equaltradebillid", "in", tradeBillIdSet)});
        Map<String, List<DynamicObject>> dataMap = Arrays.stream(subRecBills).collect(Collectors.groupingBy(x -> x.getLong("equaltradebillid") + "_" + x.getLong("supperbillid")));
        HashMap<String, DynamicObject> splitTradeBillIdMap = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, List<DynamicObject>> entry : dataMap.entrySet()) {
            String keyStr = entry.getKey();
            List<DynamicObject> valueList = entry.getValue();
            if (!EmptyUtil.isNoEmpty(valueList)) continue;
            if (valueList.size() != 1) {
                logger.info(keyStr + "has more subBill");
                valueList.sort(Comparator.comparing(b -> b.getDate("createtime")));
                int lastCreatimeIndex = valueList.size() - 1;
                DynamicObject correctBillDy = valueList.get(lastCreatimeIndex);
                splitTradeBillIdMap.put(keyStr, correctBillDy);
                continue;
            }
            splitTradeBillIdMap.put(keyStr, valueList.get(0));
        }
        return splitTradeBillIdMap;
    }

    public static boolean canRepayOrRejectRefundTranStatus(String tranStatus) {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)DraftTranStatusEnum.FAILING.getValue(), (CharSequence)tranStatus) || org.apache.commons.lang3.StringUtils.equals((CharSequence)DraftTranStatusEnum.HANDLEING.getValue(), (CharSequence)tranStatus) || org.apache.commons.lang3.StringUtils.equals((CharSequence)DraftTranStatusEnum.PORSUCCESS.getValue(), (CharSequence)tranStatus);
    }

    public static boolean canRepayOrRejectRefundDraftEntry(DynamicObject entry) {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)entry.getString("transtatus"), (CharSequence)DraftTranStatusEnum.FAILING.getValue()) && !entry.getBoolean("entryisrejectrefund") && !entry.getBoolean("entryisrepay");
    }

    public static boolean canRepayOrRejectRefundCallTradeBillDraw(DynamicObjectCollection entries) {
        List dataList = entries.stream().filter(e -> !e.getBoolean("entryisrejectrefund") && !e.getBoolean("entryisrepay")).filter(e -> !TradeBillHelper.canRepayOrRejectRefundDraftEntry(e)).collect(Collectors.toList());
        return !dataList.stream().findAny().isPresent() || dataList.stream().allMatch(e -> org.apache.commons.lang3.StringUtils.equals((CharSequence)e.getString("transtatus"), (CharSequence)DraftTranStatusEnum.SUCCESS.getValue()));
    }

    public static boolean canRepayOrRejectRefundCallTradeBillCancelDraw(DynamicObjectCollection entries) {
        List dataList = entries.stream().filter(e -> !e.getBoolean("entryisrejectrefund") && !e.getBoolean("entryisrepay")).collect(Collectors.toList());
        return !dataList.stream().findAny().isPresent() || dataList.stream().allMatch(e -> org.apache.commons.lang3.StringUtils.equals((CharSequence)e.getString("transtatus"), (CharSequence)DraftTranStatusEnum.SUCCESS.getValue()));
    }

    public static boolean notEqualsFromDb(IDataModel model, String opKey) {
        DynamicObject data = model.getDataEntity(true);
        boolean needReloadCondition = DraftTradeTypeEnum.ENDORSE.getValue().equals(data.getString("tradetype"));
        if (needReloadCondition && TradeBillConst.RELOAD_OP_KEYS.contains(opKey)) {
            if (!data.getDataEntityState().getFromDatabase()) {
                return false;
            }
            DynamicObject tradeBillDB = TmcDataServiceHelper.loadSingle((Object)model.getValue("id"), (String)"cdm_drafttradebill");
            boolean isChangeBill = TradeBillChangeHelper.haveBillIsChange(data, tradeBillDB);
            if (isChangeBill) {
                return true;
            }
            if (TradeBillHelper.haveEntryChange(data, tradeBillDB)) {
                return true;
            }
        }
        return false;
    }

    private static boolean haveEntryChange(DynamicObject data, DynamicObject tradeBillDB) {
        DynamicObjectCollection entriesDB = tradeBillDB.getDynamicObjectCollection("entrys");
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
        List innerResultList = entries.stream().filter(entry -> {
            DynamicObject draft = entry.getDynamicObject("draftbill");
            if (EmptyUtil.isEmpty((DynamicObject)draft)) {
                return false;
            }
            boolean isRepay = entry.getBoolean("entryisrepay");
            boolean isRejectRefund = entry.getBoolean("entryisrejectrefund");
            return entriesDB.stream().anyMatch(entryDb -> {
                DynamicObject draftDb = entryDb.getDynamicObject("draftbill");
                if (EmptyUtil.isEmpty((DynamicObject)draftDb)) {
                    return false;
                }
                boolean isRepayOrRejectRefund = isRepay == entryDb.getBoolean("entryisrepay") && isRejectRefund == entryDb.getBoolean("entryisrejectrefund");
                return draft.getLong("id") == draftDb.getLong("id") && isRepayOrRejectRefund;
            });
        }).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(innerResultList) || innerResultList.size() != entries.size()) {
            return true;
        }
        return entries.size() != entriesDB.size();
    }

    public static void processRejectRefundGenBill(DynamicObject[] dataEntities) {
        logger.info("[processRejectRefundGenBill]\u62d2\u6536\u9000\u7968\u53cd\u5199\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u5f00\u59cb\u5904\u7406");
        List<DynamicObject> refundGenTradeBillList = Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrejectrefundgen")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(refundGenTradeBillList)) {
            logger.info("[processRejectRefundGenBill]\u62d2\u6536\u9000\u7968\u53cd\u5199\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u65e0\u62d2\u6536\u9000\u7968\u751f\u6210\u7684\u4e1a\u52a1\u5904\u7406\u5355");
            return;
        }
        Set sourceBillIdSet = Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrejectrefundgen")).map(x -> x.getLong("sourcebillid")).collect(Collectors.toSet());
        Object[] sourceTradeBills = TmcDataServiceHelper.load((Object[])sourceBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        if (EmptyUtil.isEmpty((Object[])sourceTradeBills)) {
            logger.info("[processRejectRefundGenBill]\u62d2\u6536\u9000\u7968\u53cd\u5199\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u901a\u8fc7\u62d2\u6536\u9000\u7968\u751f\u6210\u7684\u4e1a\u52a1\u5904\u7406\u5355\u6e90\u5355id\u67e5\u8be2\u4e0d\u5230\u4e0a\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u4fe1\u606f\uff1a{}", sourceBillIdSet);
            return;
        }
        HashSet cancelDrawTradeIdSet = new HashSet(8);
        Arrays.stream(sourceTradeBills).forEach(sourceTradeBill -> {
            DynamicObjectCollection entries = sourceTradeBill.getDynamicObjectCollection("entrys");
            if (TradeBillHelper.canRepayOrRejectRefundCallTradeBillCancelDraw(entries)) {
                cancelDrawTradeIdSet.add(sourceTradeBill.getPkValue());
            }
        });
        if (EmptyUtil.isNoEmpty(cancelDrawTradeIdSet)) {
            logger.info("[processRejectRefundGenBill]\u62d2\u6536\u9000\u7968\u53cd\u5199\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u9700\u8981\u8c03\u7528\u53d6\u6d88\u5b8c\u6210\u7684\u4e1a\u52a1\u5904\u7406\u5355id\uff1a{}", cancelDrawTradeIdSet);
            OperateOption option = OperateOption.create();
            option.setVariableValue("rejectRefundGenDelete", "true");
            TmcOperateServiceHelper.execOperate((String)"canceldrawbill", (String)"cdm_drafttradebill", (Object[])cancelDrawTradeIdSet.toArray(), (OperateOption)option);
        }
        Map sourceIdAndTradeBillMap = Arrays.stream(sourceTradeBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        HashSet draftIdSet = new HashSet(16);
        refundGenTradeBillList.forEach(refundGenTradeBill -> {
            long sourceBillId = refundGenTradeBill.getLong("sourcebillid");
            DynamicObjectCollection entries = refundGenTradeBill.getDynamicObjectCollection("entrys");
            entries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill"))).map(e -> e.getDynamicObject("draftbill")).forEach(draft -> {
                if (draft.getBoolean("isequalbill") && sourceBillId == draft.getLong("equaltradebillid")) {
                    draftIdSet.add(draft.getLong("supperbillid"));
                } else {
                    draftIdSet.add(draft.getLong("id"));
                }
            });
        });
        logger.info("[processRejectRefundGenBill]\u62d2\u6536\u9000\u7968\u53cd\u5199\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u9700\u8981\u53cd\u5199\u7684\u7968\u636eid\uff1a{}", draftIdSet);
        HashSet updateDraftSet = new HashSet(16);
        DynamicObject[] drafts = TmcDataServiceHelper.load((Object[])draftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        Map idAndDraftMap = Arrays.stream(drafts).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        refundGenTradeBillList.forEach(refundGenTradeBill -> {
            DynamicObjectCollection entries = refundGenTradeBill.getDynamicObjectCollection("entrys");
            long sourceBillId = refundGenTradeBill.getLong("sourcebillid");
            if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)sourceIdAndTradeBillMap.get(sourceBillId)))) {
                DynamicObject sourceTradeBill = (DynamicObject)sourceIdAndTradeBillMap.get(sourceBillId);
                DynamicObjectCollection sourceTradeBillEntries = sourceTradeBill.getDynamicObjectCollection("entrys");
                entries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill"))).forEach(e -> {
                    DynamicObject currentDraft = e.getDynamicObject("draftbill");
                    Object draftId = currentDraft.getPkValue();
                    for (DynamicObject sourceTradeEntry : sourceTradeBillEntries) {
                        DynamicObject sourceDraft = sourceTradeEntry.getDynamicObject("draftbill");
                        if (!EmptyUtil.isNoEmpty((DynamicObject)sourceDraft)) continue;
                        boolean isFind = false;
                        if (sourceDraft.getPkValue() == draftId) {
                            sourceTradeEntry.set("entryisrejectrefund", (Object)false);
                            isFind = true;
                        } else if (currentDraft.getBoolean("isequalbill") && sourceBillId == currentDraft.getLong("equaltradebillid") && sourceDraft.getLong("id") == currentDraft.getLong("supperbillid")) {
                            sourceTradeEntry.set("entryisrejectrefund", (Object)false);
                            logger.info("[processRejectRefundGenBill]\u62d2\u6536\u9000\u7968\u53cd\u5199\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u7b49\u5206\u5316\u62c6\u5206\u7968\u636e\u5bfb\u6bcd\u7968\uff0c\u5f53\u524d\u7968\u636eid\uff1a{}\uff0c\u6bcd\u7968id\uff1a", draftId, (Object)currentDraft.getLong("supperbillid"));
                            draftId = currentDraft.getLong("supperbillid");
                            isFind = true;
                        }
                        DynamicObject draft = (DynamicObject)idAndDraftMap.get(Long.parseLong(draftId.toString()));
                        if (EmptyUtil.isNoEmpty((DynamicObject)draft)) {
                            draft.set("draftbilltranstatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                            updateDraftSet.add(draft);
                        }
                        if (!isFind) continue;
                        break;
                    }
                });
                if (sourceTradeBillEntries.stream().noneMatch(sourceTradeEntry -> sourceTradeEntry.getBoolean("entryisrejectrefund"))) {
                    sourceTradeBill.set("isrejectrefund", (Object)false);
                }
            }
        });
        SaveServiceHelper.update((DynamicObject[])updateDraftSet.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])sourceTradeBills);
    }

    public static void processFailRepayGenBill(DynamicObject[] dataEntities) {
        List<DynamicObject> repayTradeBillList = Arrays.stream(dataEntities).filter(v -> v.getBoolean("isrepaygen")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(repayTradeBillList)) {
            logger.info("TradeBillDeleteService processFailRepayGenBill\uff1ano rePayGen data!");
            return;
        }
        Long[] ids = (Long[])repayTradeBillList.stream().map(repayTradeBill -> repayTradeBill.getLong("id")).toArray(Long[]::new);
        Long tableIdByEntityKey = BotpHelper.getTableIdByEntityKey("cdm_drafttradebill");
        Map sourceTradeBillsMap = BFTrackerServiceHelper.findDirtSourceBills((String)"cdm_drafttradebill", (Long[])ids);
        if (CollectionUtils.isEmpty((Map)sourceTradeBillsMap)) {
            return;
        }
        HashMap idAndSourceIdMap = new HashMap(16);
        sourceTradeBillsMap.forEach((id, bfRows) -> {
            if (!CollectionUtils.isEmpty((Collection)bfRows)) {
                for (BFRow bfRow : bfRows) {
                    BFRowId tRow = bfRow.getSId();
                    if (!tRow.getMainTableId().equals(tableIdByEntityKey)) continue;
                    Long billId = tRow.getBillId();
                    idAndSourceIdMap.put(id, billId);
                    break;
                }
            }
        });
        if (CollectionUtils.isEmpty(idAndSourceIdMap)) {
            logger.info("TradeBillDeleteService processFailRepayGenBill\uff1a\u5931\u8d25\u91cd\u590d\u751f\u6210\u7684\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u65e0\u6cd5\u901a\u8fc7botp\u627e\u5230\u4e0a\u6e38\u5355\u636e");
            return;
        }
        DynamicObject[] sourceTradeBills = TmcDataServiceHelper.load((Object[])idAndSourceIdMap.values().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        Map sourceIdAndTradeBillMap = Arrays.stream(sourceTradeBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        HashSet draftIdSet = new HashSet(16);
        repayTradeBillList.forEach(repayTradeBill -> {
            DynamicObjectCollection entries = repayTradeBill.getDynamicObjectCollection("entrys");
            draftIdSet.addAll(entries.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet()));
        });
        HashSet updateDraftSet = new HashSet(16);
        DynamicObject[] drafts = TmcDataServiceHelper.load((Object[])draftIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        Map idAndDraftMap = Arrays.stream(drafts).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        repayTradeBillList.forEach(repayTradeBill -> {
            DynamicObjectCollection entries = repayTradeBill.getDynamicObjectCollection("entrys");
            Long sourceBillId = (Long)idAndSourceIdMap.get(repayTradeBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)sourceIdAndTradeBillMap.get(sourceBillId)))) {
                DynamicObject sourceTradeBill = (DynamicObject)sourceIdAndTradeBillMap.get(sourceBillId);
                DynamicObjectCollection sourceTradeBillEntries = sourceTradeBill.getDynamicObjectCollection("entrys");
                entries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill"))).forEach(e -> {
                    Object draftId = e.getDynamicObject("draftbill").getPkValue();
                    for (DynamicObject sourceTradeEntry : sourceTradeBillEntries) {
                        if (!EmptyUtil.isNoEmpty((DynamicObject)sourceTradeEntry.getDynamicObject("draftbill")) || sourceTradeEntry.getDynamicObject("draftbill").getPkValue() != draftId) continue;
                        sourceTradeEntry.set("entryisrepay", (Object)false);
                        DynamicObject draft = (DynamicObject)idAndDraftMap.get(Long.parseLong(draftId.toString()));
                        if (!EmptyUtil.isNoEmpty((DynamicObject)draft)) break;
                        draft.set("draftbilltranstatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                        updateDraftSet.add(draft);
                        break;
                    }
                });
                if (sourceTradeBillEntries.stream().noneMatch(sourceTradeEntry -> sourceTradeEntry.getBoolean("entryisrepay"))) {
                    sourceTradeBill.set("isrepay", (Object)false);
                }
            }
        });
        SaveServiceHelper.update((DynamicObject[])updateDraftSet.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])sourceTradeBills);
    }

    public static void pushCasBill(String pushOpKey, Object[] pkIds, OperateOption operateOption, String entityName) {
        try (TXHandle tx = TX.requiresNew();){
            OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)pushOpKey, (String)"cdm_drafttradebill", (Object[])pkIds, (OperateOption)operateOption);
            if (!result.isSuccess()) {
                List successPkIds = result.getSuccessPkIds();
                if (successPkIds.size() > 0) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("cdm_drafttradebill_ignore", "1");
                    OperationResult deleteResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)entityName, (Object[])successPkIds.toArray(), (OperateOption)option);
                    if (!deleteResult.isSuccess()) {
                        successPkIds.removeAll(deleteResult.getSuccessPkIds());
                        logger.error(String.format("\u51fa\u7eb3\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ID: %s", entityName, successPkIds.toString()));
                    }
                }
                String errMsg = TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result);
                throw new KDBizException(errMsg);
            }
        }
    }

    public static void fillPushData(ArrayList<DynamicObject> pushdataEmtities, DynamicObject data) {
        Long orgId = (Long)data.getDynamicObject("company").getPkValue();
        String settlementtype = data.getDynamicObject("drafttype").getString("settlementtype");
        if ((StringUtils.equals((CharSequence)SettleMentTypeEnum.BANK.getValue(), (CharSequence)settlementtype) || StringUtils.equals((CharSequence)SettleMentTypeEnum.BUSINESS.getValue(), (CharSequence)settlementtype)) && DraftHelper.getCdmParameterBoolean(orgId, "isdraft")) {
            pushdataEmtities.add(data);
        } else if (StringUtils.equals((CharSequence)SettleMentTypeEnum.PROMISSORY.getValue(), (CharSequence)settlementtype) && DraftHelper.getCdmParameterBoolean(orgId, "ischeck")) {
            pushdataEmtities.add(data);
        } else if (StringUtils.equals((CharSequence)SettleMentTypeEnum.CHECK.getValue(), (CharSequence)settlementtype) && DraftHelper.getCdmParameterBoolean(orgId, "ispromissorynote")) {
            pushdataEmtities.add(data);
        }
    }

    public static Map<Long, List<DynamicObject>> loadSurety(DynamicObject[] billsList) {
        HashMap<Long, List<DynamicObject>> billIdAndSuretyIdMap = new HashMap<Long, List<DynamicObject>>(6);
        Set paybillIdSet = Arrays.stream(billsList).map(x -> x.getLong("id")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("entry.debtbillid", "in", paybillIdSet);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,entry.debtbillid,billno,amount,surplusamount", (QFilter[])new QFilter[]{idFilter});
        HashSet<Long> hasCheckSet = new HashSet<Long>();
        if (EmptyUtil.isNoEmpty((Object[])suretyBills)) {
            for (Object suretyBill : suretyBills) {
                DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    long debtbillid = entry.getLong("debtbillid");
                    hasCheckSet.add(debtbillid);
                    if (billIdAndSuretyIdMap.containsKey(debtbillid)) {
                        ((List)billIdAndSuretyIdMap.get(debtbillid)).add(suretyBill);
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(suretyBill);
                    billIdAndSuretyIdMap.put(debtbillid, list);
                }
            }
        }
        logger.info("hasCheckSet is:" + SerializationUtils.toJsonString(hasCheckSet));
        List needcheckApplyList = Arrays.stream(billsList).filter(i -> !hasCheckSet.contains(i.getLong("id")) && "apply".equals(i.getString("source"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(needcheckApplyList)) {
            HashSet<Long> secondCheckSet = new HashSet<Long>();
            Map<Long, Long> billIdAndApplyEntryIdMap = needcheckApplyList.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("sourcebillid")));
            logger.info("needcheckApplyList is:" + SerializationUtils.toJsonString(billIdAndApplyEntryIdMap.keySet()));
            Map<Long, Long> billIdAndApplyIdMap = TradeBillHelper.getSourcebillid(billIdAndApplyEntryIdMap);
            if (billIdAndApplyIdMap.size() > 0) {
                HashSet<Long> applyIdSet = new HashSet<Long>(billIdAndApplyIdMap.values());
                QFilter applyIdFilter = new QFilter("entry.debtbillid", "in", applyIdSet);
                DynamicObject[] applySuretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,entry.debtbillid,billno,amount,surplusamount", (QFilter[])new QFilter[]{applyIdFilter});
                for (DynamicObject needcheckDyn : needcheckApplyList) {
                    long billId = needcheckDyn.getLong("id");
                    long sourcebillid = billIdAndApplyIdMap.get(billId);
                    for (DynamicObject applySuretyBill : applySuretyBills) {
                        DynamicObjectCollection entrys = applySuretyBill.getDynamicObjectCollection("entry");
                        for (DynamicObject entry : entrys) {
                            long debtbillid = entry.getLong("debtbillid");
                            if (!String.valueOf(sourcebillid).equals(String.valueOf(debtbillid))) continue;
                            secondCheckSet.add(billId);
                            if (billIdAndSuretyIdMap.containsKey(billId)) {
                                ((List)billIdAndSuretyIdMap.get(billId)).add(applySuretyBill);
                                continue;
                            }
                            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                            list.add(applySuretyBill);
                            billIdAndSuretyIdMap.put(billId, list);
                        }
                    }
                }
            }
            logger.info("secondCheckSet is that:" + SerializationUtils.toJsonString(secondCheckSet));
            Set needCheckOldApplySet = needcheckApplyList.stream().filter(e -> !secondCheckSet.contains(e.getLong("id"))).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(needCheckOldApplySet)) {
                Map<Long, Long> billIdAndOldApplyIdMap = needCheckOldApplySet.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("sourcebillid")));
                logger.info("needcheckOldApplyList is:" + SerializationUtils.toJsonString(billIdAndOldApplyIdMap));
                HashSet<Long> oldApplyIdSet = new HashSet<Long>(billIdAndOldApplyIdMap.values());
                QFilter oldApplyIdFilter = new QFilter("entry.debtbillid", "in", oldApplyIdSet);
                Object[] oldApplySuretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,entry.debtbillid,billno,amount,surplusamount", (QFilter[])new QFilter[]{oldApplyIdFilter});
                if (EmptyUtil.isNoEmpty((Object[])oldApplySuretyBills)) {
                    HashSet<Long> thridCheckSet = new HashSet<Long>();
                    for (DynamicObject needCheckOldApply : needCheckOldApplySet) {
                        long thridbillid = needCheckOldApply.getLong("id");
                        Long oldApply = billIdAndOldApplyIdMap.get(thridbillid);
                        if (!EmptyUtil.isNoEmpty((Long)oldApply)) continue;
                        for (Object suretyBill : oldApplySuretyBills) {
                            DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
                            for (DynamicObject entry : entrys) {
                                long debtbillid = entry.getLong("debtbillid");
                                if (!String.valueOf(oldApply).equals(String.valueOf(debtbillid))) continue;
                                thridCheckSet.add(thridbillid);
                                if (billIdAndSuretyIdMap.containsKey(thridbillid)) {
                                    ((List)billIdAndSuretyIdMap.get(thridbillid)).add(suretyBill);
                                    continue;
                                }
                                ArrayList<Object> list = new ArrayList<Object>();
                                list.add(suretyBill);
                                billIdAndSuretyIdMap.put(thridbillid, list);
                            }
                        }
                    }
                    logger.info("thridCheckSet is:" + SerializationUtils.toJsonString(thridCheckSet));
                }
            }
        }
        return billIdAndSuretyIdMap;
    }

    public static Map<Long, Long> getSourcebillid(Map<Long, Long> billIdAndApplyEntryIdMap) {
        HashSet<Long> entryIdSet = new HashSet<Long>(billIdAndApplyEntryIdMap.values());
        HashMap<Long, Long> billIdAndApplyIdMap = new HashMap<Long, Long>();
        if (EmptyUtil.isEmpty(entryIdSet)) {
            return billIdAndApplyIdMap;
        }
        QFilter idFilter = new QFilter("entryentity.id", "in", entryIdSet);
        Object[] payableBillApplys = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,entryentity", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isNoEmpty((Object[])payableBillApplys)) {
            for (Map.Entry<Long, Long> entry : billIdAndApplyEntryIdMap.entrySet()) {
                Long value = entry.getValue();
                for (Object payableBillApply : payableBillApplys) {
                    long applyId = payableBillApply.getLong("id");
                    DynamicObjectCollection entryentitys = payableBillApply.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryentity : entryentitys) {
                        long entryId = entryentity.getLong("id");
                        if (!String.valueOf(entryId).equals(String.valueOf(value))) continue;
                        billIdAndApplyIdMap.put(entry.getKey(), applyId);
                    }
                }
            }
        }
        return billIdAndApplyIdMap;
    }
}

