/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.abstracts.guarantee;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.business.abstracts.guarantee.AbstractGuaranteeTrade;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.PersonnelTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftGuaranteeTrade
extends AbstractGuaranteeTrade {
    public static AbstractGuaranteeTrade getInstance() {
        return Singleton.instance;
    }

    @Override
    public void initBizTypeReleaseControl(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"guaranteetype", "guarantor", "guarantortext", "discountorg", "creditlimitorg", "credittype", "creditlimit", "creditcurrency", "credittotalamount"});
        view.setVisible(Boolean.TRUE, new String[]{"creditamount"});
        view.setVisible(Boolean.FALSE, new String[]{"entrycreditamount", "entrycreditlimitorg", "entrycreditlimit", "entryguaranttype", "entryguarantortext", "entrybizdate"});
        this.patchSetFieldEditMustInput(view, true, "guaranteetype", "discountorg", "creditlimitorg", "credittype", "creditlimit", "creditamount");
    }

    @Override
    public List<QFilter> getDraftQFilters(IDataModel model) {
        String guarantorText;
        List<QFilter> qFilters = this.getCommonSelectDraftQFilters(model);
        DynamicObject data = model.getDataEntity(true);
        if (StringUtils.equals((CharSequence)data.getString("guaranteetype"), (CharSequence)PersonnelTypeEnum.OTHER.getValue())) {
            guarantorText = data.getString("guarantortext");
        } else {
            DynamicObject guarantor = data.getDynamicObject("guarantor");
            String string = guarantorText = EmptyUtil.isNoEmpty((DynamicObject)guarantor) ? guarantor.getString("name") : null;
        }
        if (StringUtils.equals((CharSequence)data.getString("rptype"), (CharSequence)ReceivePayTypeEnum.RECEIVEBILL.getValue())) {
            qFilters.add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
            qFilters.add(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.ENDORSED.getValue()));
            if (EmptyUtil.isNoEmpty((String)guarantorText)) {
                qFilters.add(new QFilter("beendorsor", "=", (Object)guarantorText));
            }
        } else {
            qFilters.add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()));
            qFilters.add(new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue()));
            if (EmptyUtil.isNoEmpty((String)guarantorText)) {
                qFilters.add(new QFilter("receivername", "=", (Object)guarantorText));
            }
        }
        qFilters.add(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        qFilters.add(new QFilter("guarantflag", "=", (Object)"0"));
        DynamicObjectCollection entries = data.getDynamicObjectCollection("billentries");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entries)) {
            ArrayList selectedDaftIds = new ArrayList();
            entries.stream().filter(v -> EmptyUtil.isNoEmpty((DynamicObject)v.getDynamicObject("draftbill"))).forEach(v -> selectedDaftIds.add(v.getDynamicObject("draftbill").getPkValue()));
            if (selectedDaftIds.size() > 0) {
                qFilters.add(new QFilter("id", "not in", selectedDaftIds));
            }
        }
        return qFilters;
    }

    static class Singleton {
        private static final DraftGuaranteeTrade instance = new DraftGuaranteeTrade();

        Singleton() {
        }
    }
}

