/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftBillToGuaranteeBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs args) {
        ExtendedDataEntity[] billDataEntities;
        super.afterFieldMapping(args);
        String bizType = this.getOption().getVariableValue("biztype");
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntities = args.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = dataEntity.getDataEntity();
            targetBill.set("biztype", (Object)bizType);
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection("billentries");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entries)) {
                Set<Object> draftIdSet = entries.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] draftBills = TmcDataServiceHelper.load((Object[])draftIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                Map<Long, DynamicObject> draftIdAndDyMap = Arrays.stream(draftBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                for (DynamicObject entry : entries) {
                    DynamicObject currentDraft = entry.getDynamicObject("draftbill");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)currentDraft)) continue;
                    DynamicObject draftBill = draftIdAndDyMap.get(currentDraft.getLong("id"));
                    entry.set("draftbill", (Object)draftBill);
                    entry.set("billamountfield", (Object)draftBill.getBigDecimal("amount"));
                    entry.set("subbillrangefield", (Object)draftBill.getString("subbillrange"));
                    entry.set("subbillquantityfield", (Object)draftBill.getLong("subbillquantity"));
                    entry.set("subbillstartflagfield", (Object)draftBill.getLong("subbillstartflag"));
                    entry.set("subbillendflagfield", (Object)draftBill.getLong("subbillendflag"));
                    entry.set("entrycreditamount", (Object)draftBill.getBigDecimal("guarantcreditamount"));
                    entry.set("entrycreditlimitorg", (Object)draftBill.getString("guarantcreditlimitorg"));
                    entry.set("entrycreditlimit", (Object)draftBill.getString("guarantcreditlimit"));
                    entry.set("entryguaranttype", (Object)draftBill.getString("guaranttype"));
                    entry.set("entryguarantortext", (Object)draftBill.getString("guarantortext"));
                    entry.set("entrybizdate", (Object)draftBill.getDate("guarantbizdate"));
                    entry.set("guaranteeid", (Object)draftBill.getLong("guaranteeid"));
                }
            }
            BigDecimal totalAmount = entries.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("draftbill"))).map(o -> o.getDynamicObject("draftbill").getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            int count = entries.toArray().length;
            targetBill.set("amount", (Object)totalAmount);
            targetBill.set("count", (Object)count);
        }
    }
}

