/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.draftbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftBillSyncDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftPayBillSyncDetail;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.tuple.Pair;

public interface IEleDraftBillUpdater<Q, O, S> {
    public static final Log logger = LogFactory.getLog(IEleDraftBillUpdater.class);

    public void queryUpdate(DynamicObject var1, Q var2, String var3, String var4);

    public void operateUpdate(DynamicObject var1, O var2);

    public void syncUpdate(DynamicObject var1, S var2);

    default public void newEleInterfaceFields(DynamicObject draftBill, Q queryData, S syncData) {
        if (queryData instanceof DraftBillInfo) {
            boolean isSubRangeEmpty;
            DraftBillInfo newQueryData = (DraftBillInfo)queryData;
            draftBill.set("grdbag", (Object)(StringUtils.isEmpty((CharSequence)newQueryData.getGrdBag()) ? "0" : newQueryData.getGrdBag()));
            draftBill.set("cirstatus", (Object)newQueryData.getCirStatus());
            draftBill.set("subrange", (Object)EleDraftHelper.tranSubRangeStyle((String)newQueryData.getSubRange()));
            boolean bl = isSubRangeEmpty = StringUtils.isEmpty((CharSequence)newQueryData.getSubRange()) && StringUtils.isNotEmpty((CharSequence)newQueryData.getStartNo()) && StringUtils.isNotEmpty((CharSequence)newQueryData.getEndNo());
            if (isSubRangeEmpty && Long.parseLong(newQueryData.getStartNo()) > 0L && Long.parseLong(newQueryData.getEndNo()) > 0L) {
                draftBill.set("subrange", (Object)EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", newQueryData.getStartNo(), newQueryData.getEndNo())));
            }
            if (StringUtils.isEmpty((CharSequence)draftBill.getString("subrange"))) {
                draftBill.set("subrange", (Object)"0");
            }
            draftBill.set("settleway", (Object)newQueryData.getSettleWay());
            draftBill.set("cleartype", (Object)newQueryData.getClearType());
        } else if (syncData instanceof DraftPayBillSyncDetail) {
            boolean isSubRangeEmpty;
            DraftPayBillSyncDetail paySyncData = (DraftPayBillSyncDetail)syncData;
            draftBill.set("grdbag", (Object)(StringUtils.isEmpty((CharSequence)paySyncData.getGrdBag()) ? "0" : paySyncData.getGrdBag()));
            draftBill.set("cirstatus", (Object)paySyncData.getCirStatus());
            draftBill.set("subrange", (Object)EleDraftHelper.tranSubRangeStyle((String)paySyncData.getSubRange()));
            boolean bl = isSubRangeEmpty = StringUtils.isEmpty((CharSequence)paySyncData.getSubRange()) && StringUtils.isNotEmpty((CharSequence)paySyncData.getStartNo()) && StringUtils.isNotEmpty((CharSequence)paySyncData.getEndNo());
            if (isSubRangeEmpty && Long.parseLong(paySyncData.getStartNo()) > 0L && Long.parseLong(paySyncData.getEndNo()) > 0L) {
                draftBill.set("subrange", (Object)EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", paySyncData.getStartNo(), paySyncData.getEndNo())));
            }
            if (StringUtils.isEmpty((CharSequence)draftBill.getString("subrange"))) {
                draftBill.set("subrange", (Object)"0");
            }
            draftBill.set("bankrefdate", (Object)paySyncData.getBankRefDate());
            draftBill.set("bankrefkey", (Object)paySyncData.getBankRefKey());
        } else if (syncData instanceof DraftBillSyncDetail) {
            boolean subRangeEmpty;
            DraftBillSyncDetail recSyncData = (DraftBillSyncDetail)syncData;
            draftBill.set("grdbag", (Object)(StringUtils.isEmpty((CharSequence)recSyncData.getGrdBag()) ? "0" : recSyncData.getGrdBag()));
            draftBill.set("cirstatus", (Object)recSyncData.getCirStatus());
            BigDecimal amount = draftBill.getBigDecimal("amount");
            String oppAmount = recSyncData.getOppAmount();
            String ebStatus = recSyncData.getEbStatus();
            String cirStatus = recSyncData.getCirStatus();
            String tradeType = draftBill.getString("tradetype");
            String recSubRange = EleDraftHelper.tranSubRangeStyle((String)recSyncData.getSubRange());
            String billSubRange = draftBill.getString("subrange");
            BigDecimal locAmt = draftBill.getBigDecimal("locamt");
            boolean bl = subRangeEmpty = StringUtils.isEmpty((CharSequence)recSyncData.getSubRange()) && StringUtils.isNotEmpty((CharSequence)recSyncData.getStartNo()) && StringUtils.isNotEmpty((CharSequence)recSyncData.getEndNo());
            if (subRangeEmpty && Long.parseLong(recSyncData.getStartNo()) > 0L && Long.parseLong(recSyncData.getEndNo()) > 0L) {
                recSubRange = EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", recSyncData.getStartNo(), recSyncData.getEndNo()));
            }
            boolean isSplitPart = StringUtils.isNotEmpty((CharSequence)oppAmount) && amount.compareTo(new BigDecimal(oppAmount)) != 0 && (StringUtils.isNotEmpty((CharSequence)recSyncData.getSubRange()) || StringUtils.isNotEmpty((CharSequence)recSyncData.getStartNo()) && StringUtils.isNotEmpty((CharSequence)recSyncData.getEndNo())) && !recSubRange.equals(billSubRange) && !ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType) || ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType) && !recSubRange.equals(billSubRange) && EbStatus.BANK_SUCCESS.getName().equals(ebStatus);
            boolean isSplitFlag = EbStatus.BANK_SUCCESS.getName().equals(ebStatus) || EbStatus.BANK_FAIL.getName().equals(ebStatus);
            logger.info("IEleDraftBillUpdater.newEleInterfaceFields billNo = {},billSubRange = {},recSubRange = {},isSplitPart = {},isSplitFlag = {}", new Object[]{draftBill.getString("billno"), billSubRange, recSubRange, isSplitPart, isSplitFlag});
            boolean isSplitFlag2 = Boolean.FALSE;
            if (isSplitPart && !isSplitFlag && EleDraftCirStatusEnum.TF0302.getValue().equals(cirStatus)) {
                QFilter orgFilter = new QFilter("defaultaccount.id", "in", (Object)draftBill.getDynamicObject("draftaccount").getLong("id"));
                DynamicObjectCollection eleTicIdColl = QueryServiceHelper.query((String)"cdm_electicdirconset", (String)"id,islockedsplit", (QFilter[])new QFilter[]{orgFilter});
                boolean isLockedSplit = eleTicIdColl.size() == 0 ? Boolean.FALSE.booleanValue() : ((DynamicObject)eleTicIdColl.get(0)).getBoolean("islockedsplit");
                isSplitFlag2 = (EbStatus.BANK_PROCESSING.getName().equals(ebStatus) || "BANK_UNKNOWN".equals(ebStatus)) && isLockedSplit;
            }
            boolean mustSplit = "1".equals(recSyncData.getIsRefuse());
            if (isSplitPart && (isSplitFlag || isSplitFlag2)) {
                Pair rangeLong;
                String subEleBill = "";
                if (StringUtils.isNotEmpty((CharSequence)recSyncData.getSubRange())) {
                    String usedEleBill = EleDraftHelper.tranSubRangeStyle((String)recSyncData.getSubRange());
                    String startFlag = String.valueOf(Long.parseLong(usedEleBill.substring(usedEleBill.indexOf("-") + 1)) + 1L);
                    String endFlag = draftBill.getString("initsubrange").substring(draftBill.getString("initsubrange").indexOf("-") + 1);
                    subEleBill = startFlag + "-" + endFlag;
                    draftBill.set("subrange", (Object)subEleBill);
                    logger.info("IEleDraftBillUpdater.newEleInterfaceFields SubRange isNotEmpty billNo = {},subEleBill = {}", (Object)draftBill.getString("billno"), (Object)subEleBill);
                } else if (StringUtils.isNotEmpty((CharSequence)recSyncData.getStartNo()) && StringUtils.isNotEmpty((CharSequence)recSyncData.getEndNo())) {
                    String startFlag = String.valueOf(Long.parseLong(recSyncData.getEndNo()) + 1L);
                    String endFlag = draftBill.getString("initsubrange").substring(draftBill.getString("initsubrange").indexOf("-") + 1);
                    subEleBill = startFlag + "-" + endFlag;
                    draftBill.set("subrange", (Object)subEleBill);
                    logger.info("IEleDraftBillUpdater.newEleInterfaceFields SubRange isEmpty billNo = {},subEleBill = {}", (Object)draftBill.getString("billno"), (Object)subEleBill);
                }
                if (StringUtils.isNotEmpty((CharSequence)subEleBill) && (rangeLong = EleDraftHelper.tranSubRangeToLeftRight((String)subEleBill)) != null) {
                    long subBillStartFlag = (Long)rangeLong.getLeft();
                    long subBillEndFlag = (Long)rangeLong.getRight();
                    BigDecimal splitAmount = BigDecimal.valueOf((double)(subBillEndFlag - subBillStartFlag + 1L) * 0.01);
                    draftBill.set("amount", (Object)splitAmount);
                    BigDecimal usedAmount = draftBill.getBigDecimal("usedamount");
                    draftBill.set("usedamount", (Object)usedAmount.add(new BigDecimal(oppAmount)));
                    logger.info("IEleDraftBillUpdater.newEleInterfaceFields SubRange isEmpty billNo = {},splitAmount = {}", (Object)draftBill.getString("billno"), (Object)splitAmount);
                }
            } else if (mustSplit && StringUtils.isNotEmpty((CharSequence)oppAmount) && amount.compareTo(new BigDecimal(oppAmount)) != 0 && locAmt.compareTo(new BigDecimal(oppAmount)) == 0) {
                Pair rangeLong;
                String startFlag = String.valueOf(Long.parseLong(billSubRange.substring(0, billSubRange.indexOf("-"))) + locAmt.multiply(BigDecimal.valueOf(100L)).longValue());
                String endFlag = billSubRange.substring(billSubRange.indexOf("-") + 1);
                String subEleBill = startFlag + "-" + endFlag;
                logger.info("IEleDraftBillUpdater.newEleInterfaceFields isRefuse = 1 billNo = {},subEleBill = {}", (Object)draftBill.getString("billno"), (Object)subEleBill);
                draftBill.set("subrange", (Object)subEleBill);
                if (StringUtils.isNotEmpty((CharSequence)subEleBill) && (rangeLong = EleDraftHelper.tranSubRangeToLeftRight((String)subEleBill)) != null) {
                    long subBillStartFlag = (Long)rangeLong.getLeft();
                    long subBillEndFlag = (Long)rangeLong.getRight();
                    BigDecimal splitAmount = BigDecimal.valueOf((double)(subBillEndFlag - subBillStartFlag + 1L) * 0.01);
                    draftBill.set("amount", (Object)splitAmount);
                    BigDecimal usedAmount = draftBill.getBigDecimal("usedamount");
                    draftBill.set("usedamount", (Object)usedAmount.add(new BigDecimal(oppAmount)));
                    logger.info("IEleDraftBillUpdater.newEleInterfaceFields isRefuse = 1 billNo = {},splitAmount = {}", (Object)draftBill.getString("billno"), (Object)splitAmount);
                }
            } else if (EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && !ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType)) {
                boolean isSubRangeEmpty;
                draftBill.set("subrange", (Object)EleDraftHelper.tranSubRangeStyle((String)recSyncData.getSubRange()));
                boolean bl2 = isSubRangeEmpty = StringUtils.isEmpty((CharSequence)recSyncData.getSubRange()) && StringUtils.isNotEmpty((CharSequence)recSyncData.getStartNo()) && StringUtils.isNotEmpty((CharSequence)recSyncData.getEndNo());
                if (isSubRangeEmpty) {
                    draftBill.set("subrange", (Object)EleDraftHelper.tranSubRangeStyle((String)String.join((CharSequence)",", recSyncData.getStartNo(), recSyncData.getEndNo())));
                }
                if (StringUtils.isEmpty((CharSequence)draftBill.getString("subrange"))) {
                    draftBill.set("subrange", (Object)"0");
                }
                logger.info("IEleDraftBillUpdater.newEleInterfaceFields BANK_SUCCESS billNo = {},SubRange = {}", (Object)draftBill.getString("billno"), (Object)draftBill.getString("subrange"));
            }
            draftBill.set("interest", (Object)recSyncData.getInterest());
        }
    }
}

