/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.draftbill.impl;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.IEleDraftBillUpdater;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftPayBillNoteDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftPayBillSyncDetail;

public class EleDraftPayBillUpdater
implements IEleDraftBillUpdater<DraftBillInfo, DraftPayBillNoteDetail, DraftPayBillSyncDetail> {
    private static final Log logger = LogFactory.getLog(EleDraftPayBillUpdater.class);
    private static EleDraftPayBillUpdater instance;

    private EleDraftPayBillUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EleDraftPayBillUpdater getInstance() {
        Class<EleDraftPayBillUpdater> clazz = EleDraftPayBillUpdater.class;
        synchronized (EleDraftPayBillUpdater.class) {
            if (instance == null) {
                instance = new EleDraftPayBillUpdater();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void queryUpdate(DynamicObject draftBill, DraftBillInfo queryData, String connectNo, String bizSubType) {
        String bankName;
        DynamicObject beBank;
        DynamicObject bank;
        DynamicObject[] drawerAccountBank;
        DynamicObject[] accountBank;
        logger.info("EleDraftPayBillUpdater queryUpdate connectNo = {},bizSubType = {}", (Object)connectNo, (Object)bizSubType);
        draftBill.set("amount", (Object)queryData.getAmount());
        draftBill.set("opstatus", (Object)DraftBillOpStatusEnum.INIT.getValue());
        draftBill.set("drafttype", (Object)queryData.getDraftType());
        if (EleDraftIsNewECDS.NEW.getValue().equals(queryData.getIsNewECDS())) {
            EleDraftNoteStatusEnum newNoteStatusEnum = EleDraftNoteStatusEnum.getByValue((String)queryData.getNoteStatus());
            draftBill.set("notestatus", (Object)(null == newNoteStatusEnum ? queryData.getNoteStatus() : newNoteStatusEnum.getValue()));
            this.newEleInterfaceFields(draftBill, queryData, null);
            draftBill.set("grdbag", (Object)("0".equals(queryData.getGrdBag()) ? "0" : "1"));
            if ((StringUtils.isEmpty((CharSequence)draftBill.getString("subrange")) || "0".equals(draftBill.getString("subrange"))) && StringUtils.isNotEmpty((CharSequence)queryData.getAmount()) && draftBill.getBoolean("grdbag")) {
                draftBill.set("subrange", (Object)String.join((CharSequence)"-", "1", String.valueOf(new BigDecimal(queryData.getAmount()).multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString())));
            }
        } else {
            EleDraftBillStatusEnum byEbValue = EleDraftBillStatusEnum.getByEbValue((String)queryData.getNoteStatus());
            draftBill.set("ticketstatus", (Object)(null == byEbValue ? queryData.getNoteStatus() : byEbValue.getValue()));
        }
        draftBill.set("modifytime", (Object)new Date());
        draftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if (!StringUtil.isEmpty((String)connectNo)) {
            draftBill.set("applicantacctext", (Object)connectNo);
        }
        if ((accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,company,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)connectNo)})).length > 0) {
            draftBill.set("applicanttext", (Object)accountBank[0].getDynamicObject("company").getString("name"));
            draftBill.set("draftaccount", (Object)accountBank[0]);
            DynamicObject electDirectConnect = BusinessDataServiceHelper.loadSingle((String)"cdm_electicdirconset", (String)"id,directconnchannel,defaultaccount", (QFilter[])new QFilter[]{new QFilter("defaultaccount.id", "=", accountBank[0].getPkValue())});
            if (!ObjectUtils.isEmpty((Object)electDirectConnect)) {
                draftBill.set("connchannel", electDirectConnect.getDynamicObject("directconnchannel").getPkValue());
            }
        }
        draftBill.set("applicantbanknotext", (Object)queryData.getApplicantBankCnaps());
        draftBill.set("bizdate", (Object)new Date());
        draftBill.set("bizcode", (Object)queryData.getBusinessCode());
        draftBill.set("bankconsultno", (Object)queryData.getBankRefKey());
        draftBill.set("bankrefdate", (Object)queryData.getBankRefDate());
        draftBill.set("customerconsultno", (Object)queryData.getCoustomerRefKey());
        draftBill.set("customeropstatus", (Object)queryData.getCoustomerStutus());
        draftBill.set("customeropstatus", (Object)queryData.getCoustomerStutus());
        DynamicObject[] currency = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)queryData.getCurrency())});
        if (currency.length > 0) {
            draftBill.set("currency", currency[0].getPkValue());
            draftBill.set("currencytext", (Object)currency[0].getString("name"));
        }
        draftBill.set("issueticketdate", (Object)DateFormatUtil.FormatDate((String)queryData.getIssueDate()));
        draftBill.set("exchangebillexpiredate", (Object)DateFormatUtil.FormatDate((String)queryData.getDueDate()));
        draftBill.set("istransfer", (Object)("EM01".equals(queryData.getTransferFlag()) ? "0" : "1"));
        draftBill.set("invoicenumber", (Object)queryData.getInvoiceNumer());
        draftBill.set("contractnumber", (Object)queryData.getContractNumber());
        draftBill.set("keepflag", (Object)("1".equals(queryData.getKeepFlag()) ? "1" : "0"));
        draftBill.set("autoaccept", (Object)("1".equals(queryData.getAutoAccept()) ? "1" : "0"));
        draftBill.set("autoreceive", (Object)("1".equals(queryData.getAutoReceive()) ? "1" : "0"));
        draftBill.set("explain", (Object)queryData.getExplain());
        draftBill.set("remark", (Object)queryData.getRemark());
        draftBill.set("pretypeflag", (Object)("1".equals(queryData.getPreTypeFlag()) ? "1" : "0"));
        draftBill.set("indorsename", (Object)queryData.getIndorseName());
        draftBill.set("discountrate", (Object)queryData.getDisCountRate());
        draftBill.set("loanamount", (Object)queryData.getLoanAmount());
        draftBill.set("issueticketacctext", (Object)queryData.getDrawerAccNo());
        draftBill.set("issueticketertext", (Object)queryData.getDrawerAccName());
        draftBill.set("issueticketbanktext", (Object)queryData.getDrawerBankName());
        draftBill.set("issueticketbankno", (Object)queryData.getDrawerCnapsCode());
        if (StringUtils.isEmpty((CharSequence)draftBill.getString("issueticketbankno")) && (drawerAccountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)queryData.getDrawerAccNo())})).length > 0 && !ObjectUtils.isEmpty((Object)(bank = drawerAccountBank[0].getDynamicObject("bank")))) {
            String unionNumber = bank.getString("union_number");
            draftBill.set("issueticketbankno", (Object)unionNumber);
        }
        if (StringUtils.isEmpty((CharSequence)draftBill.getString("issueticketbanktext")) && (drawerAccountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)queryData.getDrawerAccNo())})).length > 0 && !ObjectUtils.isEmpty((Object)(bank = drawerAccountBank[0].getDynamicObject("bank")))) {
            beBank = bank.getDynamicObject("bebank");
            bankName = beBank == null ? "" : beBank.getString("name");
            draftBill.set("issueticketbanktext", (Object)bankName);
        }
        draftBill.set("promiseracctext", (Object)queryData.getAcceptorAccNo());
        draftBill.set("promisertext", (Object)queryData.getAcceptorAccName());
        draftBill.set("promiserbanktext", (Object)queryData.getAcceptorBankName());
        draftBill.set("promiserbankno", (Object)queryData.getAcceptorCnapsCode());
        draftBill.set("collectionacctext", (Object)queryData.getPayeeAccNo());
        draftBill.set("collectionertext", (Object)queryData.getPayeeAccName());
        draftBill.set("collectionbanktext", (Object)queryData.getPayeeBankName());
        draftBill.set("collectionbankno", (Object)queryData.getPayeeCnapsCode());
        if (StringUtils.isEmpty((CharSequence)draftBill.getString("collectionbanktext")) && (drawerAccountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)queryData.getPayeeAccNo())})).length > 0 && !ObjectUtils.isEmpty((Object)(bank = drawerAccountBank[0].getDynamicObject("bank")))) {
            beBank = bank.getDynamicObject("bebank");
            bankName = beBank == null ? "" : beBank.getString("name");
            draftBill.set("collectionbanktext", (Object)bankName);
        }
        draftBill.set("holderaccno", (Object)queryData.getHolderAccNo());
        draftBill.set("holderbankname", (Object)queryData.getHolderBankName());
        draftBill.set("holdercnapscode", (Object)queryData.getHolderCnapsCode());
        draftBill.set("oppaccname", (Object)draftBill.getString("preholdername"));
        draftBill.set("explain", (Object)queryData.getExplain());
        draftBill.set("remark", (Object)queryData.getRemark());
        logger.info("EleDraftPayBillUpdater queryUpdate sideInfos:PreHolderName=" + draftBill.get("preholdername"));
    }

    @Override
    public void operateUpdate(DynamicObject draftBill, DraftPayBillNoteDetail operateData) {
        if (draftBill != null && operateData != null) {
            logger.info("EleDraftPayBillUpdater.operateUpdate is start");
            draftBill.set("operationcode", (Object)operateData.getTranType());
            draftBill.set("detailseqid", (Object)operateData.getDetailSeqID());
            draftBill.set("detailbizno", (Object)operateData.getDetailBizNo());
            draftBill.set("ebseqid", (Object)operateData.getEbSeqID());
            draftBill.set("ebstatus", (Object)operateData.getEbStatus());
            draftBill.set("ebstatusmsg", (Object)operateData.getEbStatusMsg());
            draftBill.set("bankstatus", (Object)operateData.getBankStatus());
            draftBill.set("bankmsg", (Object)operateData.getBankMsg());
            draftBill.set("flowserialno", (Object)operateData.getFlowSerialNo());
            draftBill.set("rqstserialno", (Object)operateData.getRqstSerialNo());
            draftBill.set("rspserialno", (Object)operateData.getRspSerialNo());
            draftBill.set("fileid", (Object)operateData.getReserved1());
            draftBill.set("filename", (Object)operateData.getReserved2());
            draftBill.set("filepath", (Object)operateData.getReserved3());
            draftBill.set("fileencrypt", (Object)operateData.getReserveds());
            draftBill.set("datasource", (Object)"bank");
        }
    }

    @Override
    public void syncUpdate(DynamicObject draftBill, DraftPayBillSyncDetail syncData) {
        if (draftBill != null && syncData != null) {
            logger.info("EleDraftPayBillUpdater.syncUpdate is start");
            draftBill.set("oppaccname", (Object)syncData.getPayeeAccName());
            draftBill.set("explain", (Object)syncData.getDesc());
            draftBill.set("detailseqid", (Object)syncData.getDetailSeqID());
            draftBill.set("detailbizno", (Object)syncData.getDetailBizNo());
            draftBill.set("promiseracctext", (Object)syncData.getAcceptorAccNo());
            draftBill.set("promisertext", (Object)syncData.getAcceptorAccName());
            draftBill.set("promiserbankno", (Object)syncData.getAcceptorCnapsCode());
            draftBill.set("promiserbanktext", (Object)syncData.getAcceptorBankName());
            draftBill.set("billno", (Object)syncData.getBillNo());
            draftBill.set("drafttype", (Object)syncData.getDraftType());
            draftBill.set("istransfer", (Object)("EM01".equals(syncData.getTransferFlag()) ? "0" : "1"));
            draftBill.set("collectionacctext", (Object)syncData.getPayeeAccNo());
            draftBill.set("collectionertext", (Object)syncData.getPayeeAccName());
            draftBill.set("collectionbanktext", (Object)syncData.getPayeeBankName());
            draftBill.set("fileid", (Object)syncData.getReserved1());
            draftBill.set("filename", (Object)syncData.getReserved2());
            draftBill.set("filepath", (Object)syncData.getReserved3());
            draftBill.set("fileencrypt", (Object)syncData.getReserveds());
            logger.info("EB status is:" + syncData.getEbStatus());
            if (EleDraftIsNewECDS.NEW.getValue().equals(syncData.getIsNewECDS())) {
                EleDraftNoteStatusEnum newNoteStatusEnum = EleDraftNoteStatusEnum.getByValue((String)syncData.getNoteStatus());
                if (null != newNoteStatusEnum || StringUtils.isNotEmpty((CharSequence)syncData.getNoteStatus())) {
                    draftBill.set("notestatus", (Object)(null == newNoteStatusEnum ? syncData.getNoteStatus() : newNoteStatusEnum.getValue()));
                }
                this.newEleInterfaceFields(draftBill, null, syncData);
                if (EleDraftNoteStatusEnum.CS02.getValue().equals(draftBill.getString("notestatus")) && EleDraftCirStatusEnum.TF0101.getValue().equals(draftBill.getString("cirstatus"))) {
                    draftBill.set("promiseinfo", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u5df2\u7ecf\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    draftBill.set("promisedate", (Object)new Date());
                }
                draftBill.set("uniquecode", (Object)(syncData.getSubRange().indexOf(",") > 0 ? draftBill.getString("billno") + "-" + EleDraftHelper.tranSubRangeStyle((String)syncData.getSubRange()) : draftBill.getString("billno")));
            } else {
                EleDraftBillStatusEnum noteStatusEnum = EleDraftBillStatusEnum.getByEbValue((String)syncData.getNoteStatus());
                draftBill.set("ticketstatus", (Object)(null == noteStatusEnum ? syncData.getNoteStatus() : noteStatusEnum.getValue()));
                if (EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue().equals(draftBill.getString("ticketstatus"))) {
                    draftBill.set("promiseinfo", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u5df2\u7ecf\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    draftBill.set("promisedate", (Object)new Date());
                }
                if (StringUtils.isEmpty((CharSequence)draftBill.getString("uniquecode"))) {
                    draftBill.set("uniquecode", (Object)draftBill.getString("billno"));
                }
            }
            if (StringUtils.isEmpty((CharSequence)draftBill.getString("initsubrange"))) {
                draftBill.set("initsubrange", (Object)EleDraftHelper.tranSubRangeStyle((String)syncData.getSubRange()));
            }
            if (draftBill.getBigDecimal("initamount").compareTo(new BigDecimal("0")) == 0) {
                draftBill.set("initamount", (Object)syncData.getAmount());
            }
            draftBill.set("ebseqid", (Object)syncData.getEbSeqID());
            draftBill.set("ebstatus", (Object)syncData.getEbStatus());
            draftBill.set("ebstatusmsg", (Object)syncData.getEbStatusMsg());
            draftBill.set("bankstatus", (Object)syncData.getBankStatus());
            draftBill.set("bankmsg", (Object)syncData.getBankMsg());
            draftBill.set("flowserialno", (Object)syncData.getFlowSerialNo());
            draftBill.set("rqstserialno", (Object)syncData.getRqstSerialNo());
            draftBill.set("rspserialno", (Object)syncData.getRspSerialNo());
            draftBill.set("bankconsultno", (Object)syncData.getBankRefKey());
        }
    }
}

