/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;

public class BankLogInfoElcFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BankLogInfo generateBankLogInfo(String billNo, Long orgId, Long sourceId) {
        Class<BankLogInfoElcFactory> clazz = BankLogInfoElcFactory.class;
        synchronized (BankLogInfoElcFactory.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return BankLogInfoElcFactory.logInfo(billNo, orgId, sourceId);
        }
    }

    private static BankLogInfo logInfo(String billNo, Long orgId, Long sourceId) {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setBillNo(billNo);
        logInfo.setEntityName("cdm_electronicbill");
        logInfo.setOrgid(orgId);
        logInfo.setSourceId(sourceId);
        return logInfo;
    }

    public static BankLogInfo generateBatchBankLog(List<DynamicObject> dataList) {
        BankLogInfo logInfo = new BankLogInfo();
        ArrayList<BankLogDetail> detailList = new ArrayList<BankLogDetail>(dataList.size());
        logInfo.setLogDetailList(detailList);
        String entityName = "cdm_electronicbill";
        BigDecimal totalAmt = BigDecimal.ZERO;
        Long currencyId = dataList.get(0).getLong("currencytext.id");
        DynamicObject bankAcct = dataList.get(0).getDynamicObject("company");
        long bankAcctCompanyId = bankAcct.getLong("id");
        logInfo.setOrgid(Long.valueOf(bankAcctCompanyId));
        for (DynamicObject data : dataList) {
            BankLogDetail bankDetail = new BankLogDetail();
            bankDetail.setBillId(Long.valueOf(data.getLong("id")));
            bankDetail.setBillNumber(data.getString("billno"));
            bankDetail.setBillType(entityName);
            bankDetail.setBillOrgId((Long)data.getDynamicObject("company").getPkValue());
            bankDetail.setAcctBankId(Long.valueOf(BankLogInfoElcFactory.getAccountBankByNumber(data.getString("conectno"))));
            bankDetail.setBillType(entityName);
            bankDetail.setPayAmt(data.getBigDecimal("amount"));
            totalAmt = totalAmt.add(bankDetail.getPayAmt());
            detailList.add(bankDetail);
        }
        logInfo.setPayTotalAmt(totalAmt);
        logInfo.setPayCurrencyId(currencyId);
        logInfo.setEntityName(entityName);
        return logInfo;
    }

    private static long getAccountBankByNumber(String number) {
        DynamicObject[] bankAccountsFromDB = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id", (QFilter[])new QFilter("number", "in", (Object)number).toArray());
        return bankAccountsFromDB.length > 0 ? bankAccountsFromDB[0].getLong("id") : 0L;
    }
}

