/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftBillUpdater;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.EleDraftBillSyncRequestBuilder;
import kd.tmc.cdm.business.ebservice.request.datasource.draftbill.EleDraftBillBatchRequestDataSource;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.business.service.billstorage.PayEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftBillSyncDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftBillSyncResponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.StringUtils;

public class EleDraftBillBatchSyncServiceImpl
implements IEBService<List<NoteResult>> {
    private static final Log logger = LogFactory.getLog(EleDraftBillBatchSyncServiceImpl.class);
    private final List<DynamicObject> bills;
    private final Map<Long, NoteResult> result;
    private final Map<String, DynamicObject> billMap;
    private final Map<String, DynamicObject> billNoMap;

    public EleDraftBillBatchSyncServiceImpl(List<DynamicObject> bills) {
        this.bills = bills;
        this.result = new HashMap<Long, NoteResult>(bills.size());
        this.billMap = bills.stream().collect(Collectors.toMap(o -> o.getString("id"), Function.identity(), (k1, k2) -> k1));
        this.billNoMap = bills.stream().collect(Collectors.toMap(o -> o.getString("billno") + "_" + o.getString("detailseqid"), Function.identity(), (k1, k2) -> k1));
        for (DynamicObject bill : bills) {
            NoteResult noteResult = new NoteResult();
            noteResult.setBillId(Long.valueOf(bill.getLong("id")));
            this.result.put(bill.getLong("id"), noteResult);
        }
    }

    public boolean validate() {
        return EleBillCommonHelper.isCorrectTimeToEB(new ArrayList<NoteResult>(this.result.values()), this.bills.get(0).getDynamicObject("company").getLong("id"));
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        for (NoteResult noteResult : this.result.values()) {
            noteResult.setStatusCode(EBResultStatusCode.ROLLBACK);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        for (NoteResult noteResult : this.result.values()) {
            noteResult.setStatusCode(EBResultStatusCode.ERROR);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleResultBody(String resultBody) {
        logger.info("EleDraftBillBatchSyncServiceImpl.handleResultBody do");
        DraftBillSyncResponseBody draftBillSyncResponseBody = (DraftBillSyncResponseBody)JSON.parseObject((String)resultBody, DraftBillSyncResponseBody.class);
        List detailList = draftBillSyncResponseBody.getDetails();
        Object[] elePkValues = detailList.stream().map(o -> Long.parseLong(o.getDetailSeqID())).toArray();
        DynamicObject[] updateBillDb = TmcDataServiceHelper.load((Object[])elePkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal"));
        Map<String, DynamicObject> updateBillDbMap = Arrays.stream(updateBillDb).collect(Collectors.toMap(o -> o.getString("id"), Function.identity(), (k1, k2) -> k1));
        for (DraftBillSyncDetail syncInfo : detailList) {
            DynamicObject bill = this.getUpdateBill(syncInfo, updateBillDbMap);
            if (bill == null) {
                NoteResult noteResult = new NoteResult();
                noteResult.setBillId(Long.valueOf(Long.parseLong(syncInfo.getDetailSeqID())));
                noteResult.setStatusCode(EBResultStatusCode.ERROR);
                noteResult.setErrMsg(ResManager.loadKDString((String)"\u94f6\u4f01\u8fd4\u56de\u7684detailSeqID\u4e0d\u5b58\u5728\u5bf9\u5e94\u6570\u636e", (String)"EleDraftBillQueryServiceImpl_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                this.result.put(Long.parseLong(syncInfo.getDetailSeqID()), noteResult);
                continue;
            }
            String batchSeqId = bill.getString("batchseqid");
            String resBatchSeqId = draftBillSyncResponseBody.getBatchSeqId();
            NoteResult noteResult = this.result.get(Long.parseLong(syncInfo.getDetailSeqID()));
            if (!batchSeqId.equals(resBatchSeqId)) {
                logger.info("EleDraftBillBatchSyncServiceImpl.handleResultBody batchSeqId is not equals bill batchSeqId = {},draftBillSyncResponseBody batchSeqId = {}", (Object)batchSeqId, (Object)resBatchSeqId);
                if (noteResult == null) continue;
                noteResult.setStatusCode(EBResultStatusCode.SUCCESS);
                continue;
            }
            if (EbStatus.BANK_SUCCESS.getName().equals(bill.getString("ebstatus"))) continue;
            DynamicObject company = bill.getDynamicObject("company");
            EleDraftBillUpdater.getInstance().syncUpdate(bill, syncInfo);
            bill.set("opstatus", (Object)DraftBillOpStatusEnum.SYNC_SUCCESS.getValue());
            if (noteResult != null) {
                noteResult.setStatusCode(EBResultStatusCode.SUCCESS);
            }
            boolean isFromAlloc = this.dealSameBillNo(bill);
            logger.info("is isFromAlloc that:" + isFromAlloc);
            String ebStatus = bill.getString("ebstatus");
            String tradeType = bill.getString("tradetype");
            String noteStatus = bill.getString("notestatus");
            String cirStatus = bill.getString("cirstatus");
            String ticketStatus = bill.getString("ticketstatus");
            BigDecimal locAmt = bill.getBigDecimal("locamt");
            if (EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(tradeType)) {
                if (StringUtils.equals((CharSequence)noteStatus, (CharSequence)EleDraftNoteStatusEnum.CS03.getValue()) && StringUtils.equals((CharSequence)cirStatus, (CharSequence)EleDraftCirStatusEnum.TF0304.getValue()) || StringUtils.equals((CharSequence)ticketStatus, (CharSequence)EleDraftBillStatusEnum.PLEDGESIGNED.getValue())) {
                    bill.set("querydrafttype", (Object)"");
                } else {
                    bill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                }
            } else if (EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && ElcDraftBillOpEnum.PRESENTPAYMENT.getValue().equals(tradeType)) {
                bill.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
            }
            String operationCode = bill.getString("operationcode");
            if ("02".equals(operationCode) || "20".equals(operationCode) || "21".equals(operationCode)) {
                bill.set("querydrafttype", (Object)EleDraftExistCatEnum.ACCEPTNOTE.getValue());
            }
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            if (!ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(tradeType) && !ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType) || ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType) && EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && locAmt.compareTo(new BigDecimal(syncInfo.getOppAmount())) == 0) {
                TXHandle handle = TX.notSupported();
                Throwable throwable = null;
                try {
                    try {
                        Object[] recBills;
                        logger.info("EleDraftBillBatchSyncServiceImpl.handleResultBody do RecEleBillStorageService.storage eleBillId = {}", bill.getPkValue());
                        List<StorageResult> storageResultList = RecEleBillStorageService.storage(Collections.singletonList(bill.getLong("id")), company);
                        StorageResult storageResult = storageResultList.get(0);
                        Long billId = storageResult.getBillId();
                        if (!isFromAlloc || !EmptyUtil.isNoEmpty((Object[])(recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,isfromalloc,billpool,poollockorg,poollockstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)})))) continue;
                        Object recBill = recBills[0];
                        recBill.set("isfromalloc", (Object)true);
                        recBill.set("billpool", null);
                        recBill.set("poollockstatus", (Object)"");
                        recBill.set("poollockorg", null);
                        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
                        continue;
                    }
                    catch (Exception e) {
                        if (noteResult != null) {
                            noteResult.setBillId(Long.valueOf(bill.getLong("id")));
                            noteResult.setStatusCode(EBResultStatusCode.ERROR);
                            noteResult.setErrMsg(ResManager.loadKDString((String)"\u8c03\u7528\u5165\u5e93\u6216\u53cd\u5199\u5f02\u5e38, \u8bf7\u6838\u5bf9", (String)"EleDraftBillQueryServiceImpl_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                        }
                        logger.error("EleDraftBillBatchSyncServiceImpl.handleResultBody do RecEleBillStorageService.storage eleBillId = {},error {}", bill.getPkValue(), (Object)e);
                        handle.markRollback();
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (handle == null) continue;
                    if (throwable != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    handle.close();
                    continue;
                }
            }
            logger.info("\u62d2\u6536/\u64a4\u9500\u64cd\u4f5c\u7684\u7535\u7968\u4e0d\u5165\u5e93\u5e94\u6536\u7968\u636e,noteNo = {},oldnoteStatus = {},newnoteStatus = {},cirstatus = {},tradeType = {}", new Object[]{bill.getString("billno"), bill.getString("ticketstatus"), bill.getString("notestatus"), bill.getString("cirstatus"), bill.getString("tradetype")});
        }
        logger.info("EleDraftBillBatchSyncServiceImpl.handleResultBody done");
    }

    private DynamicObject getUpdateBill(DraftBillSyncDetail syncInfo, Map<String, DynamicObject> updateBillDbMap) {
        if (this.billMap.get(syncInfo.getDetailSeqID()) == null) {
            if (updateBillDbMap.size() > 0) {
                return updateBillDbMap.get(syncInfo.getDetailSeqID());
            }
            if (this.billNoMap.get(syncInfo.getBillNo() + "_" + syncInfo.getDetailSeqID()) != null) {
                return this.billNoMap.get(syncInfo.getBillNo() + "_" + syncInfo.getDetailSeqID());
            }
            return null;
        }
        return this.billMap.get(syncInfo.getDetailSeqID());
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new EleDraftBillSyncRequestBuilder(new EleDraftBillBatchRequestDataSource(this.bills));
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoElcFactory.generateBatchBankLog(this.bills);
    }

    public List<NoteResult> getEBResult() {
        return new ArrayList<NoteResult>(this.result.values());
    }

    public String getServiceUrl() {
        return "/kapi/app/note/queryNoteReceivable";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((String)this.bills.get(0).getString("applicantacctext"));
    }

    private boolean dealSameBillNo(DynamicObject electBill) {
        boolean isFromAlloc = false;
        String tradeType = electBill.getString("tradetype");
        String ebStatus = electBill.getString("ebstatus");
        logger.info("EleDraftBillBatchSyncServiceImpl.dealSameBillNo noteNo = {}, tradeType = {} ,ebStatus = {}", new Object[]{electBill.getString("billno"), tradeType, ebStatus});
        if (ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(tradeType) && EbStatus.BANK_SUCCESS.getName().equals(ebStatus)) {
            QFilter eleRecQFilter = new QFilter("id", "!=", (Object)electBill.getLong("id"));
            eleRecQFilter.and("billno", "=", (Object)electBill.getString("billno"));
            eleRecQFilter.and(new QFilter("company.name", "=", (Object)electBill.getString("preholdername")).or(new QFilter("conectno", "=", (Object)electBill.getString("holderaccno"))));
            eleRecQFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
            eleRecQFilter.and(new QFilter("tradetype", "=", (Object)ElcDraftBillOpEnum.NOTEENDORSE.getValue()));
            if (electBill.getBoolean("grdbag")) {
                eleRecQFilter.and(new QFilter("notestatus", "=", (Object)EleDraftNoteStatusEnum.CS03.getValue()));
                eleRecQFilter.and(new QFilter("cirstatus", "in", (Object)new String[]{EleDraftCirStatusEnum.TF0301.getValue(), EleDraftCirStatusEnum.TF0302.getValue()}));
            } else {
                eleRecQFilter.and(new QFilter("ticketstatus", "=", (Object)EleDraftBillStatusEnum.RECITE.getValue()));
            }
            eleRecQFilter.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
            eleRecQFilter.and(new QFilter("ebstatus", "not in", (Object)new String[]{EbStatus.BANK_SUCCESS.getName(), EbStatus.BANK_FAIL.getName()}));
            DynamicObjectCollection electRecBills = QueryServiceHelper.query((String)"cdm_electronic_sign_deal", (String)"id", (QFilter[])new QFilter[]{eleRecQFilter});
            logger.info("EleDraftBillBatchSyncServiceImpl.dealSameBillNo noteId = {}, eleRecQFilter = {}, electRecBills.size= {}", new Object[]{electBill.getString("id"), eleRecQFilter.toString(), electRecBills.size()});
            if (electRecBills.size() > 0) {
                Object[] existEleRecIds = electRecBills.stream().map(o -> o.getLong("id")).toArray();
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\uff0c\u67e5\u8be2\u540c\u7968\u53f7id = %s", existEleRecIds));
                DynamicObject[] existElectRecBills = BusinessDataServiceHelper.load((Object[])existEleRecIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
                if (existElectRecBills.length == 0) {
                    return isFromAlloc;
                }
                for (DynamicObject existElectBill : existElectRecBills) {
                    long existEleRecId = existElectBill.getLong("id");
                    if (existElectBill.getBoolean("grdbag")) {
                        String recSubRangeStart;
                        String billSubRangeStart = existElectBill.getString("subrange").substring(0, existElectBill.getString("subrange").indexOf("-"));
                        if (!billSubRangeStart.equals(recSubRangeStart = electBill.getString("subrange").substring(0, electBill.getString("subrange").indexOf("-")))) continue;
                        existElectBill.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                        existElectBill.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
                        existElectBill.set("subrange", (Object)electBill.getString("subrange"));
                    } else {
                        existElectBill.set("ticketstatus", (Object)EleDraftBillStatusEnum.RECITESIGNED.getValue());
                    }
                    existElectBill.set("ebstatus", (Object)electBill.getString("ebstatus"));
                    EleDraftHelper.splitBill((DynamicObject)existElectBill);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existElectBill});
                    logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3id = %s", existEleRecId));
                    List<StorageResult> results = RecEleBillStorageService.storage(Collections.singletonList(existEleRecId), existElectRecBills[0].getDynamicObject("company"));
                    for (StorageResult storageResult : results) {
                        QFilter qFilter = new QFilter("entrys.draftbill.id", "=", (Object)storageResult.getBillId());
                        qFilter.and(new QFilter("entrys.billamt", "=", (Object)existElectBill.getLong("locamt")));
                        qFilter.and(new QFilter("isrepay", "=", (Object)"0"));
                        qFilter.and(new QFilter("billstatus", "!=", (Object)"S"));
                        qFilter.and(new QFilter("electag", "=", (Object)Boolean.TRUE));
                        DynamicObject[] draftTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u67e5\u8be2\u80cc\u4e66\u4e1a\u52a1\u5bf9\u5e94\u7684\u4e1a\u52a1\u5904\u7406\u5355draftTradeBills.length= %s", draftTradeBills.length));
                        if (!storageResult.getSuccess().booleanValue() || draftTradeBills.length <= 0) continue;
                        DynamicObject draftTradeBill = TmcDataServiceHelper.loadSingle((Object)draftTradeBills[0].getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
                        String sourceStr = draftTradeBill.getString("source");
                        DynamicObjectCollection entrys = draftTradeBill.getDynamicObjectCollection("entrys");
                        for (DynamicObject entry : entrys) {
                            DynamicObject draftBill = entry.getDynamicObject("draftbill");
                            if (!Objects.equals(storageResult.getBillId(), draftBill.getPkValue())) continue;
                            entry.set("isnotneedgen", (Object)Boolean.TRUE);
                            isFromAlloc = "cdm-draftallocate".equals(sourceStr);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{draftTradeBill});
                    }
                    logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3\u5b8c\u6210\uff0c\u8fd4\u56de\u4fe1\u606f %s", results.size() > 0 ? results.get(0).getBillId() + "_" + results.get(0).getErrMsg() : ""));
                }
            }
            QFilter elePayQFilter = new QFilter("id", "!=", (Object)electBill.getLong("id"));
            elePayQFilter.and("billno", "=", (Object)electBill.getString("billno"));
            elePayQFilter.and(new QFilter("company.name", "=", (Object)electBill.getString("preholdername")));
            if (electBill.getBoolean("grdbag")) {
                elePayQFilter.and(new QFilter("notestatus", "=", (Object)EleDraftNoteStatusEnum.CS02.getValue()));
                elePayQFilter.and(new QFilter("cirstatus", "=", (Object)EleDraftCirStatusEnum.TF0302.getValue()));
            } else {
                elePayQFilter.and(new QFilter("ticketstatus", "=", (Object)EleDraftBillStatusEnum.INVOICE.getValue()));
            }
            elePayQFilter.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()));
            DynamicObjectCollection electPayBills = QueryServiceHelper.query((String)"cdm_electronic_pay_deal", (String)"id", (QFilter[])new QFilter[]{elePayQFilter});
            logger.info("EleDraftBillBatchSyncServiceImpl.dealSameBillNo noteId = {}, eleRecQFilter = {}, electPayBills.size= {}", new Object[]{electBill.getString("id"), elePayQFilter.toString(), electPayBills.size()});
            if (electPayBills.size() == 1) {
                long existElectPayId = ((DynamicObject)electPayBills.get(0)).getLong("id");
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\uff0c\u67e5\u8be2\u540c\u7968\u53f7id = %s", existElectPayId));
                DynamicObject[] existElectPayBills = BusinessDataServiceHelper.load((Object[])new Object[]{existElectPayId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_pay_deal"));
                if (existElectPayBills.length == 0) {
                    return isFromAlloc;
                }
                for (DynamicObject existElectBill : existElectPayBills) {
                    if (existElectBill.getBoolean("grdbag")) {
                        existElectBill.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                        existElectBill.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
                    } else {
                        existElectBill.set("ticketstatus", (Object)EleDraftBillStatusEnum.INVOICESIGNED.getValue());
                    }
                    existElectBill.set("ebstatus", (Object)electBill.getString("ebstatus"));
                }
                SaveServiceHelper.save((DynamicObject[])existElectPayBills);
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3id = %s", existElectPayId));
                List<StorageResult> results = PayEleBillStorageService.storage(Collections.singletonList(existElectPayId), Boolean.TRUE);
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3\u5b8c\u6210\uff0c\u8fd4\u56de\u4fe1\u606f %s", results.size() > 0 ? results.get(0).getBillId() + "_" + results.get(0).getErrMsg() : ""));
            }
        }
        return isFromAlloc;
    }
}

