/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.EleDraftBillDiscountCalRequestBuilder;
import kd.tmc.cdm.business.ebservice.request.datasource.draftbill.EleDraftBillBatchRequestDataSource;
import kd.tmc.cdm.common.bean.DraftBillDiscountResponseBody;
import kd.tmc.cdm.common.bean.EleBillDiscountCalDetail;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;

public class EleDraftDiscountCalServiceImpl
implements IEBService<List<EleBillDiscountCalDetail>> {
    private static final Log logger = LogFactory.getLog(EleDraftDiscountCalServiceImpl.class);
    private List<DynamicObject> bills;
    private List<EleBillDiscountCalDetail> result;

    public EleDraftDiscountCalServiceImpl(List<DynamicObject> bills) {
        this.bills = bills;
        this.result = new ArrayList<EleBillDiscountCalDetail>(bills.size());
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
    }

    public void handleResultBody(String resultBody) {
        DraftBillDiscountResponseBody responseBody = (DraftBillDiscountResponseBody)JSON.parseObject((String)resultBody, DraftBillDiscountResponseBody.class);
        List detailList = responseBody.getDetails();
        if (detailList.size() > 0) {
            this.result = detailList;
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new EleDraftBillDiscountCalRequestBuilder(new EleDraftBillBatchRequestDataSource(this.bills));
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoElcFactory.generateBatchBankLog(this.bills);
    }

    public List<EleBillDiscountCalDetail> getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/note/queryNoteInfo";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((String)this.bills.get(0).getString("applicantacctext"));
    }
}

