/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftBillUpdater;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.EleDraftBillQueryRequestBuilder;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.business.service.billstorage.RecEleBillUpdateService;
import kd.tmc.cdm.common.bean.EleDraftBillQueryInfo;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillQueryRequestBody;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillQueryResponseBody;

public class EleDraftOnlineUpServiceImpl
implements IEBService<List<NoteResult>> {
    private static final Log logger = LogFactory.getLog(EleDraftOnlineUpServiceImpl.class);
    private final List<NoteResult> resultList = new ArrayList<NoteResult>(10);
    private final DynamicObject bill;
    private final EleDraftBillQueryInfo eleDraftBillQueryInfo;

    public EleDraftOnlineUpServiceImpl(EleDraftBillQueryInfo eleDraftBillQueryInfo) {
        this.bill = eleDraftBillQueryInfo.getObj();
        this.eleDraftBillQueryInfo = eleDraftBillQueryInfo;
    }

    public IEBRequestBuilder getRequestBuilder() {
        DraftBillQueryRequestBody body = new DraftBillQueryRequestBody();
        body.setDraftType(this.bill.getString("drafttype"));
        body.setTranType("99");
        body.setNoteNo(this.bill.getString("billno"));
        body.setDraftType(this.bill.getString("drafttype"));
        String noteStatus = this.bill.getString("notestatus");
        String isNewECDS = EleDraftHelper.isNewECDs((String)noteStatus, (String)"");
        body.setIsNewECDS(isNewECDS);
        if (EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS)) {
            body.setSubRange(EleDraftHelper.tranSubRangeToYQ((String)this.bill.getString("subrange")));
            body.setGrdBag(this.bill.getBoolean("grdbag") ? "1" : "0");
            if (!this.bill.getBoolean("grdbag")) {
                body.setSubRange("0");
            }
        }
        return new EleDraftBillQueryRequestBuilder(body, this.eleDraftBillQueryInfo);
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        DynamicObject[] accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.eleDraftBillQueryInfo.getAcct())});
        return BankLogInfoElcFactory.generateBankLogInfo(this.bill.getString("billno"), accountBank[0].getDynamicObject("company").getLong("id"), null);
    }

    public List<NoteResult> getEBResult() {
        return this.resultList;
    }

    public boolean validate() {
        return EleBillCommonHelper.isCorrectTimeToEB(this.resultList, this.bill.getDynamicObject("company").getLong("id"));
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        NoteResult result = new NoteResult();
        result.setStatusCode(EBResultStatusCode.ROLLBACK);
        result.setErrMsg(errMsg);
        this.resultList.clear();
        this.resultList.add(result);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        NoteResult result = new NoteResult();
        result.setStatusCode(EBResultStatusCode.ERROR);
        result.setErrMsg(errMsg);
        this.resultList.clear();
        this.resultList.add(result);
    }

    public void handleResultBody(String resultBody) {
        logger.info("EleDraftOnlineUpServiceImpl handleResultBody resultBody is that:" + resultBody);
        try (TXHandle tx = TX.requiresNew();){
            DraftBillQueryResponseBody draftBillQueryResponseBody = (DraftBillQueryResponseBody)JSON.parseObject((String)resultBody, DraftBillQueryResponseBody.class);
            List draftInfoList = draftBillQueryResponseBody.getDetails();
            if (draftInfoList.size() == 1) {
                DraftBillInfo syncInfo = (DraftBillInfo)draftInfoList.get(0);
                EleDraftBillUpdater.getInstance().queryUpdate(this.bill, syncInfo, this.eleDraftBillQueryInfo.getAcct(), this.eleDraftBillQueryInfo.getBizSubType());
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bill});
            }
            RecEleBillUpdateService.updateDraftInfo(this.bill);
        }
    }

    public String getServiceUrl() {
        return "/kapi/app/note/queryNoteDetail";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((DynamicObject)this.eleDraftBillQueryInfo.getObj());
    }
}

