/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftPayBillUpdater;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.ElePayDraftBillSyncRequestBuilder;
import kd.tmc.cdm.business.ebservice.request.datasource.draftbill.EleDraftBillBatchRequestDataSource;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.business.service.billstorage.PayEleBillStorageService;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftPayBillSyncDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftPayBillSyncResponseBody;

public class ElePayDraftBillBatchSyncServiceImpl
implements IEBService<List<NoteResult>> {
    private static final Log logger = LogFactory.getLog(ElePayDraftBillBatchSyncServiceImpl.class);
    private final List<DynamicObject> bills;
    private final List<NoteResult> result;

    public ElePayDraftBillBatchSyncServiceImpl(List<DynamicObject> bills) {
        this.bills = bills;
        this.result = new ArrayList<NoteResult>(bills.size());
        for (DynamicObject bill : bills) {
            NoteResult noteResult = new NoteResult();
            noteResult.setBillId(Long.valueOf(bill.getLong("id")));
            this.result.add(noteResult);
        }
    }

    public boolean validate() {
        return EleBillCommonHelper.isCorrectTimeToEB(this.result, this.bills.get(0).getDynamicObject("company").getLong("id"));
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ROLLBACK);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ERROR);
            noteResult.setErrMsg(errMsg);
        }
        for (DynamicObject bill : this.bills) {
            bill.set("opstatus", (Object)DraftBillOpStatusEnum.SYNC_FAIL.getValue());
        }
        TmcDataServiceHelper.save((DynamicObject[])this.bills.toArray(new DynamicObject[0]));
    }

    public void handleResultBody(String resultBody) {
        DraftPayBillSyncResponseBody draftBillSyncResponseBody = (DraftPayBillSyncResponseBody)JSON.parseObject((String)resultBody, DraftPayBillSyncResponseBody.class);
        List detailList = draftBillSyncResponseBody.getDetails();
        try (TXHandle tx = TX.requiresNew();){
            for (DraftPayBillSyncDetail syncInfo : detailList) {
                DynamicObject bill = this.getUpdateBill(syncInfo);
                if (bill == null) continue;
                EleDraftPayBillUpdater.getInstance().syncUpdate(bill, syncInfo);
                String batchSeqId = bill.getString("batchseqid");
                String resBatchSeqId = draftBillSyncResponseBody.getBatchSeqId();
                if (!batchSeqId.equals(resBatchSeqId)) {
                    logger.info("ElePayDraftBillBatchSyncServiceImpl.handleResultBody batchSeqId is not equals bill batchSeqId = {},draftBillSyncResponseBody batchSeqId = {}", (Object)batchSeqId, (Object)resBatchSeqId);
                    for (NoteResult noteResult : this.result) {
                        if (!syncInfo.getDetailSeqID().equals(noteResult.getBillId().toString())) continue;
                        noteResult.setStatusCode(EBResultStatusCode.SUCCESS);
                    }
                    continue;
                }
                bill.set("opstatus", (Object)DraftBillOpStatusEnum.SYNC_SUCCESS.getValue());
                for (NoteResult noteResult : this.result) {
                    if (!syncInfo.getDetailSeqID().equals(noteResult.getBillId().toString())) continue;
                    noteResult.setStatusCode(EBResultStatusCode.SUCCESS);
                }
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                logger.info(String.format("\u8c03\u7528\u5f00\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3\uff0c%s", JSON.toJSONString(Collections.singletonList(bill.getPkValue()))));
                try {
                    PayEleBillStorageService.storage(Collections.singletonList(bill.getPkValue() == null ? 0L : Long.parseLong(bill.getPkValue().toString())), Boolean.FALSE);
                }
                catch (Exception e) {
                    logger.error(String.format("\u8c03\u7528\u5f00\u7968\u767b\u8bb0\u5165\u5e93\u5f02\u5e38\uff0c%s", bill.getLong("id")));
                    for (NoteResult noteResult : this.result) {
                        if (!syncInfo.getDetailSeqID().equals(noteResult.getBillId().toString())) continue;
                        noteResult.setBillId(Long.valueOf(bill.getLong("id")));
                        noteResult.setStatusCode(EBResultStatusCode.ERROR);
                        noteResult.setErrMsg(ResManager.loadKDString((String)"\u8c03\u7528\u5165\u5e93\u6216\u53cd\u5199\u5f02\u5e38, \u8bf7\u6838\u5bf9", (String)"EleDraftBillQueryServiceImpl_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private DynamicObject getUpdateBill(DraftPayBillSyncDetail syncInfo) {
        Map billMap = this.bills.stream().collect(Collectors.toMap(o -> o.getString("id"), Function.identity(), (k1, k2) -> k1));
        if (billMap.get(syncInfo.getDetailSeqID()) == null) {
            DynamicObject[] updateBillDb = TmcDataServiceHelper.load((Object[])new Object[]{syncInfo.getDetailSeqID()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_pay_deal"));
            if (updateBillDb.length > 0) {
                return updateBillDb[0];
            }
            return null;
        }
        return (DynamicObject)billMap.get(syncInfo.getDetailSeqID());
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new ElePayDraftBillSyncRequestBuilder(new EleDraftBillBatchRequestDataSource(this.bills));
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoElcFactory.generateBatchBankLog(this.bills);
    }

    public List<NoteResult> getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/note/queryNotePayable";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((String)this.bills.get(0).getString("applicantacctext"));
    }
}

