/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class ElectRecClaimRuleHelper {
    private static final Log logger = LogFactory.getLog(ElectRecClaimRuleHelper.class);

    public static DynamicObject getClaimInfoByNoticeRule(Long sourceId, String handleScheme) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        QFilter filter = new QFilter("id", "=", (Object)sourceId);
        Object[] cdmElectRecBill = BusinessDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id,company", (QFilter[])new QFilter[]{filter});
        DynamicObject eleNoticeRule = null;
        if (!ObjectUtils.isEmpty((Object[])cdmElectRecBill) && (eleNoticeRule = ElectRecClaimRuleHelper.getEleNoticeRule((DynamicObject)cdmElectRecBill[0], handleScheme)) == null) {
            return null;
        }
        DynamicObjectCollection ElectRecBillDys = ElectRecClaimRuleHelper.getElectRecBillDy(fldProperties, new QFilter[]{filter});
        if (!ObjectUtils.isEmpty((Object)ElectRecBillDys) && !ObjectUtils.isEmpty((Object)eleNoticeRule)) {
            ArrayList entryEntity;
            ArrayList arrayList = entryEntity = eleNoticeRule == null ? null : new ArrayList(eleNoticeRule.getDynamicObjectCollection("rule_entity"));
            if (StringUtils.isNotEmpty((CharSequence)handleScheme)) {
                List list = entryEntity = eleNoticeRule == null ? null : eleNoticeRule.getDynamicObjectCollection("rule_entity").stream().filter(o -> handleScheme.equals(o.getString("e_handlescheme"))).collect(Collectors.toList());
            }
            if (null != entryEntity) {
                for (DynamicObject entryRule : entryEntity) {
                    if (!ElectRecClaimRuleHelper.isMatchRule(entryRule, (DynamicObject)ElectRecBillDys.get(0), fldProperties)) continue;
                    return entryRule;
                }
            }
        }
        return null;
    }

    public static DynamicObject getClaimInfoByNoticeRule(DynamicObject cdmElectRecBill, String handleScheme) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(8);
        DynamicObject eleNoticeRule = null;
        if (!ObjectUtils.isEmpty((Object)cdmElectRecBill) && (eleNoticeRule = ElectRecClaimRuleHelper.getEleNoticeRule(cdmElectRecBill, handleScheme)) == null) {
            return null;
        }
        DynamicObjectCollection ElectRecBillDys = ElectRecClaimRuleHelper.getElectRecBillDy(fldProperties, cdmElectRecBill);
        if (!ObjectUtils.isEmpty((Object)ElectRecBillDys) && !ObjectUtils.isEmpty((Object)eleNoticeRule)) {
            DynamicObjectCollection entryEntity;
            DynamicObjectCollection dynamicObjectCollection = entryEntity = eleNoticeRule == null ? null : eleNoticeRule.getDynamicObjectCollection("rule_entity");
            if (null != entryEntity) {
                for (DynamicObject entryRule : entryEntity) {
                    if (!ElectRecClaimRuleHelper.isMatchRule(entryRule, (DynamicObject)ElectRecBillDys.get(0), fldProperties)) continue;
                    return entryRule;
                }
            }
        }
        return null;
    }

    private static DynamicObject getEleNoticeRule(DynamicObject cdmElectRecBill, String handleScheme) {
        QFilter ruleCommonFilter = ElectRecClaimRuleHelper.getRuleCommonFilter(cdmElectRecBill, false, handleScheme);
        String properties = "org_entry.u_org,rule_entity.e_rulesname,rule_entity.e_datafilterdesc,rule_entity.e_datafilter_TAG,rule_entity.e_datafilter,rule_entity.e_remark,rule_entity.e_savenotifi,rule_entity.e_savenotifi_TAG,rule_entity.e_handlescheme,rule_entity.e_refuseremark";
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"cdm_ele_notice_rule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
        if (rules.length == 0) {
            ruleCommonFilter = ElectRecClaimRuleHelper.getRuleCommonFilter(cdmElectRecBill, true, handleScheme);
            rules = BusinessDataServiceHelper.load((String)"cdm_ele_notice_rule", (String)properties, (QFilter[])new QFilter[]{ruleCommonFilter});
        }
        if (rules.length == 0) {
            return null;
        }
        return rules[0];
    }

    private static QFilter getRuleCommonFilter(DynamicObject cdmElectRecBill, Boolean isFaceAllOrg, String handleScheme) {
        Object company = cdmElectRecBill.get("company.id");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.isNotEmpty((CharSequence)handleScheme)) {
            filter.and(new QFilter("rule_entity.e_handlescheme", "=", (Object)handleScheme));
        }
        if (!isFaceAllOrg.booleanValue()) {
            filter.and(new QFilter("org_entry.u_org", "=", company));
        } else {
            filter.and(QFilter.isNull((String)"org_entry.u_org"));
        }
        return filter;
    }

    private static boolean isMatchRule(DynamicObject entryRule, DynamicObject ElectRecBillDy, Map<String, DynamicProperty> fldProperties) {
        boolean isMatchRule = false;
        String filterStr = entryRule.getString("e_datafilter_TAG");
        if (!ObjectUtils.isEmpty((Object)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, ElectRecBillDy, null);
                    if (baseBoolean.booleanValue()) {
                        isMatchRule = true;
                    }
                }
                catch (Exception ee) {
                    logger.error((Throwable)ee);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    private static DynamicObjectCollection getElectRecBillDy(Map<String, DynamicProperty> fldProperties, QFilter[] filters) {
        DynamicObjectCollection rows;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        String selectString = StringUtils.join((Object[])selProps.toArray(new Object[selProps.size()]), (String)",");
        DataSet dsn = QueryServiceHelper.queryDataSet((String)ElectRecClaimRuleHelper.class.getName(), (String)"cdm_electronic_sign_deal", (String)selectString, (QFilter[])filters, null);
        Object object = null;
        try {
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Throwable bdProperties) {
            object = bdProperties;
            throw bdProperties;
        }
        finally {
            if (dsn != null) {
                if (object != null) {
                    try {
                        dsn.close();
                    }
                    catch (Throwable bdProperties) {
                        ((Throwable)object).addSuppressed(bdProperties);
                    }
                } else {
                    dsn.close();
                }
            }
        }
        if (rows != null && rows.size() > 0) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (String prop : selProps) {
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        int rowSize = rows == null ? 0 : rows.size();
        logger.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u5f85\u7b7e\u6536\u7968\u636e\u6570\u91cf\u4e3a: " + rowSize + "");
        return rows;
    }

    private static DynamicObjectCollection getElectRecBillDy(Map<String, DynamicProperty> fldProperties, DynamicObject cdmElectRecBill) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
        ArrayList<Object> selProps = new ArrayList<Object>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            Object propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || ((String)(propName = property.getName())).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = basedataProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = (String)propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectCollection rows = new DynamicObjectCollection();
        rows.add((Object)cdmElectRecBill);
        DynamicObjectType dType = cdmElectRecBill.getDynamicObjectType();
        for (String string : selProps) {
            fldProperties.put(string, dType.getProperty(string));
        }
        int rowSize = rows.size();
        logger.info("\u5f97\u5230\u8f6c\u6362\u540e\u7684\u5f85\u7b7e\u6536\u7968\u636e\u6570\u91cf\u4e3a: " + rowSize + "");
        return rows;
    }

    public static void cancelWriteClaimNo(Object[] electSignIds) {
        if (electSignIds != null && electSignIds.length != 0) {
            DynamicObject[] electSigns;
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal");
            Object[] longElectSignIds = new Long[electSignIds.length];
            for (Object electSignId : electSignIds) {
                if (electSignId instanceof String && !StringUtils.isBlank((Object)electSignId)) {
                    longElectSignIds[0] = Long.valueOf((String)electSignId);
                    continue;
                }
                assert (electSignId instanceof Long);
                longElectSignIds[0] = (Long)electSignId;
            }
            for (DynamicObject electSign : electSigns = BusinessDataServiceHelper.load((Object[])longElectSignIds, (DynamicObjectType)type)) {
                electSign.set("signnoticebill", (Object)"");
            }
            Object[] objects = SaveServiceHelper.save((DynamicObject[])electSigns);
            if (objects == null || objects.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u5355\u66f4\u65b0\u5931\u8d25", (String)"RecClaimBillHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
    }

    public static void recBillNoticeFromEle(Long cdmRecBillId) {
        DynamicObject[] existRecBill = TmcDataServiceHelper.load((Object[])new Object[]{cdmRecBillId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
        if (existRecBill.length == 0) {
            logger.info("ElectRecClaimRuleHelper.RecBillNoticeFromEle existRecBill.length = {}", (Object)existRecBill.length);
            return;
        }
        DynamicObject cdmRecBill = existRecBill[0];
        String draftBillNo = cdmRecBill.getString("draftbillno");
        String source = cdmRecBill.getString("source");
        long sourceBillId = cdmRecBill.getLong("sourcebillid");
        String sourceBillType = cdmRecBill.getString("sourcebilltype");
        String claimNoticeBillNo = cdmRecBill.getString("claimnoticebillno");
        if ("bei".equals(source) && "cdm_electronicbill".equals(sourceBillType) && sourceBillId > 0L && StringUtils.isNotEmpty((CharSequence)claimNoticeBillNo)) {
            QFilter claimFilter = new QFilter("sourceid", "=", (Object)String.valueOf(sourceBillId));
            claimFilter.and(new QFilter("datasource", "=", (Object)"elerecticket"));
            claimFilter.and(new QFilter("claimstatus", "in", (Object)new String[]{"2", "3", "4", "5"}));
            DynamicObject[] claimCenterBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,datasource,sourceid,sourcetype", (QFilter[])new QFilter[]{claimFilter});
            logger.info("ElectRecClaimRuleHelper.RecBillNoticeFromEle draftBillNo ={},claimCenterBills.length = {}", (Object)draftBillNo, (Object)claimCenterBills.length);
            if (claimCenterBills.length > 0) {
                long claimCenterBillId = claimCenterBills[0].getLong("id");
                QFilter casRecBillFilter = new QFilter("sourcebillid", "=", (Object)claimCenterBillId);
                casRecBillFilter.and(new QFilter("sourcebilltype", "=", (Object)"cas_claimcenterbill"));
                DynamicObject[] casRecBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billno,settletnumber,cas_draftinfo,draftbill,cas_draftinfo.draftbillinfo,cas_draftinfo.transamount,cas_draftinfo.recbillcurrency", (QFilter[])new QFilter[]{casRecBillFilter});
                logger.info("ElectRecClaimRuleHelper.RecBillNoticeFromEle draftBillNo ={},casRecBills.length = {}", (Object)draftBillNo, (Object)casRecBills.length);
                if (casRecBills.length > 0) {
                    casRecBills = BusinessDataServiceHelper.load((Object[])new Object[]{casRecBills[0].getPkValue()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
                    DynamicObject casRecBill = casRecBills[0];
                    DynamicObjectCollection draftBills = casRecBill.getDynamicObjectCollection("draftbill");
                    casRecBill.set("settletnumber", (Object)draftBillNo);
                    DynamicObject payEntry = draftBills.addNew();
                    payEntry.set("fbasedataid", (Object)cdmRecBill);
                    payEntry.set("fbasedataid_id", cdmRecBill.getPkValue());
                    DynamicObjectCollection draftInfoEntries = casRecBill.getDynamicObjectCollection("cas_draftinfo");
                    CasHelper.addCasRecDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject[])new DynamicObject[]{cdmRecBill});
                    try (TXHandle tx = TX.requiresNew();){
                        OperateOption operateOption = OperateOption.create();
                        operateOption.setVariableValue("fromRecClaim", "true");
                        OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)operateOption);
                        logger.info("ElectRecClaimRuleHelper.RecBillNoticeFromEle casRecBill = {},operationResult.isSuccess = {},operationResult = {}", new Object[]{casRecBill.getString("billno"), operationResult.isSuccess(), ElectRecClaimRuleHelper.decodeMultiErrorMessage(operationResult)});
                    }
                }
            }
        }
    }

    private static String decodeMultiErrorMessage(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo iOperateInfo : errorInfos) {
            String message = iOperateInfo.getMessage();
            Long pkValue = (Long)iOperateInfo.getPkValue();
            stringBuilder.append(pkValue).append(":");
            stringBuilder.append(message).append(";");
        }
        return stringBuilder.toString();
    }
}

